/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.application.rules.action;

import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.Scope;
import org.elasticsearch.rest.ServerlessScope;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.xpack.application.EnterpriseSearchBaseRestHandler;
import org.elasticsearch.xpack.application.rules.action.ListQueryRulesetsAction;
import org.elasticsearch.xpack.application.utils.LicenseUtils;
import org.elasticsearch.xpack.core.action.util.PageParams;

@ServerlessScope(value=Scope.PUBLIC)
public class RestListQueryRulesetsAction
extends EnterpriseSearchBaseRestHandler {
    public RestListQueryRulesetsAction(XPackLicenseState licenseState) {
        super(licenseState, LicenseUtils.Product.QUERY_RULES);
    }

    public String getName() {
        return "query_ruleset_list_action";
    }

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.GET, "/_query_rules"));
    }

    @Override
    protected BaseRestHandler.RestChannelConsumer innerPrepareRequest(RestRequest restRequest, NodeClient client) {
        int from = restRequest.paramAsInt("from", 0);
        int size = restRequest.paramAsInt("size", 100);
        ListQueryRulesetsAction.Request request = new ListQueryRulesetsAction.Request(new PageParams(from, size));
        return channel -> client.execute((ActionType)ListQueryRulesetsAction.INSTANCE, (ActionRequest)request, (ActionListener)new RestToXContentListener(channel));
    }
}

