/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.application.analytics.action;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.AcknowledgedTransportMasterNodeAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.application.analytics.AnalyticsCollectionService;
import org.elasticsearch.xpack.application.analytics.action.DeleteAnalyticsCollectionAction;

public class TransportDeleteAnalyticsCollectionAction
extends AcknowledgedTransportMasterNodeAction<DeleteAnalyticsCollectionAction.Request> {
    private final AnalyticsCollectionService analyticsCollectionService;

    @Inject
    public TransportDeleteAnalyticsCollectionAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, AnalyticsCollectionService analyticsCollectionService) {
        super("cluster:admin/xpack/application/analytics/delete", transportService, clusterService, threadPool, actionFilters, DeleteAnalyticsCollectionAction.Request::new, indexNameExpressionResolver, "same");
        this.analyticsCollectionService = analyticsCollectionService;
    }

    protected ClusterBlockException checkBlock(DeleteAnalyticsCollectionAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }

    protected void masterOperation(Task task, DeleteAnalyticsCollectionAction.Request request, ClusterState state, ActionListener<AcknowledgedResponse> listener) {
        this.analyticsCollectionService.deleteAnalyticsCollection(state, request, (ActionListener<AcknowledgedResponse>)listener.map(v -> AcknowledgedResponse.TRUE));
    }
}

