/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.downsample;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.TransportAction;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.IndexShardRoutingTable;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.shard.ShardNotFoundException;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.persistent.AllocatedPersistentTask;
import org.elasticsearch.persistent.PersistentTaskState;
import org.elasticsearch.persistent.PersistentTasksCustomMetadata;
import org.elasticsearch.persistent.PersistentTasksExecutor;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.sort.SortOrder;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.downsample.DownsampleShardIndexerStatus;
import org.elasticsearch.xpack.core.downsample.DownsampleShardPersistentTaskState;
import org.elasticsearch.xpack.core.downsample.DownsampleShardTask;
import org.elasticsearch.xpack.downsample.DownsampleShardIndexer;
import org.elasticsearch.xpack.downsample.DownsampleShardIndexerException;
import org.elasticsearch.xpack.downsample.DownsampleShardTaskParams;

public class DownsampleShardPersistentTaskExecutor
extends PersistentTasksExecutor<DownsampleShardTaskParams> {
    private static final Logger LOGGER = LogManager.getLogger(DownsampleShardPersistentTaskExecutor.class);
    private final Client client;

    public DownsampleShardPersistentTaskExecutor(Client client, String taskName, String executorName) {
        super(taskName, executorName);
        this.client = Objects.requireNonNull(client);
    }

    protected void nodeOperation(AllocatedPersistentTask task, DownsampleShardTaskParams params, PersistentTaskState state) {
        SearchRequest searchRequest = new SearchRequest(new String[]{params.downsampleIndex()});
        searchRequest.source().sort("_tsid", SortOrder.DESC).size(1);
        searchRequest.preference("_shards:" + params.shardId().id());
        this.client.search(searchRequest, ActionListener.wrap(searchResponse -> this.delegate(task, params, searchResponse.getHits().getHits()), e -> this.delegate(task, params, new SearchHit[0])));
    }

    protected AllocatedPersistentTask createTask(long id, String type, String action, TaskId parentTaskId, PersistentTasksCustomMetadata.PersistentTask<DownsampleShardTaskParams> taskInProgress, Map<String, String> headers) {
        DownsampleShardTaskParams params = (DownsampleShardTaskParams)taskInProgress.getParams();
        return new DownsampleShardTask(id, type, action, parentTaskId, params.downsampleIndex(), params.indexStartTimeMillis(), params.indexEndTimeMillis(), params.downsampleConfig(), headers, params.shardId());
    }

    public void validate(DownsampleShardTaskParams params, ClusterState clusterState) {
        IndexShardRoutingTable indexShardRouting = clusterState.routingTable().shardRoutingTable(params.shardId().getIndexName(), params.shardId().id());
        if (indexShardRouting == null) {
            throw new ShardNotFoundException(params.shardId());
        }
    }

    public PersistentTasksCustomMetadata.Assignment getAssignment(DownsampleShardTaskParams params, Collection<DiscoveryNode> candidateNodes, ClusterState clusterState) {
        ShardId shardId = params.shardId();
        IndexShardRoutingTable indexShardRouting = clusterState.routingTable().shardRoutingTable(params.shardId().getIndexName(), params.shardId().id());
        if (indexShardRouting == null) {
            DiscoveryNode node2 = this.selectLeastLoadedNode(clusterState, candidateNodes, DiscoveryNode::canContainData);
            return new PersistentTasksCustomMetadata.Assignment(node2.getId(), "a node to fail and stop this persistent task");
        }
        ShardRouting shardRouting = clusterState.routingTable().shardRoutingTable(shardId).primaryShard();
        if (!shardRouting.started()) {
            return NO_NODE_FOUND;
        }
        return candidateNodes.stream().filter(candidateNode -> candidateNode.getId().equals(shardRouting.currentNodeId())).findAny().map(node -> new PersistentTasksCustomMetadata.Assignment(node.getId(), "downsampling using node holding shard [" + shardId + "]")).orElse(NO_NODE_FOUND);
    }

    public String getExecutor() {
        return "same";
    }

    private void delegate(AllocatedPersistentTask task, DownsampleShardTaskParams params, SearchHit[] lastDownsampledTsidHits) {
        this.client.execute((ActionType)DelegatingAction.INSTANCE, (ActionRequest)new DelegatingAction.Request((DownsampleShardTask)task, lastDownsampledTsidHits, params), ActionListener.wrap(empty -> {}, e -> {
            LOGGER.error("error while delegating", (Throwable)e);
            DownsampleShardPersistentTaskExecutor.markAsFailed(task, e);
        }));
    }

    static void realNodeOperation(final Client client, final IndicesService indicesService, final DownsampleShardTask task, final DownsampleShardTaskParams params, final SearchHit[] lastDownsampleTsidHits) {
        client.threadPool().executor("downsample_indexing").execute((Runnable)new AbstractRunnable(){

            public void onFailure(Exception e) {
                DownsampleShardPersistentTaskExecutor.markAsFailed((AllocatedPersistentTask)task, e);
            }

            protected void doRun() throws Exception {
                DownsampleShardPersistentTaskState initialState = lastDownsampleTsidHits.length == 0 ? new DownsampleShardPersistentTaskState(DownsampleShardIndexerStatus.INITIALIZED, null) : new DownsampleShardPersistentTaskState(DownsampleShardIndexerStatus.STARTED, (BytesRef)Arrays.stream(lastDownsampleTsidHits).findFirst().get().field("_tsid").getValue());
                try {
                    DownsampleShardIndexer downsampleShardIndexer = new DownsampleShardIndexer(task, client, indicesService.indexService(params.shardId().getIndex()), params.shardId(), params.downsampleIndex(), params.downsampleConfig(), params.metrics(), params.labels(), initialState);
                    downsampleShardIndexer.execute();
                    task.markAsCompleted();
                }
                catch (DownsampleShardIndexerException e) {
                    if (e.isRetriable()) {
                        LOGGER.warn("Downsampling task [" + task.getPersistentTaskId() + " retriable failure [" + e.getMessage() + "]");
                        task.markAsLocallyAborted(e.getMessage());
                    } else {
                        LOGGER.error("Downsampling task [" + task.getPersistentTaskId() + " non retriable failure [" + e.getMessage() + "]");
                        DownsampleShardPersistentTaskExecutor.markAsFailed((AllocatedPersistentTask)task, (Exception)((Object)e));
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Downsampling task [" + task.getPersistentTaskId() + " non-retriable failure [" + e.getMessage() + "]");
                    DownsampleShardPersistentTaskExecutor.markAsFailed((AllocatedPersistentTask)task, e);
                }
            }
        });
    }

    private static void markAsFailed(AllocatedPersistentTask task, Exception e) {
        task.updatePersistentTaskState((PersistentTaskState)new DownsampleShardPersistentTaskState(DownsampleShardIndexerStatus.FAILED, null), ActionListener.running(() -> task.markAsFailed(e)));
    }

    public static class DelegatingAction
    extends ActionType<ActionResponse.Empty> {
        public static final DelegatingAction INSTANCE = new DelegatingAction();
        public static final String NAME = "indices:data/read/downsample_delegate";

        private DelegatingAction() {
            super(NAME, in -> new ActionResponse.Empty());
        }

        public static class TA
        extends TransportAction<Request, ActionResponse.Empty> {
            private final Client client;
            private final IndicesService indicesService;

            @Inject
            public TA(TransportService transportService, ActionFilters actionFilters, Client client, IndicesService indicesService) {
                super(DelegatingAction.NAME, actionFilters, transportService.getTaskManager());
                this.client = client;
                this.indicesService = indicesService;
            }

            protected void doExecute(Task t, Request request, ActionListener<ActionResponse.Empty> listener) {
                DownsampleShardPersistentTaskExecutor.realNodeOperation(this.client, this.indicesService, request.task, request.params, request.lastDownsampleTsidHits);
                listener.onResponse((Object)ActionResponse.Empty.INSTANCE);
            }
        }

        public static class Request
        extends ActionRequest
        implements IndicesRequest {
            private final DownsampleShardTask task;
            private final SearchHit[] lastDownsampleTsidHits;
            private final DownsampleShardTaskParams params;

            public Request(DownsampleShardTask task, SearchHit[] lastDownsampleTsidHits, DownsampleShardTaskParams params) {
                this.task = task;
                this.lastDownsampleTsidHits = lastDownsampleTsidHits;
                this.params = params;
            }

            public ActionRequestValidationException validate() {
                return null;
            }

            public String[] indices() {
                return new String[]{this.params.shardId().getIndexName()};
            }

            public IndicesOptions indicesOptions() {
                return IndicesOptions.STRICT_EXPAND_OPEN;
            }

            public void writeTo(StreamOutput out) {
                throw new IllegalStateException("request should stay local");
            }
        }
    }
}

