/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.downsample;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.document.SortedSetDocValuesField;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkProcessor2;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.downsample.DownsampleConfig;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexRequestBuilder;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.common.Rounding;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.core.IOUtils;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.fielddata.FormattedDocValues;
import org.elasticsearch.index.mapper.DateFieldMapper;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.persistent.PersistentTaskState;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.AggregationExecutionContext;
import org.elasticsearch.search.aggregations.BucketCollector;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.aggregations.bucket.DocCountProvider;
import org.elasticsearch.search.aggregations.support.TimeSeriesIndexSearcher;
import org.elasticsearch.tasks.TaskCancelledException;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.core.downsample.DownsampleAfterBulkInfo;
import org.elasticsearch.xpack.core.downsample.DownsampleBeforeBulkInfo;
import org.elasticsearch.xpack.core.downsample.DownsampleIndexerAction;
import org.elasticsearch.xpack.core.downsample.DownsampleShardIndexerStatus;
import org.elasticsearch.xpack.core.downsample.DownsampleShardPersistentTaskState;
import org.elasticsearch.xpack.core.downsample.DownsampleShardTask;
import org.elasticsearch.xpack.downsample.AbstractDownsampleFieldProducer;
import org.elasticsearch.xpack.downsample.AggregateMetricFieldSerializer;
import org.elasticsearch.xpack.downsample.DownsampleFieldSerializer;
import org.elasticsearch.xpack.downsample.DownsampleShardIndexerException;
import org.elasticsearch.xpack.downsample.FieldValueFetcher;

class DownsampleShardIndexer {
    private static final Logger logger = LogManager.getLogger(DownsampleShardIndexer.class);
    public static final int DOWNSAMPLE_BULK_ACTIONS = 10000;
    public static final ByteSizeValue DOWNSAMPLE_BULK_SIZE = new ByteSizeValue(1L, ByteSizeUnit.MB);
    public static final ByteSizeValue DOWNSAMPLE_MAX_BYTES_IN_FLIGHT = new ByteSizeValue(50L, ByteSizeUnit.MB);
    private final IndexShard indexShard;
    private final Client client;
    private final String downsampleIndex;
    private final Engine.Searcher searcher;
    private final SearchExecutionContext searchExecutionContext;
    private final DateFieldMapper.DateFieldType timestampField;
    private final DocValueFormat timestampFormat;
    private final Rounding.Prepared rounding;
    private final List<FieldValueFetcher> fieldValueFetchers;
    private final DownsampleShardTask task;
    private final DownsampleShardPersistentTaskState state;
    private volatile boolean abort = false;
    ByteSizeValue downsampleBulkSize = DOWNSAMPLE_BULK_SIZE;
    ByteSizeValue downsampleMaxBytesInFlight = DOWNSAMPLE_MAX_BYTES_IN_FLIGHT;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DownsampleShardIndexer(DownsampleShardTask task, Client client, IndexService indexService, ShardId shardId, String downsampleIndex, DownsampleConfig config, String[] metrics, String[] labels, DownsampleShardPersistentTaskState state) {
        this.task = task;
        this.client = client;
        this.indexShard = indexService.getShard(shardId.id());
        this.downsampleIndex = downsampleIndex;
        this.searcher = this.indexShard.acquireSearcher("downsampling");
        this.state = state;
        Engine.Searcher toClose = this.searcher;
        try {
            this.searchExecutionContext = indexService.newSearchExecutionContext(this.indexShard.shardId().id(), 0, (IndexSearcher)this.searcher, () -> 0L, null, Collections.emptyMap());
            this.timestampField = (DateFieldMapper.DateFieldType)this.searchExecutionContext.getFieldType(config.getTimestampField());
            this.timestampFormat = this.timestampField.docValueFormat(null, null);
            this.rounding = config.createRounding();
            ArrayList<FieldValueFetcher> fetchers = new ArrayList<FieldValueFetcher>(metrics.length + labels.length);
            fetchers.addAll(FieldValueFetcher.create(this.searchExecutionContext, metrics));
            fetchers.addAll(FieldValueFetcher.create(this.searchExecutionContext, labels));
            this.fieldValueFetchers = Collections.unmodifiableList(fetchers);
            toClose = null;
        }
        finally {
            IOUtils.closeWhileHandlingException((Closeable)toClose);
        }
    }

    public DownsampleIndexerAction.ShardDownsampleResponse execute() throws IOException {
        String error;
        Query initialStateQuery = this.createQuery();
        if (initialStateQuery instanceof MatchNoDocsQuery) {
            return new DownsampleIndexerAction.ShardDownsampleResponse(this.indexShard.shardId(), this.task.getNumIndexed());
        }
        long startTime = this.client.threadPool().relativeTimeInMillis();
        this.task.setTotalShardDocCount(this.searcher.getDirectoryReader().numDocs());
        this.task.setDownsampleShardIndexerStatus(DownsampleShardIndexerStatus.STARTED);
        this.task.updatePersistentTaskState((PersistentTaskState)new DownsampleShardPersistentTaskState(DownsampleShardIndexerStatus.STARTED, null), ActionListener.noop());
        logger.info("Downsampling task [" + this.task.getPersistentTaskId() + " on shard " + this.indexShard.shardId() + " started");
        BulkProcessor2 bulkProcessor = this.createBulkProcessor();
        try (Engine.Searcher searcher = this.searcher;
             BulkProcessor2 bulkProcessor2 = bulkProcessor;){
            TimeSeriesIndexSearcher timeSeriesSearcher = new TimeSeriesIndexSearcher((IndexSearcher)this.searcher, List.of(this::checkCancelled));
            TimeSeriesBucketCollector bucketCollector = new TimeSeriesBucketCollector(bulkProcessor);
            bucketCollector.preCollection();
            timeSeriesSearcher.search(initialStateQuery, (BucketCollector)bucketCollector);
        }
        logger.info("Shard [{}] successfully sent [{}], received source doc [{}], indexed downsampled doc [{}], failed [{}], took [{}]", (Object)this.indexShard.shardId(), (Object)this.task.getNumReceived(), (Object)this.task.getNumSent(), (Object)this.task.getNumIndexed(), (Object)this.task.getNumFailed(), (Object)TimeValue.timeValueMillis((long)(this.client.threadPool().relativeTimeInMillis() - startTime)));
        if (this.task.getNumIndexed() != this.task.getNumSent()) {
            this.task.setDownsampleShardIndexerStatus(DownsampleShardIndexerStatus.FAILED);
            error = "Downsampling task [" + this.task.getPersistentTaskId() + "] on shard " + this.indexShard.shardId() + " failed indexing,  indexed [" + this.task.getNumIndexed() + "] sent [" + this.task.getNumSent() + "]";
            logger.info(error);
            throw new DownsampleShardIndexerException(error, false);
        }
        if (this.task.getNumFailed() > 0L) {
            error = "Downsampling task [" + this.task.getPersistentTaskId() + "] on shard " + this.indexShard.shardId() + " failed indexing [" + this.task.getNumFailed() + "]";
            logger.info(error);
            throw new DownsampleShardIndexerException(error, false);
        }
        this.task.setDownsampleShardIndexerStatus(DownsampleShardIndexerStatus.COMPLETED);
        this.task.updatePersistentTaskState((PersistentTaskState)new DownsampleShardPersistentTaskState(DownsampleShardIndexerStatus.COMPLETED, null), ActionListener.noop());
        logger.info("Downsampling task [" + this.task.getPersistentTaskId() + " on shard " + this.indexShard.shardId() + " completed");
        return new DownsampleIndexerAction.ShardDownsampleResponse(this.indexShard.shardId(), this.task.getNumIndexed());
    }

    private Query createQuery() {
        if (this.state.started() && this.state.tsid() != null) {
            return SortedSetDocValuesField.newSlowRangeQuery((String)"_tsid", (BytesRef)this.state.tsid(), null, (boolean)true, (boolean)false);
        }
        return new MatchAllDocsQuery();
    }

    private void checkCancelled() {
        if (this.task.isCancelled()) {
            logger.warn("Shard [{}] downsampled abort, sent [{}], indexed [{}], failed[{}]", (Object)this.indexShard.shardId(), (Object)this.task.getNumSent(), (Object)this.task.getNumIndexed(), (Object)this.task.getNumFailed());
            this.task.setDownsampleShardIndexerStatus(DownsampleShardIndexerStatus.CANCELLED);
            this.task.updatePersistentTaskState((PersistentTaskState)new DownsampleShardPersistentTaskState(DownsampleShardIndexerStatus.CANCELLED, null), ActionListener.noop());
            logger.info("Downsampling task [" + this.task.getPersistentTaskId() + "] on shard " + this.indexShard.shardId() + " cancelled");
            throw new DownsampleShardIndexerException((Throwable)new TaskCancelledException(Strings.format((String)"Shard %s downsample cancelled", (Object[])new Object[]{this.indexShard.shardId()})), Strings.format((String)"Shard %s downsample cancelled", (Object[])new Object[]{this.indexShard.shardId()}), false);
        }
        if (this.abort) {
            logger.warn("Shard [{}] downsample abort, sent [{}], indexed [{}], failed[{}]", (Object)this.indexShard.shardId(), (Object)this.task.getNumSent(), (Object)this.task.getNumIndexed(), (Object)this.task.getNumFailed());
            this.task.setDownsampleShardIndexerStatus(DownsampleShardIndexerStatus.FAILED);
            this.task.updatePersistentTaskState((PersistentTaskState)new DownsampleShardPersistentTaskState(DownsampleShardIndexerStatus.FAILED, null), ActionListener.noop());
            throw new DownsampleShardIndexerException("Bulk indexing failure", true);
        }
    }

    private BulkProcessor2 createBulkProcessor() {
        BulkProcessor2.Listener listener = new BulkProcessor2.Listener(){

            public void beforeBulk(long executionId, BulkRequest request) {
                DownsampleShardIndexer.this.task.addNumSent((long)request.numberOfActions());
                DownsampleShardIndexer.this.task.setBeforeBulkInfo(new DownsampleBeforeBulkInfo(DownsampleShardIndexer.this.client.threadPool().absoluteTimeInMillis(), executionId, request.estimatedSizeInBytes(), request.numberOfActions()));
            }

            public void afterBulk(long executionId, BulkRequest request, BulkResponse response) {
                long bulkIngestTookMillis = response.getIngestTookInMillis() >= 0L ? response.getIngestTookInMillis() : 0L;
                long bulkTookMillis = response.getTook().getMillis();
                DownsampleShardIndexer.this.task.addNumIndexed((long)request.numberOfActions());
                DownsampleShardIndexer.this.task.setAfterBulkInfo(new DownsampleAfterBulkInfo(DownsampleShardIndexer.this.client.threadPool().absoluteTimeInMillis(), executionId, bulkIngestTookMillis, bulkTookMillis, response.hasFailures(), response.status().getStatus()));
                DownsampleShardIndexer.this.task.updateBulkInfo(bulkIngestTookMillis, bulkTookMillis);
                if (response.hasFailures()) {
                    List<BulkItemResponse> failedItems = Arrays.stream(response.getItems()).filter(BulkItemResponse::isFailed).toList();
                    DownsampleShardIndexer.this.task.addNumFailed((long)failedItems.size());
                    Map<String, String> failures = failedItems.stream().collect(Collectors.toMap(BulkItemResponse::getId, BulkItemResponse::getFailureMessage, (msg1, msg2) -> Objects.equals(msg1, msg2) ? msg1 : msg1 + "," + msg2));
                    logger.error("Shard [{}] failed to populate downsample index. Failures: [{}]", (Object)DownsampleShardIndexer.this.indexShard.shardId(), failures);
                    DownsampleShardIndexer.this.abort = true;
                }
            }

            public void afterBulk(long executionId, BulkRequest request, Exception failure) {
                if (failure != null) {
                    long items = request.numberOfActions();
                    DownsampleShardIndexer.this.task.addNumFailed(items);
                    logger.error(() -> Strings.format((String)"Shard [%s] failed to populate downsample index.", (Object[])new Object[]{DownsampleShardIndexer.this.indexShard.shardId()}), (Throwable)failure);
                    DownsampleShardIndexer.this.abort = true;
                }
            }
        };
        return BulkProcessor2.builder((arg_0, arg_1) -> ((Client)this.client).bulk(arg_0, arg_1), (BulkProcessor2.Listener)listener, (ThreadPool)this.client.threadPool()).setBulkActions(10000).setBulkSize(DOWNSAMPLE_BULK_SIZE).setMaxBytesInFlight(this.downsampleMaxBytesInFlight).setMaxNumberOfRetries(3).build();
    }

    private class TimeSeriesBucketCollector
    extends BucketCollector {
        private final BulkProcessor2 bulkProcessor;
        private final DownsampleBucketBuilder downsampleBucketBuilder;
        private long docsProcessed;
        private long bucketsCreated;
        long lastTimestamp = Long.MAX_VALUE;
        long lastHistoTimestamp = Long.MAX_VALUE;

        TimeSeriesBucketCollector(BulkProcessor2 bulkProcessor) {
            this.bulkProcessor = bulkProcessor;
            AbstractDownsampleFieldProducer[] fieldProducers = (AbstractDownsampleFieldProducer[])DownsampleShardIndexer.this.fieldValueFetchers.stream().map(FieldValueFetcher::fieldProducer).toArray(AbstractDownsampleFieldProducer[]::new);
            this.downsampleBucketBuilder = new DownsampleBucketBuilder(fieldProducers);
        }

        public LeafBucketCollector getLeafCollector(final AggregationExecutionContext aggCtx) throws IOException {
            LeafReaderContext ctx = aggCtx.getLeafReaderContext();
            final DocCountProvider docCountProvider = new DocCountProvider();
            docCountProvider.setLeafReaderContext(ctx);
            final AbstractDownsampleFieldProducer[] fieldProducers = new AbstractDownsampleFieldProducer[DownsampleShardIndexer.this.fieldValueFetchers.size()];
            final FormattedDocValues[] formattedDocValues = new FormattedDocValues[DownsampleShardIndexer.this.fieldValueFetchers.size()];
            for (int i = 0; i < fieldProducers.length; ++i) {
                fieldProducers[i] = DownsampleShardIndexer.this.fieldValueFetchers.get(i).fieldProducer();
                formattedDocValues[i] = DownsampleShardIndexer.this.fieldValueFetchers.get(i).getLeaf(ctx);
            }
            return new LeafBucketCollector(){

                public void collect(int docId, long owningBucketOrd) throws IOException {
                    boolean tsidChanged;
                    DownsampleShardIndexer.this.task.addNumReceived(1L);
                    BytesRef tsid = aggCtx.getTsid();
                    assert (tsid != null) : "Document without [_tsid] field was found.";
                    int tsidOrd = aggCtx.getTsidOrd();
                    long timestamp = DownsampleShardIndexer.this.timestampField.resolution().roundDownToMillis(aggCtx.getTimestamp());
                    boolean bl = tsidChanged = tsidOrd != TimeSeriesBucketCollector.this.downsampleBucketBuilder.tsidOrd();
                    if (tsidChanged || timestamp < TimeSeriesBucketCollector.this.lastHistoTimestamp) {
                        TimeSeriesBucketCollector.this.lastHistoTimestamp = Math.max(DownsampleShardIndexer.this.rounding.round(timestamp), DownsampleShardIndexer.this.searchExecutionContext.getIndexSettings().getTimestampBounds().startTime());
                    }
                    DownsampleShardIndexer.this.task.setLastSourceTimestamp(timestamp);
                    DownsampleShardIndexer.this.task.setLastTargetTimestamp(TimeSeriesBucketCollector.this.lastHistoTimestamp);
                    if (logger.isTraceEnabled()) {
                        logger.trace("Doc: [{}] - _tsid: [{}], @timestamp: [{}}] -> downsample bucket ts: [{}]", (Object)docId, DocValueFormat.TIME_SERIES_ID.format(tsid), DownsampleShardIndexer.this.timestampFormat.format(timestamp), DownsampleShardIndexer.this.timestampFormat.format(TimeSeriesBucketCollector.this.lastHistoTimestamp));
                    }
                    BytesRef lastTsid = TimeSeriesBucketCollector.this.downsampleBucketBuilder.tsid();
                    assert (lastTsid == null || lastTsid.compareTo(tsid) <= 0) : "_tsid is not sorted in ascending order: [" + DocValueFormat.TIME_SERIES_ID.format(lastTsid) + "] -> [" + DocValueFormat.TIME_SERIES_ID.format(tsid) + "]";
                    assert (!tsid.equals((Object)lastTsid) || TimeSeriesBucketCollector.this.lastTimestamp >= timestamp) : "@timestamp is not sorted in descending order: [" + DownsampleShardIndexer.this.timestampFormat.format(TimeSeriesBucketCollector.this.lastTimestamp) + "] -> [" + DownsampleShardIndexer.this.timestampFormat.format(timestamp) + "]";
                    TimeSeriesBucketCollector.this.lastTimestamp = timestamp;
                    if (tsidChanged || TimeSeriesBucketCollector.this.downsampleBucketBuilder.timestamp() != TimeSeriesBucketCollector.this.lastHistoTimestamp) {
                        if (!TimeSeriesBucketCollector.this.downsampleBucketBuilder.isEmpty()) {
                            XContentBuilder doc = TimeSeriesBucketCollector.this.downsampleBucketBuilder.buildDownsampleDocument();
                            TimeSeriesBucketCollector.this.indexBucket(doc);
                        }
                        if (tsidChanged) {
                            TimeSeriesBucketCollector.this.downsampleBucketBuilder.resetTsid(tsid, tsidOrd, TimeSeriesBucketCollector.this.lastHistoTimestamp);
                        } else {
                            TimeSeriesBucketCollector.this.downsampleBucketBuilder.resetTimestamp(TimeSeriesBucketCollector.this.lastHistoTimestamp);
                        }
                        ++TimeSeriesBucketCollector.this.bucketsCreated;
                    }
                    int docCount = docCountProvider.getDocCount(docId);
                    TimeSeriesBucketCollector.this.downsampleBucketBuilder.collectDocCount(docCount);
                    for (int i = 0; i < fieldProducers.length; ++i) {
                        AbstractDownsampleFieldProducer fieldProducer = fieldProducers[i];
                        FormattedDocValues docValues = formattedDocValues[i];
                        fieldProducer.collect(docValues, docId);
                    }
                    ++TimeSeriesBucketCollector.this.docsProcessed;
                    DownsampleShardIndexer.this.task.setDocsProcessed(TimeSeriesBucketCollector.this.docsProcessed);
                }
            };
        }

        private void indexBucket(XContentBuilder doc) {
            IndexRequestBuilder request = DownsampleShardIndexer.this.client.prepareIndex(DownsampleShardIndexer.this.downsampleIndex);
            request.setSource(doc);
            if (logger.isTraceEnabled()) {
                logger.trace("Indexing downsample doc: [{}]", (Object)org.elasticsearch.common.Strings.toString((XContentBuilder)doc));
            }
            IndexRequest indexRequest = (IndexRequest)request.request();
            DownsampleShardIndexer.this.task.setLastIndexingTimestamp(System.currentTimeMillis());
            this.bulkProcessor.addWithBackpressure(indexRequest, () -> DownsampleShardIndexer.this.abort);
        }

        public void preCollection() {
            DownsampleShardIndexer.this.checkCancelled();
        }

        public void postCollection() throws IOException {
            if (!this.downsampleBucketBuilder.isEmpty()) {
                XContentBuilder doc = this.downsampleBucketBuilder.buildDownsampleDocument();
                this.indexBucket(doc);
            }
            DownsampleShardIndexer.this.checkCancelled();
            logger.info("Shard {} processed [{}] docs, created [{}] downsample buckets", (Object)DownsampleShardIndexer.this.indexShard.shardId(), (Object)this.docsProcessed, (Object)this.bucketsCreated);
        }

        public ScoreMode scoreMode() {
            return ScoreMode.COMPLETE_NO_SCORES;
        }
    }

    private class DownsampleBucketBuilder {
        private BytesRef tsid;
        private int tsidOrd = -1;
        private long timestamp;
        private int docCount;
        private final AbstractDownsampleFieldProducer[] fieldProducers;
        private final DownsampleFieldSerializer[] groupedProducers;

        DownsampleBucketBuilder(AbstractDownsampleFieldProducer[] fieldProducers) {
            this.fieldProducers = fieldProducers;
            this.groupedProducers = (DownsampleFieldSerializer[])Arrays.stream(fieldProducers).collect(Collectors.groupingBy(AbstractDownsampleFieldProducer::name)).entrySet().stream().map(e -> {
                if (((List)e.getValue()).size() == 1) {
                    return (DownsampleFieldSerializer)((List)e.getValue()).get(0);
                }
                return new AggregateMetricFieldSerializer((String)e.getKey(), (Collection)e.getValue());
            }).toArray(DownsampleFieldSerializer[]::new);
        }

        public void resetTsid(BytesRef tsid, int tsidOrd, long timestamp) {
            this.tsid = BytesRef.deepCopyOf((BytesRef)tsid);
            this.tsidOrd = tsidOrd;
            this.resetTimestamp(timestamp);
        }

        public void resetTimestamp(long timestamp) {
            this.timestamp = timestamp;
            this.docCount = 0;
            for (AbstractDownsampleFieldProducer producer : this.fieldProducers) {
                producer.reset();
            }
            if (logger.isTraceEnabled()) {
                logger.trace("New bucket for _tsid: [{}], @timestamp: [{}]", DocValueFormat.TIME_SERIES_ID.format(this.tsid), DownsampleShardIndexer.this.timestampFormat.format(timestamp));
            }
        }

        public void collectDocCount(int docCount) {
            this.docCount += docCount;
        }

        public XContentBuilder buildDownsampleDocument() throws IOException {
            XContentBuilder builder = XContentFactory.contentBuilder((XContentType)XContentType.SMILE);
            builder.startObject();
            if (this.isEmpty()) {
                builder.endObject();
                return builder;
            }
            builder.field(DownsampleShardIndexer.this.timestampField.name(), DownsampleShardIndexer.this.timestampFormat.format(this.timestamp));
            builder.field("_doc_count", this.docCount);
            Map dimensions = (Map)DocValueFormat.TIME_SERIES_ID.format(this.tsid);
            for (Map.Entry e : dimensions.entrySet()) {
                assert (e.getValue() != null);
                builder.field((String)e.getKey(), e.getValue());
            }
            for (DownsampleFieldSerializer fieldProducer : this.groupedProducers) {
                fieldProducer.write(builder);
            }
            builder.endObject();
            return builder;
        }

        public long timestamp() {
            return this.timestamp;
        }

        public BytesRef tsid() {
            return this.tsid;
        }

        public int tsidOrd() {
            return this.tsidOrd;
        }

        public int docCount() {
            return this.docCount;
        }

        public boolean isEmpty() {
            return this.tsid() == null || this.timestamp() == 0L || this.docCount() == 0;
        }
    }
}

