/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.downsample;

import java.util.Map;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.NumberFieldMapper;
import org.elasticsearch.xpack.aggregatemetric.mapper.AggregateDoubleMetricFieldMapper;
import org.elasticsearch.xpack.downsample.AbstractDownsampleFieldProducer;
import org.elasticsearch.xpack.downsample.FieldValueFetcher;
import org.elasticsearch.xpack.downsample.LabelFieldProducer;
import org.elasticsearch.xpack.downsample.MetricFieldProducer;

public class AggregateMetricFieldValueFetcher
extends FieldValueFetcher {
    private final AggregateDoubleMetricFieldMapper.AggregateDoubleMetricFieldType aggMetricFieldType;
    private final AbstractDownsampleFieldProducer fieldProducer;

    protected AggregateMetricFieldValueFetcher(MappedFieldType fieldType, AggregateDoubleMetricFieldMapper.AggregateDoubleMetricFieldType aggMetricFieldType, IndexFieldData<?> fieldData) {
        super(fieldType.name(), fieldType, fieldData);
        this.aggMetricFieldType = aggMetricFieldType;
        this.fieldProducer = this.createFieldProducer();
    }

    @Override
    public AbstractDownsampleFieldProducer fieldProducer() {
        return this.fieldProducer;
    }

    private AbstractDownsampleFieldProducer createFieldProducer() {
        AggregateDoubleMetricFieldMapper.Metric metric = null;
        for (Map.Entry e : this.aggMetricFieldType.getMetricFields().entrySet()) {
            NumberFieldMapper.NumberFieldType metricSubField = (NumberFieldMapper.NumberFieldType)e.getValue();
            if (!metricSubField.name().equals(this.name())) continue;
            metric = (AggregateDoubleMetricFieldMapper.Metric)e.getKey();
            break;
        }
        assert (metric != null) : "Cannot resolve metric type for field " + this.name();
        if (this.aggMetricFieldType.getMetricType() != null) {
            MetricFieldProducer.Metric metricOperation = switch (metric) {
                default -> throw new IncompatibleClassChangeError();
                case AggregateDoubleMetricFieldMapper.Metric.max -> new MetricFieldProducer.Max();
                case AggregateDoubleMetricFieldMapper.Metric.min -> new MetricFieldProducer.Min();
                case AggregateDoubleMetricFieldMapper.Metric.sum -> new MetricFieldProducer.Sum();
                case AggregateDoubleMetricFieldMapper.Metric.value_count -> new MetricFieldProducer.Sum(AggregateDoubleMetricFieldMapper.Metric.value_count.name());
            };
            return new MetricFieldProducer.GaugeMetricFieldProducer(this.aggMetricFieldType.name(), metricOperation);
        }
        return new LabelFieldProducer.AggregateMetricFieldProducer(this.aggMetricFieldType.name(), metric);
    }
}

