/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.deprecation.logging;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.metadata.ComponentTemplate;
import org.elasticsearch.cluster.metadata.ComposableIndexTemplate;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.json.JsonXContent;
import org.elasticsearch.xpack.core.template.IndexTemplateConfig;
import org.elasticsearch.xpack.core.template.IndexTemplateRegistry;
import org.elasticsearch.xpack.core.template.LifecyclePolicyConfig;

public class DeprecationIndexingTemplateRegistry
extends IndexTemplateRegistry {
    public static final int INDEX_TEMPLATE_VERSION = 1;
    public static final String DEPRECATION_INDEXING_TEMPLATE_VERSION_VARIABLE = "xpack.deprecation.indexing.template.version";
    public static final String DEPRECATION_INDEXING_MAPPINGS_NAME = ".deprecation-indexing-mappings";
    public static final String DEPRECATION_INDEXING_SETTINGS_NAME = ".deprecation-indexing-settings";
    public static final String DEPRECATION_INDEXING_TEMPLATE_NAME = ".deprecation-indexing-template";
    public static final String DEPRECATION_INDEXING_POLICY_NAME = ".deprecation-indexing-ilm-policy";
    private static final Map<String, ComponentTemplate> COMPONENT_TEMPLATE_CONFIGS;
    private static final Map<String, ComposableIndexTemplate> COMPOSABLE_INDEX_TEMPLATE_CONFIGS;
    private static final LifecyclePolicyConfig LIFECYCLE_POLICY_CONFIG;

    public DeprecationIndexingTemplateRegistry(Settings nodeSettings, ClusterService clusterService, ThreadPool threadPool, Client client, NamedXContentRegistry xContentRegistry) {
        super(nodeSettings, clusterService, threadPool, client, xContentRegistry);
    }

    protected Map<String, ComponentTemplate> getComponentTemplateConfigs() {
        return COMPONENT_TEMPLATE_CONFIGS;
    }

    protected Map<String, ComposableIndexTemplate> getComposableTemplateConfigs() {
        return COMPOSABLE_INDEX_TEMPLATE_CONFIGS;
    }

    protected List<LifecyclePolicyConfig> getLifecycleConfigs() {
        return List.of(LIFECYCLE_POLICY_CONFIG);
    }

    protected String getOrigin() {
        return "deprecation";
    }

    protected boolean requiresMasterNode() {
        return true;
    }

    static {
        HashMap<String, ComponentTemplate> componentTemplates = new HashMap<String, ComponentTemplate>();
        for (IndexTemplateConfig config : List.of(new IndexTemplateConfig(DEPRECATION_INDEXING_MAPPINGS_NAME, "/deprecation/deprecation-indexing-mappings.json", 1, DEPRECATION_INDEXING_TEMPLATE_VERSION_VARIABLE), new IndexTemplateConfig(DEPRECATION_INDEXING_SETTINGS_NAME, "/deprecation/deprecation-indexing-settings.json", 1, DEPRECATION_INDEXING_TEMPLATE_VERSION_VARIABLE))) {
            try {
                componentTemplates.put(config.getTemplateName(), ComponentTemplate.parse((XContentParser)JsonXContent.jsonXContent.createParser(XContentParserConfiguration.EMPTY, config.loadBytes())));
            }
            catch (IOException e) {
                throw new AssertionError((Object)e);
            }
        }
        COMPONENT_TEMPLATE_CONFIGS = Map.copyOf(componentTemplates);
        COMPOSABLE_INDEX_TEMPLATE_CONFIGS = DeprecationIndexingTemplateRegistry.parseComposableTemplates((IndexTemplateConfig[])new IndexTemplateConfig[]{new IndexTemplateConfig(DEPRECATION_INDEXING_TEMPLATE_NAME, "/deprecation/deprecation-indexing-template.json", 1, DEPRECATION_INDEXING_TEMPLATE_VERSION_VARIABLE)});
        LIFECYCLE_POLICY_CONFIG = new LifecyclePolicyConfig(DEPRECATION_INDEXING_POLICY_NAME, "/deprecation/deprecation-indexing-ilm-policy.json");
    }
}

