/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.deprecation;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.admin.cluster.node.info.PluginsAndModules;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.nodes.TransportNodesAction;
import org.elasticsearch.cluster.ClusterInfo;
import org.elasticsearch.cluster.ClusterInfoService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.DiskUsage;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.allocation.DiskThresholdSettings;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.plugins.PluginsService;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.deprecation.DeprecationIssue;
import org.elasticsearch.xpack.deprecation.DeprecationChecks;
import org.elasticsearch.xpack.deprecation.DeprecationInfoAction;
import org.elasticsearch.xpack.deprecation.NodesDeprecationCheckAction;
import org.elasticsearch.xpack.deprecation.NodesDeprecationCheckRequest;
import org.elasticsearch.xpack.deprecation.NodesDeprecationCheckResponse;

public class TransportNodeDeprecationCheckAction
extends TransportNodesAction<NodesDeprecationCheckRequest, NodesDeprecationCheckResponse, NodesDeprecationCheckAction.NodeRequest, NodesDeprecationCheckAction.NodeResponse> {
    private final Settings settings;
    private final XPackLicenseState licenseState;
    private final PluginsService pluginsService;
    private final ClusterInfoService clusterInfoService;
    private volatile List<String> skipTheseDeprecations;

    @Inject
    public TransportNodeDeprecationCheckAction(Settings settings, ThreadPool threadPool, XPackLicenseState licenseState, ClusterService clusterService, TransportService transportService, PluginsService pluginsService, ActionFilters actionFilters, ClusterInfoService clusterInfoService) {
        super("cluster:admin/xpack/deprecation/nodes/info", threadPool, clusterService, transportService, actionFilters, NodesDeprecationCheckRequest::new, NodesDeprecationCheckAction.NodeRequest::new, "generic");
        this.settings = settings;
        this.pluginsService = pluginsService;
        this.licenseState = licenseState;
        this.clusterInfoService = clusterInfoService;
        this.skipTheseDeprecations = (List)DeprecationChecks.SKIP_DEPRECATIONS_SETTING.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(DeprecationChecks.SKIP_DEPRECATIONS_SETTING, this::setSkipDeprecations);
    }

    private <T> void setSkipDeprecations(List<String> skipDeprecations) {
        this.skipTheseDeprecations = Collections.unmodifiableList(skipDeprecations);
    }

    protected NodesDeprecationCheckResponse newResponse(NodesDeprecationCheckRequest request, List<NodesDeprecationCheckAction.NodeResponse> nodeResponses, List<FailedNodeException> failures) {
        return new NodesDeprecationCheckResponse(this.clusterService.getClusterName(), nodeResponses, failures);
    }

    protected NodesDeprecationCheckAction.NodeRequest newNodeRequest(NodesDeprecationCheckRequest request) {
        return new NodesDeprecationCheckAction.NodeRequest(request);
    }

    protected NodesDeprecationCheckAction.NodeResponse newNodeResponse(StreamInput in, DiscoveryNode node) throws IOException {
        return new NodesDeprecationCheckAction.NodeResponse(in);
    }

    protected NodesDeprecationCheckAction.NodeResponse nodeOperation(NodesDeprecationCheckAction.NodeRequest request, Task task) {
        return this.nodeOperation(request, DeprecationChecks.NODE_SETTINGS_CHECKS);
    }

    NodesDeprecationCheckAction.NodeResponse nodeOperation(NodesDeprecationCheckAction.NodeRequest request, List<DeprecationChecks.NodeDeprecationCheck<Settings, PluginsAndModules, ClusterState, XPackLicenseState, DeprecationIssue>> nodeSettingsChecks) {
        Settings filteredNodeSettings = this.settings.filter(setting -> !Regex.simpleMatch(this.skipTheseDeprecations, (String)setting));
        Metadata metadata = this.clusterService.state().metadata();
        Settings transientSettings = metadata.transientSettings().filter(setting -> !Regex.simpleMatch(this.skipTheseDeprecations, (String)setting));
        Settings persistentSettings = metadata.persistentSettings().filter(setting -> !Regex.simpleMatch(this.skipTheseDeprecations, (String)setting));
        ClusterState filteredClusterState = ClusterState.builder((ClusterState)this.clusterService.state()).metadata(Metadata.builder((Metadata)metadata).transientSettings(transientSettings).persistentSettings(persistentSettings).build()).build();
        List<DeprecationIssue> issues = DeprecationInfoAction.filterChecks(nodeSettingsChecks, c -> (DeprecationIssue)c.apply(filteredNodeSettings, this.pluginsService.info(), filteredClusterState, this.licenseState));
        DeprecationIssue watermarkIssue = TransportNodeDeprecationCheckAction.checkDiskLowWatermark(filteredNodeSettings, filteredClusterState.metadata().settings(), this.clusterInfoService.getClusterInfo(), this.clusterService.getClusterSettings(), this.transportService.getLocalNode().getId());
        if (watermarkIssue != null) {
            issues.add(watermarkIssue);
        }
        return new NodesDeprecationCheckAction.NodeResponse(this.transportService.getLocalNode(), issues);
    }

    static DeprecationIssue checkDiskLowWatermark(Settings nodeSettings, Settings dynamicSettings, ClusterInfo clusterInfo, ClusterSettings clusterSettings, String nodeId) {
        long totalBytes;
        long freeBytes;
        DiskUsage usage = (DiskUsage)clusterInfo.getNodeMostAvailableDiskUsages().get(nodeId);
        if (usage != null && (TransportNodeDeprecationCheckAction.exceedsLowWatermark(nodeSettings, clusterSettings, freeBytes = usage.getFreeBytes(), totalBytes = usage.getTotalBytes()) || TransportNodeDeprecationCheckAction.exceedsLowWatermark(dynamicSettings, clusterSettings, freeBytes, totalBytes))) {
            return new DeprecationIssue(DeprecationIssue.Level.CRITICAL, "Disk usage exceeds low watermark", "https://ela.st/es-deprecation-7-disk-watermark-exceeded", String.format(Locale.ROOT, "Disk usage exceeds low watermark, which will prevent reindexing indices during upgrade. Get disk usage on all nodes below the value specified in %s", DiskThresholdSettings.CLUSTER_ROUTING_ALLOCATION_LOW_DISK_WATERMARK_SETTING.getKey()), false, null);
        }
        return null;
    }

    private static boolean exceedsLowWatermark(Settings settingsToCheck, ClusterSettings clusterSettings, long freeBytes, long totalBytes) {
        DiskThresholdSettings diskThresholdSettings = new DiskThresholdSettings(settingsToCheck, clusterSettings);
        return freeBytes < diskThresholdSettings.getFreeBytesThresholdLowStage(ByteSizeValue.ofBytes((long)totalBytes)).getBytes();
    }
}

