/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.transform.transforms;

import java.io.IOException;
import java.time.Instant;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.cluster.SimpleDiffable;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.persistent.PersistentTaskParams;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.transform.TransformConfigVersion;
import org.elasticsearch.xpack.core.transform.TransformField;

public class TransformTaskParams
implements SimpleDiffable<TransformTaskParams>,
PersistentTaskParams {
    public static final String NAME = "data_frame/transforms";
    public static final ParseField FROM = TransformField.FROM;
    public static final ParseField FREQUENCY = TransformField.FREQUENCY;
    public static final ParseField REQUIRES_REMOTE = new ParseField("requires_remote", new String[0]);
    private final String transformId;
    private final TransformConfigVersion version;
    private final Instant from;
    private final TimeValue frequency;
    private final Boolean requiresRemote;
    public static final ConstructingObjectParser<TransformTaskParams, Void> PARSER = new ConstructingObjectParser("data_frame/transforms", true, a -> new TransformTaskParams((String)a[0], (String)a[1], (Long)a[2], (String)a[3], (Boolean)a[4]));

    private TransformTaskParams(String transformId, String version, Long from, String frequency, Boolean remote) {
        this(transformId, version == null ? null : TransformConfigVersion.fromString(version), from == null ? null : Instant.ofEpochMilli(from), frequency == null ? null : TimeValue.parseTimeValue((String)frequency, (String)FREQUENCY.getPreferredName()), remote == null ? false : remote);
    }

    public TransformTaskParams(String transformId, TransformConfigVersion version, TimeValue frequency, boolean remote) {
        this(transformId, version, null, frequency, remote);
    }

    public TransformTaskParams(String transformId, TransformConfigVersion version, Instant from, TimeValue frequency, boolean remote) {
        this.transformId = transformId;
        this.version = version == null ? TransformConfigVersion.V_7_2_0 : version;
        this.from = from;
        this.frequency = frequency;
        this.requiresRemote = remote;
    }

    public TransformTaskParams(StreamInput in) throws IOException {
        this.transformId = in.readString();
        this.version = TransformConfigVersion.readVersion(in);
        this.from = in.getTransportVersion().onOrAfter((VersionId)TransportVersion.V_8_7_0) ? in.readOptionalInstant() : null;
        this.frequency = in.readOptionalTimeValue();
        this.requiresRemote = in.readBoolean();
    }

    public String getWriteableName() {
        return NAME;
    }

    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersion.V_7_17_0;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.transformId);
        TransformConfigVersion.writeVersion(this.version, out);
        if (out.getTransportVersion().onOrAfter((VersionId)TransportVersion.V_8_7_0)) {
            out.writeOptionalInstant(this.from);
        }
        out.writeOptionalTimeValue(this.frequency);
        out.writeBoolean(this.requiresRemote.booleanValue());
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(TransformField.ID.getPreferredName(), this.transformId);
        builder.field(TransformField.VERSION.getPreferredName(), (ToXContent)this.version);
        if (this.from != null) {
            builder.field(FROM.getPreferredName(), this.from.toEpochMilli());
        }
        if (this.frequency != null) {
            builder.field(FREQUENCY.getPreferredName(), this.frequency.getStringRep());
        }
        builder.field(REQUIRES_REMOTE.getPreferredName(), this.requiresRemote);
        builder.endObject();
        return builder;
    }

    public String getId() {
        return this.transformId;
    }

    public TransformConfigVersion getVersion() {
        return this.version;
    }

    public Instant from() {
        return this.from;
    }

    public TimeValue getFrequency() {
        return this.frequency;
    }

    public boolean requiresRemote() {
        return this.requiresRemote;
    }

    public static TransformTaskParams fromXContent(XContentParser parser) throws IOException {
        return (TransformTaskParams)PARSER.parse(parser, null);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        TransformTaskParams that = (TransformTaskParams)other;
        return Objects.equals(this.transformId, that.transformId) && Objects.equals(this.version, that.version) && Objects.equals(this.from, that.from) && Objects.equals(this.frequency, that.frequency) && this.requiresRemote == that.requiresRemote;
    }

    public int hashCode() {
        return Objects.hash(this.transformId, this.version, this.from, this.frequency, this.requiresRemote);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), TransformField.ID);
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), TransformField.VERSION);
        PARSER.declareLong(ConstructingObjectParser.optionalConstructorArg(), FROM);
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), FREQUENCY);
        PARSER.declareBoolean(ConstructingObjectParser.optionalConstructorArg(), REQUIRES_REMOTE);
    }
}

