/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.transform.transforms;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.health.HealthStatus;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.transform.transforms.TransformHealthIssue;

public class TransformHealth
implements Writeable,
ToXContentObject {
    public static final TransformHealth GREEN = new TransformHealth(HealthStatus.GREEN, null);
    public static final TransformHealth UNKNOWN = new TransformHealth(HealthStatus.UNKNOWN, null);
    private static final String STATUS = "status";
    private static final String ISSUES = "issues";
    private final HealthStatus status;
    private final List<TransformHealthIssue> issues;

    public TransformHealth(HealthStatus status, List<TransformHealthIssue> issues) {
        this.status = status;
        this.issues = issues;
    }

    public TransformHealth(StreamInput in) throws IOException {
        this.status = (HealthStatus)in.readEnum(HealthStatus.class);
        this.issues = in.readOptionalList(TransformHealthIssue::new);
    }

    public HealthStatus getStatus() {
        return this.status;
    }

    public List<TransformHealthIssue> getIssues() {
        return this.issues;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(STATUS, this.status.xContentValue());
        if (this.issues != null && !this.issues.isEmpty()) {
            builder.field(ISSUES, this.issues);
        }
        return builder.endObject();
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.status.writeTo(out);
        out.writeOptionalCollection(this.issues);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        TransformHealth that = (TransformHealth)other;
        return this.status.value() == that.status.value() && Objects.equals(this.issues, that.issues);
    }

    public int hashCode() {
        return Objects.hash(this.status, this.issues);
    }

    public String toString() {
        return Strings.toString((ToXContent)this, (boolean)true, (boolean)true);
    }
}

