/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.transform.action;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.OriginalIndices;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.shard.ShardId;

public class GetCheckpointNodeAction
extends ActionType<Response> {
    public static final GetCheckpointNodeAction INSTANCE = new GetCheckpointNodeAction();
    public static final String NAME = "indices:monitor/transform/checkpoint[n]";

    private GetCheckpointNodeAction() {
        super(NAME, Response::new);
    }

    public static class Request
    extends ActionRequest
    implements IndicesRequest {
        private final Set<ShardId> shards;
        private final OriginalIndices originalIndices;

        public Request(Set<ShardId> shards, OriginalIndices originalIndices) {
            this.shards = shards;
            this.originalIndices = originalIndices;
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.shards = in.readImmutableSet(ShardId::new);
            this.originalIndices = OriginalIndices.readOriginalIndices((StreamInput)in);
        }

        public ActionRequestValidationException validate() {
            return null;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeCollection(this.shards);
            OriginalIndices.writeOriginalIndices((OriginalIndices)this.originalIndices, (StreamOutput)out);
        }

        public Set<ShardId> getShards() {
            return this.shards;
        }

        public OriginalIndices getOriginalIndices() {
            return this.originalIndices;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != ((Object)((Object)this)).getClass()) {
                return false;
            }
            Request that = (Request)((Object)obj);
            return Objects.equals(this.shards, that.shards) && Objects.equals(this.originalIndices, that.originalIndices);
        }

        public int hashCode() {
            return Objects.hash(this.shards, this.originalIndices);
        }

        public String[] indices() {
            return this.originalIndices.indices();
        }

        public IndicesOptions indicesOptions() {
            return this.originalIndices.indicesOptions();
        }
    }

    public static class Response
    extends ActionResponse {
        private final Map<String, long[]> checkpoints;

        public Response(Map<String, long[]> checkpoints) {
            this.checkpoints = checkpoints;
        }

        public Response(StreamInput in) throws IOException {
            this.checkpoints = in.readOrderedMap(StreamInput::readString, StreamInput::readLongArray);
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeMap(this.getCheckpoints(), StreamOutput::writeString, StreamOutput::writeLongArray);
        }

        public Map<String, long[]> getCheckpoints() {
            return this.checkpoints;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != ((Object)((Object)this)).getClass()) {
                return false;
            }
            Response that = (Response)((Object)obj);
            return this.checkpoints.size() == that.checkpoints.size() && this.checkpoints.entrySet().stream().allMatch(e -> Arrays.equals((long[])e.getValue(), that.checkpoints.get(e.getKey())));
        }

        public int hashCode() {
            int hash = 1;
            for (Map.Entry<String, long[]> e : this.checkpoints.entrySet()) {
                hash = 31 * hash + Objects.hash(e.getKey(), Arrays.hashCode(e.getValue()));
            }
            return hash;
        }
    }
}

