/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.template;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.xpack.core.template.TemplateUtils;

public class IngestPipelineConfig {
    private final String id;
    private final String resource;
    private final int version;
    private final String versionProperty;
    private final List<String> dependencies;

    public IngestPipelineConfig(String id, String resource, int version, String versionProperty) {
        this(id, resource, version, versionProperty, Collections.emptyList());
    }

    public IngestPipelineConfig(String id, String resource, int version, String versionProperty, List<String> dependencies) {
        this.id = Objects.requireNonNull(id);
        this.resource = Objects.requireNonNull(resource);
        this.version = version;
        this.versionProperty = Objects.requireNonNull(versionProperty);
        this.dependencies = dependencies;
    }

    public String getId() {
        return this.id;
    }

    public int getVersion() {
        return this.version;
    }

    public String getVersionProperty() {
        return this.versionProperty;
    }

    public List<String> getPipelineDependencies() {
        return this.dependencies;
    }

    public BytesReference loadConfig() {
        return new BytesArray(TemplateUtils.loadTemplate(this.resource, String.valueOf(this.version), this.versionProperty));
    }
}

