/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.action.profile;

import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;

public class UpdateProfileDataRequest
extends ActionRequest {
    private final String uid;
    private final Map<String, Object> labels;
    private final Map<String, Object> data;
    private final long ifPrimaryTerm;
    private final long ifSeqNo;
    private final WriteRequest.RefreshPolicy refreshPolicy;

    public UpdateProfileDataRequest(String uid, Map<String, Object> labels, Map<String, Object> data, long ifPrimaryTerm, long ifSeqNo, WriteRequest.RefreshPolicy refreshPolicy) {
        this.uid = Objects.requireNonNull(uid, "profile uid must not be null");
        this.labels = labels != null ? labels : Map.of();
        this.data = data != null ? data : Map.of();
        this.ifPrimaryTerm = ifPrimaryTerm;
        this.ifSeqNo = ifSeqNo;
        this.refreshPolicy = refreshPolicy;
    }

    public UpdateProfileDataRequest(StreamInput in) throws IOException {
        super(in);
        this.uid = in.readString();
        this.labels = in.readMap();
        this.data = in.readMap();
        this.ifPrimaryTerm = in.readLong();
        this.ifSeqNo = in.readLong();
        this.refreshPolicy = WriteRequest.RefreshPolicy.readFrom((StreamInput)in);
    }

    public String getUid() {
        return this.uid;
    }

    public Map<String, Object> getLabels() {
        return this.labels;
    }

    public Map<String, Object> getData() {
        return this.data;
    }

    public long getIfPrimaryTerm() {
        return this.ifPrimaryTerm;
    }

    public long getIfSeqNo() {
        return this.ifSeqNo;
    }

    public WriteRequest.RefreshPolicy getRefreshPolicy() {
        return this.refreshPolicy;
    }

    public Set<String> getApplicationNames() {
        HashSet<String> names = new HashSet<String>(this.labels.keySet());
        names.addAll(this.data.keySet());
        return Set.copyOf(names);
    }

    public ActionRequestValidationException validate() {
        Set namesStartsWithUnderscore;
        Set namesWithDot;
        ActionRequestValidationException validationException = null;
        Set<String> applicationNames = this.getApplicationNames();
        if (applicationNames.isEmpty()) {
            validationException = ValidateActions.addValidationError((String)"update request is empty", validationException);
        }
        if (!(namesWithDot = applicationNames.stream().filter(name -> name.contains(".")).collect(Collectors.toUnmodifiableSet())).isEmpty()) {
            validationException = ValidateActions.addValidationError((String)("application name must not contain dot, but found [" + Strings.collectionToCommaDelimitedString(namesWithDot) + "]"), (ActionRequestValidationException)validationException);
        }
        if (!(namesStartsWithUnderscore = applicationNames.stream().filter(name -> name.startsWith("_")).collect(Collectors.toUnmodifiableSet())).isEmpty()) {
            validationException = ValidateActions.addValidationError((String)("application name must not start with underscore, but found [" + Strings.collectionToCommaDelimitedString(namesStartsWithUnderscore) + "]"), (ActionRequestValidationException)validationException);
        }
        return validationException;
    }
}

