/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.action.apikey;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xpack.core.security.action.apikey.AbstractCreateApiKeyRequest;
import org.elasticsearch.xpack.core.security.action.apikey.ApiKey;
import org.elasticsearch.xpack.core.security.action.role.RoleDescriptorRequestValidator;
import org.elasticsearch.xpack.core.security.authz.RoleDescriptor;

public final class CreateApiKeyRequest
extends AbstractCreateApiKeyRequest {
    public CreateApiKeyRequest() {
    }

    public CreateApiKeyRequest(String name, @Nullable List<RoleDescriptor> roleDescriptors, @Nullable TimeValue expiration) {
        this(name, roleDescriptors, expiration, null);
    }

    public CreateApiKeyRequest(String name, @Nullable List<RoleDescriptor> roleDescriptors, @Nullable TimeValue expiration, @Nullable Map<String, Object> metadata) {
        this();
        this.name = name;
        this.roleDescriptors = roleDescriptors == null ? List.of() : List.copyOf(roleDescriptors);
        this.expiration = expiration;
        this.metadata = metadata;
    }

    public CreateApiKeyRequest(StreamInput in) throws IOException {
        super(in);
        this.name = in.getTransportVersion().onOrAfter((VersionId)TransportVersion.V_7_5_0) ? in.readOptionalString() : in.readString();
        this.expiration = in.readOptionalTimeValue();
        this.roleDescriptors = in.readImmutableList(RoleDescriptor::new);
        this.refreshPolicy = WriteRequest.RefreshPolicy.readFrom((StreamInput)in);
        this.metadata = in.getTransportVersion().onOrAfter((VersionId)TransportVersion.V_8_0_0) ? in.readMap() : null;
    }

    @Override
    protected String doReadId(StreamInput in) throws IOException {
        if (in.getTransportVersion().onOrAfter((VersionId)TransportVersion.V_7_10_0)) {
            return in.readString();
        }
        return UUIDs.base64UUID();
    }

    @Override
    public ApiKey.Type getType() {
        return ApiKey.Type.REST;
    }

    public void setId() {
        throw new UnsupportedOperationException("The API Key Id cannot be set, it must be generated randomly");
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setExpiration(@Nullable TimeValue expiration) {
        this.expiration = expiration;
    }

    public void setRoleDescriptors(@Nullable List<RoleDescriptor> roleDescriptors) {
        this.roleDescriptors = roleDescriptors == null ? List.of() : List.copyOf(roleDescriptors);
    }

    public void setMetadata(Map<String, Object> metadata) {
        this.metadata = metadata;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = super.validate();
        for (RoleDescriptor roleDescriptor : this.getRoleDescriptors()) {
            validationException = RoleDescriptorRequestValidator.validate(roleDescriptor, validationException);
        }
        return validationException;
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        if (out.getTransportVersion().onOrAfter((VersionId)TransportVersion.V_7_10_0)) {
            out.writeString(this.id);
        }
        if (out.getTransportVersion().onOrAfter((VersionId)TransportVersion.V_7_5_0)) {
            out.writeOptionalString(this.name);
        } else {
            out.writeString(this.name);
        }
        out.writeOptionalTimeValue(this.expiration);
        out.writeList(this.getRoleDescriptors());
        this.refreshPolicy.writeTo(out);
        if (out.getTransportVersion().onOrAfter((VersionId)TransportVersion.V_7_13_0)) {
            out.writeGenericMap(this.metadata);
        }
    }
}

