/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.monitoring.action;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class MonitoringMigrateAlertsResponse
extends ActionResponse
implements ToXContentObject {
    private final List<ExporterMigrationResult> exporters;

    public MonitoringMigrateAlertsResponse(List<ExporterMigrationResult> exporters) {
        this.exporters = exporters;
    }

    public MonitoringMigrateAlertsResponse(StreamInput in) throws IOException {
        super(in);
        this.exporters = in.readList(ExporterMigrationResult::new);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeList(this.exporters);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder.startObject().array("exporters", new Object[]{this.exporters}).endObject();
    }

    public List<ExporterMigrationResult> getExporters() {
        return this.exporters;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        MonitoringMigrateAlertsResponse response = (MonitoringMigrateAlertsResponse)((Object)o);
        return Objects.equals(this.exporters, response.exporters);
    }

    public int hashCode() {
        return Objects.hash(this.exporters);
    }

    public String toString() {
        return "MonitoringMigrateAlertsResponse{exporters=" + this.exporters + "}";
    }

    public static class ExporterMigrationResult
    implements Writeable,
    ToXContentObject {
        private final String name;
        private final String type;
        private final boolean migrationComplete;
        private final Exception reason;

        public ExporterMigrationResult(String name, String type, boolean migrationComplete, Exception reason) {
            this.name = name;
            this.type = type;
            this.migrationComplete = migrationComplete;
            this.reason = reason;
        }

        public ExporterMigrationResult(StreamInput in) throws IOException {
            this.name = in.readString();
            this.type = in.readString();
            this.migrationComplete = in.readBoolean();
            this.reason = in.readException();
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.name);
            out.writeString(this.type);
            out.writeBoolean(this.migrationComplete);
            out.writeException((Throwable)this.reason);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("name", this.name);
            builder.field("type", this.type);
            builder.field("migration_complete", this.migrationComplete);
            if (this.reason != null) {
                builder.startObject("reason");
                ElasticsearchException.generateThrowableXContent((XContentBuilder)builder, (ToXContent.Params)params, (Throwable)this.reason);
                builder.endObject();
            }
            return builder.endObject();
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }

        public boolean isMigrationComplete() {
            return this.migrationComplete;
        }

        @Nullable
        public Exception getReason() {
            return this.reason;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ExporterMigrationResult that = (ExporterMigrationResult)o;
            return this.migrationComplete == that.migrationComplete && Objects.equals(this.name, that.name) && Objects.equals(this.type, that.type);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.type, this.migrationComplete);
        }

        public String toString() {
            return "ExporterMigrationResult{name='" + this.name + "', type='" + this.type + "', migrationComplete=" + this.migrationComplete + ", reason=" + this.reason + "}";
        }
    }
}

