/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.inference.trainedmodel;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.query.QueryRewriteContext;
import org.elasticsearch.index.query.Rewriteable;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.MlConfigVersion;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.RegressionConfig;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.TargetType;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.ltr.LearnToRankFeatureExtractorBuilder;
import org.elasticsearch.xpack.core.ml.utils.NamedXContentObjectHelper;

public class LearnToRankConfig
extends RegressionConfig
implements Rewriteable<LearnToRankConfig> {
    public static final ParseField NAME = new ParseField("learn_to_rank", new String[0]);
    static final TransportVersion MIN_SUPPORTED_TRANSPORT_VERSION = TransportVersion.current();
    public static final ParseField NUM_TOP_FEATURE_IMPORTANCE_VALUES = new ParseField("num_top_feature_importance_values", new String[0]);
    public static final ParseField FEATURE_EXTRACTORS = new ParseField("feature_extractors", new String[0]);
    public static LearnToRankConfig EMPTY_PARAMS = new LearnToRankConfig(null, null);
    private static final ObjectParser<Builder, Boolean> LENIENT_PARSER = LearnToRankConfig.createParser(true);
    private static final ObjectParser<Builder, Boolean> STRICT_PARSER = LearnToRankConfig.createParser(false);
    private final List<LearnToRankFeatureExtractorBuilder> featureExtractorBuilders;

    private static ObjectParser<Builder, Boolean> createParser(boolean lenient) {
        ObjectParser parser = new ObjectParser(NAME.getPreferredName(), lenient, Builder::new);
        parser.declareInt(Builder::setNumTopFeatureImportanceValues, NUM_TOP_FEATURE_IMPORTANCE_VALUES);
        parser.declareNamedObjects(Builder::setLearnToRankFeatureExtractorBuilders, (p, c, n) -> (LearnToRankFeatureExtractorBuilder)p.namedObject(LearnToRankFeatureExtractorBuilder.class, n, (Object)lenient), b -> {}, FEATURE_EXTRACTORS);
        return parser;
    }

    public static LearnToRankConfig fromXContentStrict(XContentParser parser) {
        return ((Builder)STRICT_PARSER.apply(parser, null)).build();
    }

    public static LearnToRankConfig fromXContentLenient(XContentParser parser) {
        return ((Builder)LENIENT_PARSER.apply(parser, null)).build();
    }

    public LearnToRankConfig(Integer numTopFeatureImportanceValues, List<LearnToRankFeatureExtractorBuilder> featureExtractorBuilders) {
        super("predicted_value", numTopFeatureImportanceValues);
        Set featureNames;
        if (featureExtractorBuilders != null && (featureNames = featureExtractorBuilders.stream().map(LearnToRankFeatureExtractorBuilder::featureName).collect(Collectors.toSet())).size() < featureExtractorBuilders.size()) {
            throw new IllegalArgumentException("[" + FEATURE_EXTRACTORS.getPreferredName() + "] contains duplicate [feature_name] values");
        }
        this.featureExtractorBuilders = featureExtractorBuilders == null ? List.of() : featureExtractorBuilders;
    }

    public LearnToRankConfig(StreamInput in) throws IOException {
        super(in);
        this.featureExtractorBuilders = in.readNamedWriteableList(LearnToRankFeatureExtractorBuilder.class);
    }

    public List<LearnToRankFeatureExtractorBuilder> getFeatureExtractorBuilders() {
        return this.featureExtractorBuilders;
    }

    @Override
    public String getResultsField() {
        return "predicted_value";
    }

    @Override
    public boolean isAllocateOnly() {
        return false;
    }

    @Override
    public boolean supportsIngestPipeline() {
        return false;
    }

    @Override
    public boolean supportsPipelineAggregation() {
        return false;
    }

    @Override
    public boolean supportsSearchRescorer() {
        return true;
    }

    @Override
    public String getWriteableName() {
        return NAME.getPreferredName();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeNamedWriteableList(this.featureExtractorBuilders);
    }

    @Override
    public String getName() {
        return NAME.getPreferredName();
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(NUM_TOP_FEATURE_IMPORTANCE_VALUES.getPreferredName(), this.getNumTopFeatureImportanceValues());
        if (!this.featureExtractorBuilders.isEmpty()) {
            NamedXContentObjectHelper.writeNamedObjects(builder, params, true, FEATURE_EXTRACTORS.getPreferredName(), this.featureExtractorBuilders);
        }
        builder.endObject();
        return builder;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LearnToRankConfig that = (LearnToRankConfig)o;
        return Objects.equals(this.featureExtractorBuilders, that.featureExtractorBuilders);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.featureExtractorBuilders);
    }

    @Override
    public boolean isTargetTypeSupported(TargetType targetType) {
        return TargetType.REGRESSION.equals((Object)targetType);
    }

    @Override
    public MlConfigVersion getMinimalSupportedMlConfigVersion() {
        return MlConfigVersion.CURRENT;
    }

    @Override
    public TransportVersion getMinimalSupportedTransportVersion() {
        return MIN_SUPPORTED_TRANSPORT_VERSION;
    }

    public LearnToRankConfig rewrite(QueryRewriteContext ctx) throws IOException {
        if (this.featureExtractorBuilders.isEmpty()) {
            return this;
        }
        boolean rewritten = false;
        ArrayList<LearnToRankFeatureExtractorBuilder> rewrittenExtractors = new ArrayList<LearnToRankFeatureExtractorBuilder>(this.featureExtractorBuilders.size());
        for (LearnToRankFeatureExtractorBuilder extractorBuilder : this.featureExtractorBuilders) {
            LearnToRankFeatureExtractorBuilder rewrittenExtractor = (LearnToRankFeatureExtractorBuilder)Rewriteable.rewrite((Rewriteable)extractorBuilder, (QueryRewriteContext)ctx);
            rewrittenExtractors.add(rewrittenExtractor);
            rewritten |= rewrittenExtractor != extractorBuilder;
        }
        if (rewritten) {
            return new LearnToRankConfig(this.getNumTopFeatureImportanceValues(), rewrittenExtractors);
        }
        return this;
    }

    public static class Builder {
        private Integer numTopFeatureImportanceValues;
        private List<LearnToRankFeatureExtractorBuilder> learnToRankFeatureExtractorBuilders;

        Builder() {
        }

        Builder(LearnToRankConfig config) {
            this.numTopFeatureImportanceValues = config.getNumTopFeatureImportanceValues();
            this.learnToRankFeatureExtractorBuilders = config.featureExtractorBuilders;
        }

        public Builder setNumTopFeatureImportanceValues(Integer numTopFeatureImportanceValues) {
            this.numTopFeatureImportanceValues = numTopFeatureImportanceValues;
            return this;
        }

        public Builder setLearnToRankFeatureExtractorBuilders(List<LearnToRankFeatureExtractorBuilder> learnToRankFeatureExtractorBuilders) {
            this.learnToRankFeatureExtractorBuilders = learnToRankFeatureExtractorBuilders;
            return this;
        }

        public LearnToRankConfig build() {
            return new LearnToRankConfig(this.numTopFeatureImportanceValues, this.learnToRankFeatureExtractorBuilders);
        }
    }
}

