/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.inference.results;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.inference.results.NlpInferenceResults;

public class QuestionAnsweringInferenceResults
extends NlpInferenceResults {
    public static final String NAME = "question_answering";
    public static final ParseField START_OFFSET = new ParseField("start_offset", new String[0]);
    public static final ParseField END_OFFSET = new ParseField("end_offset", new String[0]);
    private final String resultsField;
    private final String answer;
    private final int startOffset;
    private final int endOffset;
    private final double score;
    private final List<TopAnswerEntry> topClasses;

    public QuestionAnsweringInferenceResults(String answer, int startOffset, int endOffset, List<TopAnswerEntry> topClasses, String resultsField, double score, boolean isTruncated) {
        super(isTruncated);
        this.startOffset = startOffset;
        this.endOffset = endOffset;
        this.answer = Objects.requireNonNull(answer);
        this.topClasses = topClasses == null ? Collections.emptyList() : Collections.unmodifiableList(topClasses);
        this.resultsField = resultsField;
        this.score = score;
    }

    public QuestionAnsweringInferenceResults(StreamInput in) throws IOException {
        super(in);
        this.answer = in.readString();
        this.startOffset = in.readVInt();
        this.endOffset = in.readVInt();
        this.topClasses = in.readImmutableList(TopAnswerEntry::fromStream);
        this.resultsField = in.readString();
        this.score = in.readDouble();
    }

    public String getAnswer() {
        return this.answer;
    }

    public List<TopAnswerEntry> getTopClasses() {
        return this.topClasses;
    }

    @Override
    public void doWriteTo(StreamOutput out) throws IOException {
        out.writeString(this.answer);
        out.writeVInt(this.startOffset);
        out.writeVInt(this.endOffset);
        out.writeCollection(this.topClasses);
        out.writeString(this.resultsField);
        out.writeDouble(this.score);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        QuestionAnsweringInferenceResults that = (QuestionAnsweringInferenceResults)o;
        return Objects.equals(this.resultsField, that.resultsField) && Objects.equals(this.answer, that.answer) && Objects.equals(this.startOffset, that.startOffset) && Objects.equals(this.endOffset, that.endOffset) && Objects.equals(this.score, that.score) && Objects.equals(this.topClasses, that.topClasses);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.resultsField, this.answer, this.score, this.topClasses, this.startOffset, this.endOffset);
    }

    public double getScore() {
        return this.score;
    }

    @Override
    public String getResultsField() {
        return this.resultsField;
    }

    @Override
    public String predictedValue() {
        return this.answer;
    }

    @Override
    void addMapFields(Map<String, Object> map) {
        map.put(this.resultsField, this.answer);
        map.put(START_OFFSET.getPreferredName(), this.startOffset);
        map.put(END_OFFSET.getPreferredName(), this.endOffset);
        if (!this.topClasses.isEmpty()) {
            map.put("top_classes", this.topClasses.stream().map(TopAnswerEntry::asValueMap).collect(Collectors.toList()));
        }
        map.put("prediction_probability", this.score);
    }

    public String getWriteableName() {
        return NAME;
    }

    @Override
    public void doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(this.resultsField, this.answer);
        builder.field(START_OFFSET.getPreferredName(), this.startOffset);
        builder.field(END_OFFSET.getPreferredName(), this.endOffset);
        if (this.topClasses.size() > 0) {
            builder.field("top_classes", this.topClasses);
        }
        builder.field("prediction_probability", this.score);
    }

    public int getStartOffset() {
        return this.startOffset;
    }

    public int getEndOffset() {
        return this.endOffset;
    }

    public record TopAnswerEntry(String answer, double score, int startOffset, int endOffset) implements Writeable,
    ToXContentObject
    {
        public static final ParseField ANSWER = new ParseField("answer", new String[0]);
        public static final ParseField SCORE = new ParseField("score", new String[0]);
        public static final String NAME = "top_answer";
        private static final ConstructingObjectParser<TopAnswerEntry, Void> PARSER = new ConstructingObjectParser("top_answer", a -> new TopAnswerEntry((String)a[0], (Double)a[1], (Integer)a[2], (Integer)a[3]));

        public static TopAnswerEntry fromStream(StreamInput in) throws IOException {
            return new TopAnswerEntry(in.readString(), in.readDouble(), in.readVInt(), in.readVInt());
        }

        public static TopAnswerEntry fromXContent(XContentParser parser) throws IOException {
            return (TopAnswerEntry)PARSER.parse(parser, null);
        }

        public Map<String, Object> asValueMap() {
            Map map = Maps.newMapWithExpectedSize((int)4);
            map.put(ANSWER.getPreferredName(), this.answer);
            map.put(START_OFFSET.getPreferredName(), this.startOffset);
            map.put(END_OFFSET.getPreferredName(), this.endOffset);
            map.put(SCORE.getPreferredName(), this.score);
            return map;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(ANSWER.getPreferredName(), this.answer);
            builder.field(START_OFFSET.getPreferredName(), this.startOffset);
            builder.field(END_OFFSET.getPreferredName(), this.endOffset);
            builder.field(SCORE.getPreferredName(), this.score);
            builder.endObject();
            return builder;
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.answer);
            out.writeDouble(this.score);
            out.writeVInt(this.startOffset);
            out.writeVInt(this.endOffset);
        }

        static {
            PARSER.declareString(ConstructingObjectParser.constructorArg(), ANSWER);
            PARSER.declareDouble(ConstructingObjectParser.constructorArg(), SCORE);
            PARSER.declareInt(ConstructingObjectParser.constructorArg(), START_OFFSET);
            PARSER.declareInt(ConstructingObjectParser.constructorArg(), END_OFFSET);
        }
    }
}

