/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.inference.assignment;

import java.io.IOException;
import java.time.Instant;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.ml.action.StartTrainedModelDeploymentAction;
import org.elasticsearch.xpack.core.ml.inference.assignment.AllocationStatus;
import org.elasticsearch.xpack.core.ml.inference.assignment.AssignmentState;
import org.elasticsearch.xpack.core.ml.inference.assignment.Priority;
import org.elasticsearch.xpack.core.ml.inference.assignment.RoutingState;
import org.elasticsearch.xpack.core.ml.inference.assignment.RoutingStateAndReason;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.InferenceStats;

public class AssignmentStats
implements ToXContentObject,
Writeable {
    private final String deploymentId;
    private final String modelId;
    private AssignmentState state;
    private AllocationStatus allocationStatus;
    private String reason;
    @Nullable
    private final Integer threadsPerAllocation;
    @Nullable
    private final Integer numberOfAllocations;
    @Nullable
    private final Integer queueCapacity;
    @Nullable
    private final ByteSizeValue cacheSize;
    private final Priority priority;
    private final Instant startTime;
    private final List<NodeStats> nodeStats;

    public AssignmentStats(String deploymentId, String modelId, @Nullable Integer threadsPerAllocation, @Nullable Integer numberOfAllocations, @Nullable Integer queueCapacity, @Nullable ByteSizeValue cacheSize, Instant startTime, List<NodeStats> nodeStats, Priority priority) {
        this.deploymentId = deploymentId;
        this.modelId = modelId;
        this.threadsPerAllocation = threadsPerAllocation;
        this.numberOfAllocations = numberOfAllocations;
        this.queueCapacity = queueCapacity;
        this.startTime = Objects.requireNonNull(startTime);
        this.nodeStats = nodeStats;
        this.cacheSize = cacheSize;
        this.state = null;
        this.reason = null;
        this.priority = Objects.requireNonNull(priority);
    }

    public AssignmentStats(StreamInput in) throws IOException {
        this.modelId = in.readString();
        this.threadsPerAllocation = in.readOptionalVInt();
        this.numberOfAllocations = in.readOptionalVInt();
        this.queueCapacity = in.readOptionalVInt();
        this.startTime = in.readInstant();
        this.nodeStats = in.readList(NodeStats::new);
        this.state = (AssignmentState)in.readOptionalEnum(AssignmentState.class);
        this.reason = in.readOptionalString();
        this.allocationStatus = (AllocationStatus)in.readOptionalWriteable(AllocationStatus::new);
        this.cacheSize = in.getTransportVersion().onOrAfter((VersionId)TransportVersion.V_8_4_0) ? (ByteSizeValue)in.readOptionalWriteable(ByteSizeValue::readFrom) : null;
        this.priority = in.getTransportVersion().onOrAfter((VersionId)TransportVersion.V_8_6_0) ? (Priority)in.readEnum(Priority.class) : Priority.NORMAL;
        this.deploymentId = in.getTransportVersion().onOrAfter((VersionId)TransportVersion.V_8_8_0) ? in.readString() : this.modelId;
    }

    public String getDeploymentId() {
        return this.deploymentId;
    }

    public String getModelId() {
        return this.modelId;
    }

    @Nullable
    public Integer getThreadsPerAllocation() {
        return this.threadsPerAllocation;
    }

    @Nullable
    public Integer getNumberOfAllocations() {
        return this.numberOfAllocations;
    }

    @Nullable
    public Integer getQueueCapacity() {
        return this.queueCapacity;
    }

    @Nullable
    public ByteSizeValue getCacheSize() {
        return this.cacheSize;
    }

    public Instant getStartTime() {
        return this.startTime;
    }

    public List<NodeStats> getNodeStats() {
        return this.nodeStats;
    }

    public AssignmentState getState() {
        return this.state;
    }

    public AssignmentStats setState(AssignmentState state) {
        this.state = state;
        return this;
    }

    public AssignmentStats setAllocationStatus(AllocationStatus allocationStatus) {
        this.allocationStatus = allocationStatus;
        return this;
    }

    public String getReason() {
        return this.reason;
    }

    public AssignmentStats setReason(String reason) {
        this.reason = reason;
        return this;
    }

    public Priority getPriority() {
        return this.priority;
    }

    public InferenceStats getOverallInferenceStats() {
        return new InferenceStats(0L, this.nodeStats.stream().filter(n -> n.getInferenceCount().isPresent()).mapToLong(n -> n.getInferenceCount().get()).sum(), this.nodeStats.stream().mapToLong(n -> n.getErrorCount() + n.getTimeoutCount() + n.getRejectedExecutionCount()).sum(), 0L, this.modelId, null, Instant.now());
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("deployment_id", this.deploymentId);
        builder.field("model_id", this.modelId);
        if (this.threadsPerAllocation != null) {
            builder.field(StartTrainedModelDeploymentAction.TaskParams.THREADS_PER_ALLOCATION.getPreferredName(), this.threadsPerAllocation);
        }
        if (this.numberOfAllocations != null) {
            builder.field(StartTrainedModelDeploymentAction.TaskParams.NUMBER_OF_ALLOCATIONS.getPreferredName(), this.numberOfAllocations);
        }
        if (this.queueCapacity != null) {
            builder.field(StartTrainedModelDeploymentAction.TaskParams.QUEUE_CAPACITY.getPreferredName(), this.queueCapacity);
        }
        if (this.state != null) {
            builder.field("state", (Enum)this.state);
        }
        if (this.reason != null) {
            builder.field("reason", this.reason);
        }
        if (this.allocationStatus != null) {
            builder.field("allocation_status", (ToXContent)this.allocationStatus);
        }
        if (this.cacheSize != null) {
            builder.field("cache_size", (ToXContent)this.cacheSize);
        }
        builder.field("priority", (Enum)this.priority);
        builder.timeField("start_time", "start_time_string", this.startTime.toEpochMilli());
        int totalErrorCount = this.nodeStats.stream().mapToInt(NodeStats::getErrorCount).sum();
        int totalRejectedExecutionCount = this.nodeStats.stream().mapToInt(NodeStats::getRejectedExecutionCount).sum();
        int totalTimeoutCount = this.nodeStats.stream().mapToInt(NodeStats::getTimeoutCount).sum();
        long totalInferenceCount = this.nodeStats.stream().filter(n -> n.getInferenceCount().isPresent()).mapToLong(n -> n.getInferenceCount().get()).sum();
        long peakThroughput = this.nodeStats.stream().mapToLong(NodeStats::getPeakThroughput).sum();
        if (totalErrorCount > 0) {
            builder.field("error_count", totalErrorCount);
        }
        if (totalRejectedExecutionCount > 0) {
            builder.field("rejected_execution_count", totalRejectedExecutionCount);
        }
        if (totalTimeoutCount > 0) {
            builder.field("timeout_count", totalTimeoutCount);
        }
        if (totalInferenceCount > 0L) {
            builder.field("inference_count", totalInferenceCount);
        }
        builder.field("peak_throughput_per_minute", peakThroughput);
        builder.startArray("nodes");
        for (NodeStats nodeStat : this.nodeStats) {
            nodeStat.toXContent(builder, params);
        }
        builder.endArray();
        builder.endObject();
        return builder;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.modelId);
        out.writeOptionalVInt(this.threadsPerAllocation);
        out.writeOptionalVInt(this.numberOfAllocations);
        out.writeOptionalVInt(this.queueCapacity);
        out.writeInstant(this.startTime);
        out.writeList(this.nodeStats);
        if (AssignmentState.FAILED.equals((Object)this.state) && out.getTransportVersion().before((VersionId)TransportVersion.V_8_4_0)) {
            out.writeOptionalEnum((Enum)AssignmentState.STARTING);
        } else {
            out.writeOptionalEnum((Enum)this.state);
        }
        out.writeOptionalString(this.reason);
        out.writeOptionalWriteable((Writeable)this.allocationStatus);
        if (out.getTransportVersion().onOrAfter((VersionId)TransportVersion.V_8_4_0)) {
            out.writeOptionalWriteable((Writeable)this.cacheSize);
        }
        if (out.getTransportVersion().onOrAfter((VersionId)TransportVersion.V_8_6_0)) {
            out.writeEnum((Enum)this.priority);
        }
        if (out.getTransportVersion().onOrAfter((VersionId)TransportVersion.V_8_8_0)) {
            out.writeString(this.deploymentId);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AssignmentStats that = (AssignmentStats)o;
        return Objects.equals(this.deploymentId, that.deploymentId) && Objects.equals(this.modelId, that.modelId) && Objects.equals(this.threadsPerAllocation, that.threadsPerAllocation) && Objects.equals(this.numberOfAllocations, that.numberOfAllocations) && Objects.equals(this.queueCapacity, that.queueCapacity) && Objects.equals(this.startTime, that.startTime) && Objects.equals((Object)this.state, (Object)that.state) && Objects.equals(this.reason, that.reason) && Objects.equals(this.allocationStatus, that.allocationStatus) && Objects.equals(this.cacheSize, that.cacheSize) && Objects.equals(this.nodeStats, that.nodeStats) && this.priority == that.priority;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.deploymentId, this.modelId, this.threadsPerAllocation, this.numberOfAllocations, this.queueCapacity, this.startTime, this.nodeStats, this.state, this.reason, this.allocationStatus, this.cacheSize, this.priority});
    }

    public String toString() {
        return Strings.toString((ToXContent)this);
    }

    public static class NodeStats
    implements ToXContentObject,
    Writeable {
        private final DiscoveryNode node;
        private final Long inferenceCount;
        private final Double avgInferenceTime;
        private final Double avgInferenceTimeExcludingCacheHit;
        private final Instant lastAccess;
        private final Integer pendingCount;
        private final int errorCount;
        private final Long cacheHitCount;
        private final int rejectedExecutionCount;
        private final int timeoutCount;
        private final RoutingStateAndReason routingState;
        private final Instant startTime;
        private final Integer threadsPerAllocation;
        private final Integer numberOfAllocations;
        private final long peakThroughput;
        private final long throughputLastPeriod;
        private final Double avgInferenceTimeLastPeriod;
        private final Long cacheHitCountLastPeriod;

        public static NodeStats forStartedState(DiscoveryNode node, long inferenceCount, Double avgInferenceTime, Double avgInferenceTimeExcludingCacheHit, int pendingCount, int errorCount, long cacheHitCount, int rejectedExecutionCount, int timeoutCount, Instant lastAccess, Instant startTime, Integer threadsPerAllocation, Integer numberOfAllocations, long peakThroughput, long throughputLastPeriod, Double avgInferenceTimeLastPeriod, long cacheHitCountLastPeriod) {
            return new NodeStats(node, inferenceCount, avgInferenceTime, avgInferenceTimeExcludingCacheHit, lastAccess, pendingCount, errorCount, cacheHitCount, rejectedExecutionCount, timeoutCount, new RoutingStateAndReason(RoutingState.STARTED, null), Objects.requireNonNull(startTime), threadsPerAllocation, numberOfAllocations, peakThroughput, throughputLastPeriod, avgInferenceTimeLastPeriod, cacheHitCountLastPeriod);
        }

        public static NodeStats forNotStartedState(DiscoveryNode node, RoutingState state, String reason) {
            return new NodeStats(node, null, null, null, null, null, 0, null, 0, 0, new RoutingStateAndReason(state, reason), null, null, null, 0L, 0L, null, null);
        }

        public NodeStats(DiscoveryNode node, Long inferenceCount, Double avgInferenceTime, Double avgInferenceTimeExcludingCacheHit, @Nullable Instant lastAccess, Integer pendingCount, int errorCount, Long cacheHitCount, int rejectedExecutionCount, int timeoutCount, RoutingStateAndReason routingState, @Nullable Instant startTime, @Nullable Integer threadsPerAllocation, @Nullable Integer numberOfAllocations, long peakThroughput, long throughputLastPeriod, Double avgInferenceTimeLastPeriod, Long cacheHitCountLastPeriod) {
            this.node = node;
            this.inferenceCount = inferenceCount;
            this.avgInferenceTime = avgInferenceTime;
            this.avgInferenceTimeExcludingCacheHit = avgInferenceTimeExcludingCacheHit;
            this.lastAccess = lastAccess;
            this.pendingCount = pendingCount;
            this.errorCount = errorCount;
            this.cacheHitCount = cacheHitCount;
            this.rejectedExecutionCount = rejectedExecutionCount;
            this.timeoutCount = timeoutCount;
            this.routingState = routingState;
            this.startTime = startTime;
            this.threadsPerAllocation = threadsPerAllocation;
            this.numberOfAllocations = numberOfAllocations;
            this.peakThroughput = peakThroughput;
            this.throughputLastPeriod = throughputLastPeriod;
            this.avgInferenceTimeLastPeriod = avgInferenceTimeLastPeriod;
            this.cacheHitCountLastPeriod = cacheHitCountLastPeriod;
            assert (this.lastAccess != null || inferenceCount == null || inferenceCount == 0L);
        }

        public NodeStats(StreamInput in) throws IOException {
            this.node = (DiscoveryNode)in.readOptionalWriteable(DiscoveryNode::new);
            this.inferenceCount = in.readOptionalLong();
            this.avgInferenceTime = in.readOptionalDouble();
            this.lastAccess = in.readOptionalInstant();
            this.pendingCount = in.readOptionalVInt();
            this.routingState = (RoutingStateAndReason)in.readOptionalWriteable(RoutingStateAndReason::new);
            this.startTime = in.readOptionalInstant();
            if (in.getTransportVersion().onOrAfter((VersionId)TransportVersion.V_8_1_0)) {
                this.threadsPerAllocation = in.readOptionalVInt();
                this.numberOfAllocations = in.readOptionalVInt();
                this.errorCount = in.readVInt();
                this.rejectedExecutionCount = in.readVInt();
                this.timeoutCount = in.readVInt();
            } else {
                this.threadsPerAllocation = null;
                this.numberOfAllocations = null;
                this.errorCount = 0;
                this.rejectedExecutionCount = 0;
                this.timeoutCount = 0;
            }
            if (in.getTransportVersion().onOrAfter((VersionId)TransportVersion.V_8_2_0)) {
                this.peakThroughput = in.readVLong();
                this.throughputLastPeriod = in.readVLong();
                this.avgInferenceTimeLastPeriod = in.readOptionalDouble();
            } else {
                this.peakThroughput = 0L;
                this.throughputLastPeriod = 0L;
                this.avgInferenceTimeLastPeriod = null;
            }
            if (in.getTransportVersion().onOrAfter((VersionId)TransportVersion.V_8_4_0)) {
                this.cacheHitCount = in.readOptionalVLong();
                this.cacheHitCountLastPeriod = in.readOptionalVLong();
            } else {
                this.cacheHitCount = null;
                this.cacheHitCountLastPeriod = null;
            }
            this.avgInferenceTimeExcludingCacheHit = in.getTransportVersion().onOrAfter((VersionId)TransportVersion.V_8_5_0) ? in.readOptionalDouble() : null;
        }

        public DiscoveryNode getNode() {
            return this.node;
        }

        public RoutingStateAndReason getRoutingState() {
            return this.routingState;
        }

        public Optional<Long> getInferenceCount() {
            return Optional.ofNullable(this.inferenceCount);
        }

        public Optional<Double> getAvgInferenceTime() {
            return Optional.ofNullable(this.avgInferenceTime);
        }

        public Optional<Double> getAvgInferenceTimeExcludingCacheHit() {
            return Optional.ofNullable(this.avgInferenceTimeExcludingCacheHit);
        }

        public Instant getLastAccess() {
            return this.lastAccess;
        }

        public Integer getPendingCount() {
            return this.pendingCount;
        }

        public int getErrorCount() {
            return this.errorCount;
        }

        public Optional<Long> getCacheHitCount() {
            return Optional.ofNullable(this.cacheHitCount);
        }

        public int getRejectedExecutionCount() {
            return this.rejectedExecutionCount;
        }

        public int getTimeoutCount() {
            return this.timeoutCount;
        }

        public Instant getStartTime() {
            return this.startTime;
        }

        public Integer getThreadsPerAllocation() {
            return this.threadsPerAllocation;
        }

        public Integer getNumberOfAllocations() {
            return this.numberOfAllocations;
        }

        public long getPeakThroughput() {
            return this.peakThroughput;
        }

        public long getThroughputLastPeriod() {
            return this.throughputLastPeriod;
        }

        public Double getAvgInferenceTimeLastPeriod() {
            return this.avgInferenceTimeLastPeriod;
        }

        public Optional<Long> getCacheHitCountLastPeriod() {
            return Optional.ofNullable(this.cacheHitCountLastPeriod);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            if (this.node != null) {
                builder.startObject("node");
                this.node.toXContent(builder, params);
                builder.endObject();
            }
            builder.field("routing_state", (ToXContent)this.routingState);
            if (this.inferenceCount != null) {
                builder.field("inference_count", this.inferenceCount);
            }
            if (this.inferenceCount != null && this.inferenceCount > 0L) {
                if (this.avgInferenceTime != null) {
                    builder.field("average_inference_time_ms", this.avgInferenceTime);
                }
                if (this.avgInferenceTimeExcludingCacheHit != null) {
                    builder.field("average_inference_time_ms_excluding_cache_hits", this.avgInferenceTimeExcludingCacheHit);
                }
            }
            if (this.cacheHitCount != null) {
                builder.field("inference_cache_hit_count", this.cacheHitCount);
            }
            if (this.lastAccess != null) {
                builder.timeField("last_access", "last_access_string", this.lastAccess.toEpochMilli());
            }
            if (this.pendingCount != null) {
                builder.field("number_of_pending_requests", this.pendingCount);
            }
            if (this.errorCount > 0) {
                builder.field("error_count", this.errorCount);
            }
            if (this.rejectedExecutionCount > 0) {
                builder.field("rejected_execution_count", this.rejectedExecutionCount);
            }
            if (this.timeoutCount > 0) {
                builder.field("timeout_count", this.timeoutCount);
            }
            if (this.startTime != null) {
                builder.timeField("start_time", "start_time_string", this.startTime.toEpochMilli());
            }
            if (this.threadsPerAllocation != null) {
                builder.field("threads_per_allocation", this.threadsPerAllocation);
            }
            if (this.numberOfAllocations != null) {
                builder.field("number_of_allocations", this.numberOfAllocations);
            }
            builder.field("peak_throughput_per_minute", this.peakThroughput);
            builder.field("throughput_last_minute", this.throughputLastPeriod);
            if (this.avgInferenceTimeLastPeriod != null) {
                builder.field("average_inference_time_ms_last_minute", this.avgInferenceTimeLastPeriod);
            }
            if (this.cacheHitCountLastPeriod != null) {
                builder.field("inference_cache_hit_count_last_minute", this.cacheHitCountLastPeriod);
            }
            builder.endObject();
            return builder;
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeOptionalWriteable((Writeable)this.node);
            out.writeOptionalLong(this.inferenceCount);
            out.writeOptionalDouble(this.avgInferenceTime);
            out.writeOptionalInstant(this.lastAccess);
            out.writeOptionalVInt(this.pendingCount);
            out.writeOptionalWriteable((Writeable)this.routingState);
            out.writeOptionalInstant(this.startTime);
            if (out.getTransportVersion().onOrAfter((VersionId)TransportVersion.V_8_1_0)) {
                out.writeOptionalVInt(this.threadsPerAllocation);
                out.writeOptionalVInt(this.numberOfAllocations);
                out.writeVInt(this.errorCount);
                out.writeVInt(this.rejectedExecutionCount);
                out.writeVInt(this.timeoutCount);
            }
            if (out.getTransportVersion().onOrAfter((VersionId)TransportVersion.V_8_2_0)) {
                out.writeVLong(this.peakThroughput);
                out.writeVLong(this.throughputLastPeriod);
                out.writeOptionalDouble(this.avgInferenceTimeLastPeriod);
            }
            if (out.getTransportVersion().onOrAfter((VersionId)TransportVersion.V_8_4_0)) {
                out.writeOptionalVLong(this.cacheHitCount);
                out.writeOptionalVLong(this.cacheHitCountLastPeriod);
            }
            if (out.getTransportVersion().onOrAfter((VersionId)TransportVersion.V_8_5_0)) {
                out.writeOptionalDouble(this.avgInferenceTimeExcludingCacheHit);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NodeStats that = (NodeStats)o;
            return Objects.equals(this.inferenceCount, that.inferenceCount) && Objects.equals(that.avgInferenceTime, this.avgInferenceTime) && Objects.equals(that.avgInferenceTimeExcludingCacheHit, this.avgInferenceTimeExcludingCacheHit) && Objects.equals(this.node, that.node) && Objects.equals(this.lastAccess, that.lastAccess) && Objects.equals(this.pendingCount, that.pendingCount) && Objects.equals(this.errorCount, that.errorCount) && Objects.equals(this.cacheHitCount, that.cacheHitCount) && Objects.equals(this.rejectedExecutionCount, that.rejectedExecutionCount) && Objects.equals(this.timeoutCount, that.timeoutCount) && Objects.equals(this.routingState, that.routingState) && Objects.equals(this.startTime, that.startTime) && Objects.equals(this.threadsPerAllocation, that.threadsPerAllocation) && Objects.equals(this.numberOfAllocations, that.numberOfAllocations) && Objects.equals(this.peakThroughput, that.peakThroughput) && Objects.equals(this.throughputLastPeriod, that.throughputLastPeriod) && Objects.equals(this.avgInferenceTimeLastPeriod, that.avgInferenceTimeLastPeriod) && Objects.equals(this.cacheHitCountLastPeriod, that.cacheHitCountLastPeriod);
        }

        public int hashCode() {
            return Objects.hash(this.node, this.inferenceCount, this.avgInferenceTime, this.avgInferenceTimeExcludingCacheHit, this.lastAccess, this.pendingCount, this.errorCount, this.cacheHitCount, this.rejectedExecutionCount, this.timeoutCount, this.routingState, this.startTime, this.threadsPerAllocation, this.numberOfAllocations, this.peakThroughput, this.throughputLastPeriod, this.avgInferenceTimeLastPeriod, this.cacheHitCountLastPeriod);
        }
    }
}

