/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.action;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.action.support.nodes.BaseNodeResponse;
import org.elasticsearch.action.support.nodes.BaseNodesResponse;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodeRole;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public class MlMemoryAction
extends ActionType<Response> {
    public static final MlMemoryAction INSTANCE = new MlMemoryAction();
    public static final String NAME = "cluster:monitor/xpack/ml/memory/stats/get";
    static final String MEM = "mem";
    static final String TOTAL = "total";
    static final String TOTAL_IN_BYTES = "total_in_bytes";
    static final String ADJUSTED_TOTAL = "adjusted_total";
    static final String ADJUSTED_TOTAL_IN_BYTES = "adjusted_total_in_bytes";
    static final String ML = "ml";
    static final String MAX = "max";
    static final String MAX_IN_BYTES = "max_in_bytes";
    static final String NATIVE_CODE_OVERHEAD = "native_code_overhead";
    static final String NATIVE_CODE_OVERHEAD_IN_BYTES = "native_code_overhead_in_bytes";
    static final String ANOMALY_DETECTORS = "anomaly_detectors";
    static final String ANOMALY_DETECTORS_IN_BYTES = "anomaly_detectors_in_bytes";
    static final String DATA_FRAME_ANALYTICS = "data_frame_analytics";
    static final String DATA_FRAME_ANALYTICS_IN_BYTES = "data_frame_analytics_in_bytes";
    static final String NATIVE_INFERENCE = "native_inference";
    static final String NATIVE_INFERENCE_IN_BYTES = "native_inference_in_bytes";
    static final String JVM = "jvm";
    static final String HEAP_MAX = "heap_max";
    static final String HEAP_MAX_IN_BYTES = "heap_max_in_bytes";
    static final String JAVA_INFERENCE_MAX = "java_inference_max";
    static final String JAVA_INFERENCE_MAX_IN_BYTES = "java_inference_max_in_bytes";
    static final String JAVA_INFERENCE = "java_inference";
    static final String JAVA_INFERENCE_IN_BYTES = "java_inference_in_bytes";

    private MlMemoryAction() {
        super(NAME, Response::new);
    }

    public static class Response
    extends BaseNodesResponse<MlMemoryStats>
    implements ToXContentFragment {
        public Response(StreamInput in) throws IOException {
            super(in);
        }

        public Response(ClusterName clusterName, List<MlMemoryStats> nodes, List<FailedNodeException> failures) {
            super(clusterName, nodes, failures);
        }

        protected List<MlMemoryStats> readNodesFrom(StreamInput in) throws IOException {
            return in.readList(MlMemoryStats::new);
        }

        protected void writeNodesTo(StreamOutput out, List<MlMemoryStats> nodes) throws IOException {
            out.writeList(nodes);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject("nodes");
            for (MlMemoryStats mlMemoryStats : this.getNodes()) {
                mlMemoryStats.toXContent(builder, params);
            }
            builder.endObject();
            return builder;
        }

        public int hashCode() {
            return Objects.hash(this.getNodes());
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            Response other = (Response)((Object)obj);
            return Objects.equals(this.getNodes(), other.getNodes());
        }

        public final String toString() {
            return Strings.toString((ToXContent)this);
        }

        public static class MlMemoryStats
        extends BaseNodeResponse
        implements ToXContent,
        Writeable {
            private final ByteSizeValue memTotal;
            private final ByteSizeValue memAdjustedTotal;
            private final ByteSizeValue mlMax;
            private final ByteSizeValue mlNativeCodeOverhead;
            private final ByteSizeValue mlAnomalyDetectors;
            private final ByteSizeValue mlDataFrameAnalytics;
            private final ByteSizeValue mlNativeInference;
            private final ByteSizeValue jvmHeapMax;
            private final ByteSizeValue jvmInferenceMax;
            private final ByteSizeValue jvmInference;

            public MlMemoryStats(DiscoveryNode node, ByteSizeValue memTotal, ByteSizeValue memAdjustedTotal, ByteSizeValue mlMax, ByteSizeValue mlNativeCodeOverhead, ByteSizeValue mlAnomalyDetectors, ByteSizeValue mlDataFrameAnalytics, ByteSizeValue mlNativeInference, ByteSizeValue jvmHeapMax, ByteSizeValue jvmInferenceMax, ByteSizeValue jvmInference) {
                super(node);
                this.memTotal = Objects.requireNonNull(memTotal);
                this.memAdjustedTotal = Objects.requireNonNull(memAdjustedTotal);
                this.mlMax = Objects.requireNonNull(mlMax);
                this.mlNativeCodeOverhead = Objects.requireNonNull(mlNativeCodeOverhead);
                this.mlAnomalyDetectors = Objects.requireNonNull(mlAnomalyDetectors);
                this.mlDataFrameAnalytics = Objects.requireNonNull(mlDataFrameAnalytics);
                this.mlNativeInference = Objects.requireNonNull(mlNativeInference);
                this.jvmHeapMax = Objects.requireNonNull(jvmHeapMax);
                this.jvmInferenceMax = Objects.requireNonNull(jvmInferenceMax);
                this.jvmInference = Objects.requireNonNull(jvmInference);
            }

            public MlMemoryStats(StreamInput in) throws IOException {
                super(in);
                this.memTotal = ByteSizeValue.readFrom((StreamInput)in);
                this.memAdjustedTotal = ByteSizeValue.readFrom((StreamInput)in);
                this.mlMax = ByteSizeValue.readFrom((StreamInput)in);
                this.mlNativeCodeOverhead = ByteSizeValue.readFrom((StreamInput)in);
                this.mlAnomalyDetectors = ByteSizeValue.readFrom((StreamInput)in);
                this.mlDataFrameAnalytics = ByteSizeValue.readFrom((StreamInput)in);
                this.mlNativeInference = ByteSizeValue.readFrom((StreamInput)in);
                this.jvmHeapMax = ByteSizeValue.readFrom((StreamInput)in);
                this.jvmInferenceMax = ByteSizeValue.readFrom((StreamInput)in);
                this.jvmInference = ByteSizeValue.readFrom((StreamInput)in);
            }

            public ByteSizeValue getMemTotal() {
                return this.memTotal;
            }

            public ByteSizeValue getMemAdjustedTotal() {
                return this.memAdjustedTotal;
            }

            public ByteSizeValue getMlMax() {
                return this.mlMax;
            }

            public ByteSizeValue getMlNativeCodeOverhead() {
                return this.mlNativeCodeOverhead;
            }

            public ByteSizeValue getMlAnomalyDetectors() {
                return this.mlAnomalyDetectors;
            }

            public ByteSizeValue getMlDataFrameAnalytics() {
                return this.mlDataFrameAnalytics;
            }

            public ByteSizeValue getMlNativeInference() {
                return this.mlNativeInference;
            }

            public ByteSizeValue getJvmHeapMax() {
                return this.jvmHeapMax;
            }

            public ByteSizeValue getJvmInferenceMax() {
                return this.jvmInferenceMax;
            }

            public ByteSizeValue getJvmInference() {
                return this.jvmInference;
            }

            public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
                DiscoveryNode node = this.getNode();
                builder.startObject(node.getId());
                builder.field("name", node.getName());
                builder.field("ephemeral_id", node.getEphemeralId());
                builder.field("transport_address", node.getAddress().toString());
                builder.startObject("attributes");
                for (Map.Entry entry : node.getAttributes().entrySet()) {
                    if (!((String)entry.getKey()).startsWith("ml.")) continue;
                    builder.field((String)entry.getKey(), (String)entry.getValue());
                }
                builder.endObject();
                builder.startArray("roles");
                for (DiscoveryNodeRole role : node.getRoles()) {
                    builder.value(role.roleName());
                }
                builder.endArray();
                builder.startObject(MlMemoryAction.MEM);
                builder.humanReadableField(MlMemoryAction.TOTAL_IN_BYTES, MlMemoryAction.TOTAL, (Object)this.memTotal);
                builder.humanReadableField(MlMemoryAction.ADJUSTED_TOTAL_IN_BYTES, MlMemoryAction.ADJUSTED_TOTAL, (Object)this.memAdjustedTotal);
                builder.startObject(MlMemoryAction.ML);
                builder.humanReadableField(MlMemoryAction.MAX_IN_BYTES, MlMemoryAction.MAX, (Object)this.mlMax);
                builder.humanReadableField(MlMemoryAction.NATIVE_CODE_OVERHEAD_IN_BYTES, MlMemoryAction.NATIVE_CODE_OVERHEAD, (Object)this.mlNativeCodeOverhead);
                builder.humanReadableField(MlMemoryAction.ANOMALY_DETECTORS_IN_BYTES, MlMemoryAction.ANOMALY_DETECTORS, (Object)this.mlAnomalyDetectors);
                builder.humanReadableField(MlMemoryAction.DATA_FRAME_ANALYTICS_IN_BYTES, MlMemoryAction.DATA_FRAME_ANALYTICS, (Object)this.mlDataFrameAnalytics);
                builder.humanReadableField(MlMemoryAction.NATIVE_INFERENCE_IN_BYTES, MlMemoryAction.NATIVE_INFERENCE, (Object)this.mlNativeInference);
                builder.endObject();
                builder.endObject();
                builder.startObject(MlMemoryAction.JVM);
                builder.humanReadableField(MlMemoryAction.HEAP_MAX_IN_BYTES, MlMemoryAction.HEAP_MAX, (Object)this.jvmHeapMax);
                builder.humanReadableField(MlMemoryAction.JAVA_INFERENCE_MAX_IN_BYTES, MlMemoryAction.JAVA_INFERENCE_MAX, (Object)this.jvmInferenceMax);
                builder.humanReadableField(MlMemoryAction.JAVA_INFERENCE_IN_BYTES, MlMemoryAction.JAVA_INFERENCE, (Object)this.jvmInference);
                builder.endObject();
                builder.endObject();
                return builder;
            }

            public void writeTo(StreamOutput out) throws IOException {
                super.writeTo(out);
                this.memTotal.writeTo(out);
                this.memAdjustedTotal.writeTo(out);
                this.mlMax.writeTo(out);
                this.mlNativeCodeOverhead.writeTo(out);
                this.mlAnomalyDetectors.writeTo(out);
                this.mlDataFrameAnalytics.writeTo(out);
                this.mlNativeInference.writeTo(out);
                this.jvmHeapMax.writeTo(out);
                this.jvmInferenceMax.writeTo(out);
                this.jvmInference.writeTo(out);
            }

            public int hashCode() {
                return Objects.hash(this.getNode(), this.memTotal, this.memAdjustedTotal, this.mlMax, this.mlNativeCodeOverhead, this.mlAnomalyDetectors, this.mlDataFrameAnalytics, this.mlNativeInference, this.jvmHeapMax, this.jvmInferenceMax, this.jvmInference);
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                    return false;
                }
                MlMemoryStats that = (MlMemoryStats)((Object)o);
                return Objects.equals(this.getNode(), that.getNode()) && Objects.equals(this.memTotal, that.memTotal) && Objects.equals(this.memAdjustedTotal, that.memAdjustedTotal) && Objects.equals(this.mlMax, that.mlMax) && Objects.equals(this.mlNativeCodeOverhead, that.mlNativeCodeOverhead) && Objects.equals(this.mlAnomalyDetectors, that.mlAnomalyDetectors) && Objects.equals(this.mlDataFrameAnalytics, that.mlDataFrameAnalytics) && Objects.equals(this.mlNativeInference, that.mlNativeInference) && Objects.equals(this.jvmHeapMax, that.jvmHeapMax) && Objects.equals(this.jvmInferenceMax, that.jvmInferenceMax) && Objects.equals(this.jvmInference, that.jvmInference);
            }

            public String toString() {
                return Strings.toString((ToXContent)this);
            }
        }
    }

    public static class Request
    extends AcknowledgedRequest<Request> {
        private final String nodeId;

        public Request(String nodeId) {
            this.nodeId = ExceptionsHelper.requireNonNull(nodeId, "nodeId");
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.nodeId = in.readString();
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.nodeId);
        }

        public String getNodeId() {
            return this.nodeId;
        }

        public ActionRequestValidationException validate() {
            return null;
        }

        public int hashCode() {
            return Objects.hash(this.nodeId);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            Request other = (Request)((Object)obj);
            return Objects.equals(this.nodeId, other.nodeId);
        }
    }
}

