/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml;

import org.elasticsearch.Version;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.xpack.core.template.TemplateUtils;

public final class MlConfigIndex {
    private static final String INDEX_NAME = ".ml-config";
    private static final String MAPPINGS_VERSION_VARIABLE = "xpack.ml.version";
    public static final int CONFIG_INDEX_MAX_RESULTS_WINDOW = 10000;

    public static String indexName() {
        return INDEX_NAME;
    }

    public static String mapping() {
        return TemplateUtils.loadTemplate("/ml/config_index_mappings.json", Version.CURRENT.toString(), MAPPINGS_VERSION_VARIABLE);
    }

    public static Settings settings() {
        return Settings.builder().put("index.number_of_shards", 1).put("index.auto_expand_replicas", "0-1").put(IndexSettings.MAX_RESULT_WINDOW_SETTING.getKey(), 10000).build();
    }

    private MlConfigIndex() {
    }
}

