/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ilm;

import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.downsample.DownsampleAction;
import org.elasticsearch.action.downsample.DownsampleConfig;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateObserver;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.LifecycleExecutionState;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramInterval;
import org.elasticsearch.xpack.core.ilm.AsyncActionStep;
import org.elasticsearch.xpack.core.ilm.Step;

public class DownsampleStep
extends AsyncActionStep {
    public static final String NAME = "rollup";
    private static final Logger LOGGER = LogManager.getLogger(DownsampleStep.class);
    private final DateHistogramInterval fixedInterval;
    private final TimeValue waitTimeout;

    public DownsampleStep(Step.StepKey key, Step.StepKey nextStepKey, Client client, DateHistogramInterval fixedInterval, TimeValue waitTimeout) {
        super(key, nextStepKey, client);
        this.fixedInterval = fixedInterval;
        this.waitTimeout = waitTimeout;
    }

    @Override
    public boolean isRetryable() {
        return true;
    }

    @Override
    public void performAction(IndexMetadata indexMetadata, ClusterState currentState, ClusterStateObserver observer, ActionListener<Void> listener) {
        IndexMetadata.DownsampleTaskStatus downsampleIndexStatus;
        LifecycleExecutionState lifecycleState = indexMetadata.getLifecycleExecutionState();
        if (lifecycleState.lifecycleDate() == null) {
            throw new IllegalStateException("source index [" + indexMetadata.getIndex().getName() + "] is missing lifecycle date");
        }
        String policyName = indexMetadata.getLifecyclePolicyName();
        String indexName = indexMetadata.getIndex().getName();
        String downsampleIndexName = lifecycleState.downsampleIndexName();
        IndexMetadata downsampleIndexMetadata = currentState.metadata().index(downsampleIndexName);
        if (downsampleIndexMetadata != null && IndexMetadata.DownsampleTaskStatus.SUCCESS.equals((Object)(downsampleIndexStatus = (IndexMetadata.DownsampleTaskStatus)IndexMetadata.INDEX_DOWNSAMPLE_STATUS.get(downsampleIndexMetadata.getSettings())))) {
            LOGGER.info("skipping [{}] step for index [{}] as part of policy [{}] as the downsample index [{}] already exists", (Object)NAME, (Object)indexName, (Object)policyName, (Object)downsampleIndexName);
            listener.onResponse(null);
            return;
        }
        this.performDownsampleIndex(indexName, downsampleIndexName, (ActionListener<Void>)ActionListener.wrap(arg_0 -> listener.onResponse(arg_0), arg_0 -> listener.onFailure(arg_0)));
    }

    void performDownsampleIndex(String indexName, String downsampleIndexName, ActionListener<Void> listener) {
        DownsampleConfig config = new DownsampleConfig(this.fixedInterval);
        DownsampleAction.Request request = (DownsampleAction.Request)new DownsampleAction.Request(indexName, downsampleIndexName, this.waitTimeout, config).masterNodeTimeout(TimeValue.MAX_VALUE);
        this.getClient().execute((ActionType)DownsampleAction.INSTANCE, (ActionRequest)request, listener.delegateFailureAndWrap((l, response) -> l.onResponse(null)));
    }

    public DateHistogramInterval getFixedInterval() {
        return this.fixedInterval;
    }

    public TimeValue getWaitTimeout() {
        return this.waitTimeout;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.fixedInterval, this.waitTimeout);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DownsampleStep other = (DownsampleStep)obj;
        return super.equals(obj) && Objects.equals(this.fixedInterval, other.fixedInterval) && Objects.equals(this.waitTimeout, other.waitTimeout);
    }
}

