/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.deprecation;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public class DeprecationIssue
implements Writeable,
ToXContentObject {
    private static final String ACTIONS_META_FIELD = "actions";
    private static final String OBJECTS_FIELD = "objects";
    private static final String ACTION_TYPE = "action_type";
    private static final String REMOVE_SETTINGS_ACTION_TYPE = "remove_settings";
    private final Level level;
    private final String message;
    private final String url;
    private final String details;
    private final boolean resolveDuringRollingUpgrade;
    private final Map<String, Object> meta;

    public DeprecationIssue(Level level, String message, String url, @Nullable String details, boolean resolveDuringRollingUpgrade, @Nullable Map<String, Object> meta) {
        this.level = level;
        this.message = message;
        this.url = url;
        this.details = details;
        this.resolveDuringRollingUpgrade = resolveDuringRollingUpgrade;
        this.meta = meta;
    }

    public DeprecationIssue(StreamInput in) throws IOException {
        this.level = Level.readFromStream(in);
        this.message = in.readString();
        this.url = in.readString();
        this.details = in.readOptionalString();
        this.resolveDuringRollingUpgrade = in.readBoolean();
        this.meta = in.readMap();
    }

    public Level getLevel() {
        return this.level;
    }

    public String getMessage() {
        return this.message;
    }

    public String getUrl() {
        return this.url;
    }

    public String getDetails() {
        return this.details;
    }

    public boolean isResolveDuringRollingUpgrade() {
        return this.resolveDuringRollingUpgrade;
    }

    public Map<String, Object> getMeta() {
        return this.meta;
    }

    private Optional<Meta> getMetaObject() {
        return Meta.fromMetaMap(this.meta);
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.level.writeTo(out);
        out.writeString(this.message);
        out.writeString(this.url);
        out.writeOptionalString(this.details);
        out.writeBoolean(this.resolveDuringRollingUpgrade);
        out.writeGenericMap(this.meta);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject().field("level", (Enum)this.level).field("message", this.message).field("url", this.url);
        if (this.details != null) {
            builder.field("details", this.details);
        }
        builder.field("resolve_during_rolling_upgrade", this.resolveDuringRollingUpgrade);
        if (this.meta != null) {
            builder.field("_meta", this.meta);
        }
        return builder.endObject();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeprecationIssue that = (DeprecationIssue)o;
        return Objects.equals((Object)this.level, (Object)that.level) && Objects.equals(this.message, that.message) && Objects.equals(this.url, that.url) && Objects.equals(this.details, that.details) && Objects.equals(this.resolveDuringRollingUpgrade, that.resolveDuringRollingUpgrade) && Objects.equals(this.meta, that.meta);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.level, this.message, this.url, this.details, this.resolveDuringRollingUpgrade, this.meta});
    }

    public String toString() {
        return Strings.toString((ToXContent)this);
    }

    public static Map<String, Object> createMetaMapForRemovableSettings(List<String> removableSettings) {
        return Meta.fromRemovableSettings(removableSettings).toMetaMap();
    }

    public static DeprecationIssue getIntersectionOfRemovableSettings(List<DeprecationIssue> similarIssues) {
        if (similarIssues == null || similarIssues.isEmpty()) {
            return null;
        }
        if (similarIssues.size() == 1) {
            return similarIssues.get(0);
        }
        DeprecationIssue representativeIssue = similarIssues.get(0);
        Optional metaIntersection = similarIssues.stream().map(DeprecationIssue::getMetaObject).reduce(representativeIssue.getMetaObject(), (intersectionSoFar, meta) -> intersectionSoFar.isPresent() && meta.isPresent() ? Optional.of(((Meta)intersectionSoFar.get()).getIntersection((Meta)meta.get())) : Optional.empty());
        return new DeprecationIssue(representativeIssue.level, representativeIssue.message, representativeIssue.url, representativeIssue.details, representativeIssue.resolveDuringRollingUpgrade, metaIntersection.map(Meta::toMetaMap).orElse(null));
    }

    public static enum Level implements Writeable
    {
        WARNING,
        CRITICAL;


        public static Level fromString(String value) {
            return Level.valueOf(value.toUpperCase(Locale.ROOT));
        }

        public static Level readFromStream(StreamInput in) throws IOException {
            int ordinal = in.readVInt();
            if (ordinal < 0 || ordinal >= Level.values().length) {
                throw new IOException("Unknown Level ordinal [" + ordinal + "]");
            }
            return Level.values()[ordinal];
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeVInt(this.ordinal());
        }

        public String toString() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }

    private static final class Meta {
        private final List<Action> actions;
        private final Map<String, Object> nonActionMetadata;

        Meta(List<Action> actions, Map<String, Object> nonActionMetadata) {
            this.actions = actions;
            this.nonActionMetadata = nonActionMetadata;
        }

        private static Meta fromRemovableSettings(List<String> removableSettings) {
            List<Action> actions = removableSettings == null ? null : Collections.singletonList(new RemovalAction(removableSettings));
            return new Meta(actions, Collections.emptyMap());
        }

        private Map<String, Object> toMetaMap() {
            Map<String, Object> metaMap;
            if (this.actions != null) {
                metaMap = new HashMap<String, Object>(this.nonActionMetadata);
                List actionsList = this.actions.stream().map(Action::toActionMap).collect(Collectors.toList());
                if (!actionsList.isEmpty()) {
                    metaMap.put(DeprecationIssue.ACTIONS_META_FIELD, actionsList);
                }
            } else {
                metaMap = this.nonActionMetadata;
            }
            return metaMap;
        }

        private Meta getIntersection(Meta another) {
            List actionsIntersection;
            if (this.actions != null && another.actions != null) {
                Optional<List<String>> removableSettingsOptional;
                List<String> removableSettings;
                List combinedActions = this.actions.stream().filter(action -> !(action instanceof RemovalAction)).collect(Collectors.toList());
                Optional<Action> thisRemovalAction = this.actions.stream().filter(action -> action instanceof RemovalAction).findFirst();
                Optional<Action> otherRemovalAction = another.actions.stream().filter(action -> action instanceof RemovalAction).findFirst();
                if (thisRemovalAction.isPresent() && otherRemovalAction.isPresent() && !(removableSettings = (removableSettingsOptional = ((RemovalAction)thisRemovalAction.get()).getRemovableSettings()).map(settings -> settings.stream().distinct().filter(setting -> ((RemovalAction)otherRemovalAction.get()).getRemovableSettings().map(list -> list.contains(setting)).orElse(false)).collect(Collectors.toList())).orElse(Collections.emptyList())).isEmpty()) {
                    combinedActions.add(new RemovalAction(removableSettings));
                }
                actionsIntersection = combinedActions;
            } else {
                actionsIntersection = null;
            }
            return new Meta(actionsIntersection, this.nonActionMetadata);
        }

        private static Optional<Meta> fromMetaMap(Map<String, Object> metaMap) {
            ArrayList<Action> actions;
            if (metaMap == null) {
                return Optional.empty();
            }
            List actionMaps = (List)metaMap.get(DeprecationIssue.ACTIONS_META_FIELD);
            if (actionMaps == null) {
                actions = null;
            } else {
                actions = new ArrayList<Action>();
                for (Map actionMap : actionMaps) {
                    Action action = DeprecationIssue.REMOVE_SETTINGS_ACTION_TYPE.equals(actionMap.get(DeprecationIssue.ACTION_TYPE)) ? RemovalAction.fromActionMap(actionMap) : UnknownAction.fromActionMap(actionMap);
                    actions.add(action);
                }
            }
            Map<String, Object> nonActionMap = metaMap.entrySet().stream().filter(entry -> !((String)entry.getKey()).equals(DeprecationIssue.ACTIONS_META_FIELD)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            Meta meta = new Meta(actions, nonActionMap);
            return Optional.of(meta);
        }
    }

    private static class UnknownAction
    implements Action {
        private final Map<String, Object> actionMap;

        private UnknownAction(Map<String, Object> actionMap) {
            this.actionMap = actionMap;
        }

        private static Action fromActionMap(Map<String, Object> actionMap) {
            return new UnknownAction(actionMap);
        }

        @Override
        public Map<String, Object> toActionMap() {
            return this.actionMap;
        }
    }

    private static final class RemovalAction
    implements Action {
        private final List<String> removableSettings;

        RemovalAction(List<String> removableSettings) {
            this.removableSettings = removableSettings;
        }

        private static RemovalAction fromActionMap(Map<String, Object> actionMap) {
            Object removableSettingsObject = actionMap.get(DeprecationIssue.OBJECTS_FIELD);
            List removableSettings = removableSettingsObject == null ? null : (List)removableSettingsObject;
            return new RemovalAction(removableSettings);
        }

        private Optional<List<String>> getRemovableSettings() {
            return this.removableSettings == null ? Optional.empty() : Optional.of(this.removableSettings);
        }

        @Override
        public Map<String, Object> toActionMap() {
            HashMap<String, Object> actionMap;
            if (this.removableSettings != null) {
                actionMap = new HashMap<String, Object>();
                actionMap.put(DeprecationIssue.OBJECTS_FIELD, this.removableSettings);
                actionMap.put(DeprecationIssue.ACTION_TYPE, DeprecationIssue.REMOVE_SETTINGS_ACTION_TYPE);
            } else {
                actionMap = null;
            }
            return actionMap;
        }
    }

    private static interface Action {
        public Map<String, Object> toActionMap();
    }
}

