/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.async;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.tasks.TaskManager;
import org.elasticsearch.xpack.core.async.AsyncExecutionId;
import org.elasticsearch.xpack.core.async.AsyncTask;

public abstract class StoredAsyncTask<Response extends ActionResponse>
extends CancellableTask
implements AsyncTask {
    private final AsyncExecutionId asyncExecutionId;
    private final Map<String, String> originHeaders;
    private volatile long expirationTimeMillis;
    private final List<ActionListener<Response>> completionListeners;

    public StoredAsyncTask(long id, String type, String action, String description, TaskId parentTaskId, Map<String, String> headers, Map<String, String> originHeaders, AsyncExecutionId asyncExecutionId, TimeValue keepAlive) {
        super(id, type, action, description, parentTaskId, headers);
        this.asyncExecutionId = asyncExecutionId;
        this.originHeaders = originHeaders;
        this.expirationTimeMillis = this.getStartTime() + keepAlive.getMillis();
        this.completionListeners = new ArrayList<ActionListener<Response>>();
    }

    @Override
    public Map<String, String> getOriginHeaders() {
        return this.originHeaders;
    }

    @Override
    public AsyncExecutionId getExecutionId() {
        return this.asyncExecutionId;
    }

    @Override
    public void setExpirationTime(long expirationTime) {
        this.expirationTimeMillis = expirationTime;
    }

    public long getExpirationTimeMillis() {
        return this.expirationTimeMillis;
    }

    public synchronized void addCompletionListener(ActionListener<Response> listener) {
        this.completionListeners.add(listener);
    }

    public synchronized void removeCompletionListener(ActionListener<Response> listener) {
        this.completionListeners.remove(listener);
    }

    public synchronized void onResponse(Response response) {
        for (ActionListener<Response> listener : this.completionListeners) {
            listener.onResponse(response);
        }
    }

    public synchronized void onFailure(Exception e) {
        for (ActionListener<Response> listener : this.completionListeners) {
            listener.onFailure(e);
        }
    }

    public abstract Response getCurrentResult();

    @Override
    public void cancelTask(TaskManager taskManager, Runnable runnable, String reason) {
        taskManager.cancelTaskAndDescendants((CancellableTask)this, reason, true, ActionListener.running((Runnable)runnable));
    }
}

