/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.action;

import java.util.Collection;
import java.util.LongSummaryStatistics;
import java.util.stream.Collectors;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.rollover.RolloverConfiguration;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.DataStreamLifecycle;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.protocol.xpack.XPackUsageRequest;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.action.XPackUsageFeatureAction;
import org.elasticsearch.xpack.core.action.XPackUsageFeatureResponse;
import org.elasticsearch.xpack.core.action.XPackUsageFeatureTransportAction;
import org.elasticsearch.xpack.core.datastreams.DataStreamLifecycleFeatureSetUsage;

public class DataStreamLifecycleUsageTransportAction
extends XPackUsageFeatureTransportAction {
    @Inject
    public DataStreamLifecycleUsageTransportAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super(XPackUsageFeatureAction.DATA_STREAM_LIFECYCLE.name(), transportService, clusterService, threadPool, actionFilters, indexNameExpressionResolver);
    }

    protected void masterOperation(Task task, XPackUsageRequest request, ClusterState state, ActionListener<XPackUsageFeatureResponse> listener) {
        if (!DataStreamLifecycle.isFeatureEnabled()) {
            listener.onResponse((Object)new XPackUsageFeatureResponse(DataStreamLifecycleFeatureSetUsage.DISABLED));
            return;
        }
        Collection dataStreams = state.metadata().dataStreams().values();
        LongSummaryStatistics retentionStats = dataStreams.stream().filter(ds -> ds.getLifecycle() != null && ds.getLifecycle().isEnabled()).filter(ds -> ds.getLifecycle().getEffectiveDataRetention() != null).collect(Collectors.summarizingLong(ds -> ds.getLifecycle().getEffectiveDataRetention().getMillis()));
        long dataStreamsWithLifecycles = retentionStats.getCount();
        long minRetention = dataStreamsWithLifecycles == 0L ? 0L : retentionStats.getMin();
        long maxRetention = dataStreamsWithLifecycles == 0L ? 0L : retentionStats.getMax();
        double averageRetention = retentionStats.getAverage();
        RolloverConfiguration rolloverConfiguration = (RolloverConfiguration)this.clusterService.getClusterSettings().get(DataStreamLifecycle.CLUSTER_LIFECYCLE_DEFAULT_ROLLOVER_SETTING);
        String rolloverConfigString = rolloverConfiguration.toString();
        DataStreamLifecycleFeatureSetUsage.LifecycleStats stats = new DataStreamLifecycleFeatureSetUsage.LifecycleStats(dataStreamsWithLifecycles, minRetention, maxRetention, averageRetention, ((RolloverConfiguration)DataStreamLifecycle.CLUSTER_LIFECYCLE_DEFAULT_ROLLOVER_SETTING.getDefault(null)).toString().equals(rolloverConfigString));
        DataStreamLifecycleFeatureSetUsage usage = new DataStreamLifecycleFeatureSetUsage(stats);
        listener.onResponse((Object)new XPackUsageFeatureResponse(usage));
    }
}

