/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.license;

import java.io.IOException;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.AbstractNamedDiffable;
import org.elasticsearch.cluster.NamedDiff;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.license.License;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentParser;

public class LicensesMetadata
extends AbstractNamedDiffable<Metadata.Custom>
implements Metadata.Custom {
    public static final String TYPE = "licenses";
    public static final License LICENSE_TOMBSTONE = License.builder().type(License.LicenseType.TRIAL).issuer("elasticsearch").uid("TOMBSTONE").issuedTo("").maxNodes(0).issueDate(0L).expiryDate(0L).build();
    private final License license;
    @Nullable
    private Version trialVersion;

    public LicensesMetadata(License license, Version trialVersion) {
        this.license = license;
        this.trialVersion = trialVersion;
    }

    public License getLicense() {
        return this.license;
    }

    boolean isEligibleForTrial() {
        if (this.trialVersion == null) {
            return true;
        }
        return Version.CURRENT.major > this.trialVersion.major;
    }

    Version getMostRecentTrialVersion() {
        return this.trialVersion;
    }

    public String toString() {
        return "LicensesMetadata{license=" + this.license + ", trialVersion=" + this.trialVersion + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        LicensesMetadata that = (LicensesMetadata)((Object)o);
        return Objects.equals(this.license, that.license) && Objects.equals(this.trialVersion, that.trialVersion);
    }

    public int hashCode() {
        int result = this.license != null ? this.license.hashCode() : 0;
        result = 31 * result + (this.trialVersion != null ? this.trialVersion.hashCode() : 0);
        return result;
    }

    public String getWriteableName() {
        return TYPE;
    }

    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersion.MINIMUM_COMPATIBLE;
    }

    public EnumSet<Metadata.XContentContext> context() {
        return EnumSet.of(Metadata.XContentContext.GATEWAY);
    }

    public static LicensesMetadata fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token;
        License license = LICENSE_TOMBSTONE;
        Version trialLicense = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            String fieldName;
            if (token != XContentParser.Token.FIELD_NAME || (fieldName = parser.currentName()) == null) continue;
            if (fieldName.equals("license")) {
                token = parser.nextToken();
                if (token == XContentParser.Token.START_OBJECT) {
                    license = License.fromXContent(parser);
                    continue;
                }
                if (token != XContentParser.Token.VALUE_NULL) continue;
                license = LICENSE_TOMBSTONE;
                continue;
            }
            if (!fieldName.equals("trial_license")) continue;
            parser.nextToken();
            trialLicense = Version.fromString((String)parser.text());
        }
        return new LicensesMetadata(license, trialLicense);
    }

    public Iterator<? extends ToXContent> toXContentChunked(ToXContent.Params ignored) {
        return Iterators.single((builder, params) -> {
            if (this.license == LICENSE_TOMBSTONE) {
                builder.nullField("license");
            } else {
                builder.startObject("license");
                this.license.toInnerXContent(builder, params);
                builder.endObject();
            }
            if (this.trialVersion != null) {
                builder.field("trial_license", this.trialVersion.toString());
            }
            return builder;
        });
    }

    public void writeTo(StreamOutput streamOutput) throws IOException {
        if (this.license == LICENSE_TOMBSTONE) {
            streamOutput.writeBoolean(false);
        } else {
            streamOutput.writeBoolean(true);
            this.license.writeTo(streamOutput);
        }
        if (this.trialVersion == null) {
            streamOutput.writeBoolean(false);
        } else {
            streamOutput.writeBoolean(true);
            Version.writeVersion((Version)this.trialVersion, (StreamOutput)streamOutput);
        }
    }

    public LicensesMetadata(StreamInput streamInput) throws IOException {
        this.license = streamInput.readBoolean() ? License.readLicense(streamInput) : LICENSE_TOMBSTONE;
        boolean hasExercisedTrial = streamInput.readBoolean();
        if (hasExercisedTrial) {
            this.trialVersion = Version.readVersion((StreamInput)streamInput);
        }
    }

    public static NamedDiff<Metadata.Custom> readDiffFrom(StreamInput streamInput) throws IOException {
        return LicensesMetadata.readDiffFrom(Metadata.Custom.class, (String)TYPE, (StreamInput)streamInput);
    }

    public static License extractLicense(LicensesMetadata licensesMetadata) {
        if (licensesMetadata != null) {
            License license = licensesMetadata.getLicense();
            if (license == LICENSE_TOMBSTONE) {
                return null;
            }
            return license;
        }
        return null;
    }

    private static final class Fields {
        private static final String LICENSE = "license";
        private static final String TRIAL_LICENSE = "trial_license";

        private Fields() {
        }
    }
}

