/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ccr.action.repositories;

import java.io.IOException;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.transport.RemoteClusterAwareRequest;
import org.elasticsearch.xpack.ccr.Ccr;

public class GetCcrRestoreFileChunkRequest
extends ActionRequest
implements RemoteClusterAwareRequest,
IndicesRequest {
    private final DiscoveryNode node;
    private final String sessionUUID;
    private final String fileName;
    private final int size;
    private final ShardId shardId;

    public ActionRequestValidationException validate() {
        return null;
    }

    public GetCcrRestoreFileChunkRequest(DiscoveryNode node, String sessionUUID, String fileName, int size, ShardId shardId) {
        this.node = node;
        this.sessionUUID = sessionUUID;
        this.fileName = fileName;
        this.size = size;
        assert (size > -1) : "The file chunk request size must be positive. Found: [" + size + "].";
        this.shardId = shardId;
    }

    GetCcrRestoreFileChunkRequest(StreamInput in) throws IOException {
        super(in);
        this.node = null;
        this.sessionUUID = in.readString();
        this.fileName = in.readString();
        this.size = in.readVInt();
        this.shardId = in.getTransportVersion().onOrAfter((VersionId)Ccr.TRANSPORT_VERSION_ACTION_WITH_SHARD_ID) ? new ShardId(in) : null;
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.sessionUUID);
        out.writeString(this.fileName);
        out.writeVInt(this.size);
        if (out.getTransportVersion().onOrAfter((VersionId)Ccr.TRANSPORT_VERSION_ACTION_WITH_SHARD_ID)) {
            this.shardId.writeTo(out);
        }
    }

    String getSessionUUID() {
        return this.sessionUUID;
    }

    String getFileName() {
        return this.fileName;
    }

    int getSize() {
        return this.size;
    }

    ShardId getShardId() {
        return this.shardId;
    }

    public DiscoveryNode getPreferredTargetNode() {
        assert (this.node != null) : "Target node is null";
        return this.node;
    }

    public String[] indices() {
        if (this.shardId == null) {
            return null;
        }
        return new String[]{this.shardId.getIndexName()};
    }

    public IndicesOptions indicesOptions() {
        return IndicesOptions.strictSingleIndexNoExpandForbidClosed();
    }
}

