/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ccr.action;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.admin.cluster.state.ClusterStateRequest;
import org.elasticsearch.action.admin.cluster.state.ClusterStateResponse;
import org.elasticsearch.action.support.GroupedActionListener;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.metadata.IndexAbstraction;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.component.Lifecycle;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.common.util.concurrent.AtomicArray;
import org.elasticsearch.common.util.concurrent.CountDown;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.license.LicenseUtils;
import org.elasticsearch.transport.NoSuchRemoteClusterException;
import org.elasticsearch.xpack.ccr.CcrLicenseChecker;
import org.elasticsearch.xpack.ccr.CcrSettings;
import org.elasticsearch.xpack.core.ccr.AutoFollowMetadata;
import org.elasticsearch.xpack.core.ccr.AutoFollowStats;
import org.elasticsearch.xpack.core.ccr.action.PutFollowAction;

public class AutoFollowCoordinator
extends AbstractLifecycleComponent
implements ClusterStateListener {
    public static final String AUTO_FOLLOW_PATTERN_REPLACEMENT = "{{leader_index}}";
    private static final Logger LOGGER = LogManager.getLogger(AutoFollowCoordinator.class);
    private static final int MAX_AUTO_FOLLOW_ERRORS = 256;
    private static final Pattern DS_BACKING_PATTERN = Pattern.compile("^(.*?.ds-)(.+)-(\\d{4}.\\d{2}.\\d{2})(-[\\d]+)?$");
    private final Client client;
    private final ClusterService clusterService;
    private final CcrLicenseChecker ccrLicenseChecker;
    private final LongSupplier relativeMillisTimeProvider;
    private final LongSupplier absoluteMillisTimeProvider;
    private final Executor executor;
    private volatile TimeValue waitForMetadataTimeOut;
    private volatile Map<String, AutoFollower> autoFollowers = Collections.emptyMap();
    private volatile Set<String> patterns = Set.of();
    private long numberOfSuccessfulIndicesAutoFollowed = 0L;
    private long numberOfFailedIndicesAutoFollowed = 0L;
    private long numberOfFailedRemoteClusterStateRequests = 0L;
    private final LinkedHashMap<AutoFollowErrorKey, Tuple<Long, ElasticsearchException>> recentAutoFollowErrors;

    public AutoFollowCoordinator(Settings settings, Client client, ClusterService clusterService, CcrLicenseChecker ccrLicenseChecker, LongSupplier relativeMillisTimeProvider, LongSupplier absoluteMillisTimeProvider, Executor executor) {
        this.client = client;
        this.clusterService = clusterService;
        this.ccrLicenseChecker = Objects.requireNonNull(ccrLicenseChecker, "ccrLicenseChecker");
        this.relativeMillisTimeProvider = relativeMillisTimeProvider;
        this.absoluteMillisTimeProvider = absoluteMillisTimeProvider;
        this.executor = Objects.requireNonNull(executor);
        this.recentAutoFollowErrors = new LinkedHashMap<AutoFollowErrorKey, Tuple<Long, ElasticsearchException>>(){

            @Override
            protected boolean removeEldestEntry(Map.Entry<AutoFollowErrorKey, Tuple<Long, ElasticsearchException>> eldest) {
                return this.size() > 256;
            }
        };
        Consumer<TimeValue> updater = newWaitForTimeOut -> {
            if (!newWaitForTimeOut.equals((Object)this.waitForMetadataTimeOut)) {
                LOGGER.info("changing wait_for_metadata_timeout from [{}] to [{}]", (Object)this.waitForMetadataTimeOut, newWaitForTimeOut);
                this.waitForMetadataTimeOut = newWaitForTimeOut;
            }
        };
        clusterService.getClusterSettings().addSettingsUpdateConsumer(CcrSettings.CCR_WAIT_FOR_METADATA_TIMEOUT, updater);
        this.waitForMetadataTimeOut = (TimeValue)CcrSettings.CCR_WAIT_FOR_METADATA_TIMEOUT.get(settings);
    }

    protected void doStart() {
        this.clusterService.addListener((ClusterStateListener)this);
    }

    protected void doStop() {
        this.clusterService.removeListener((ClusterStateListener)this);
        LOGGER.trace("stopping all auto-followers");
        this.autoFollowers.values().forEach(AutoFollower::stop);
    }

    protected void doClose() {
    }

    public synchronized AutoFollowStats getStats() {
        Map<String, AutoFollower> autoFollowersCopy = this.autoFollowers;
        TreeMap<String, AutoFollowStats.AutoFollowedCluster> timesSinceLastAutoFollowPerRemoteCluster = new TreeMap<String, AutoFollowStats.AutoFollowedCluster>();
        for (Map.Entry<String, AutoFollower> entry : autoFollowersCopy.entrySet()) {
            long lastAutoFollowTimeInMillis = entry.getValue().lastAutoFollowTimeInMillis;
            long lastSeenMetadataVersion = entry.getValue().metadataVersion;
            if (lastAutoFollowTimeInMillis != -1L) {
                long timeSinceLastCheckInMillis = this.relativeMillisTimeProvider.getAsLong() - lastAutoFollowTimeInMillis;
                timesSinceLastAutoFollowPerRemoteCluster.put(entry.getKey(), new AutoFollowStats.AutoFollowedCluster(timeSinceLastCheckInMillis, lastSeenMetadataVersion));
                continue;
            }
            timesSinceLastAutoFollowPerRemoteCluster.put(entry.getKey(), new AutoFollowStats.AutoFollowedCluster(-1L, lastSeenMetadataVersion));
        }
        TreeMap<String, Tuple<Long, ElasticsearchException>> recentAutoFollowErrorsCopy = new TreeMap<String, Tuple<Long, ElasticsearchException>>();
        for (Map.Entry<AutoFollowErrorKey, Tuple<Long, ElasticsearchException>> entry : this.recentAutoFollowErrors.entrySet()) {
            recentAutoFollowErrorsCopy.put(entry.getKey().toString(), entry.getValue());
        }
        return new AutoFollowStats(this.numberOfFailedIndicesAutoFollowed, this.numberOfFailedRemoteClusterStateRequests, this.numberOfSuccessfulIndicesAutoFollowed, recentAutoFollowErrorsCopy, timesSinceLastAutoFollowPerRemoteCluster);
    }

    synchronized void updateStats(List<AutoFollowResult> results) {
        Set<String> currentPatterns = this.patterns;
        this.recentAutoFollowErrors.keySet().removeIf(key -> !currentPatterns.contains(key.pattern));
        long newStatsReceivedTimeStamp = this.absoluteMillisTimeProvider.getAsLong();
        for (AutoFollowResult result : results) {
            AutoFollowErrorKey onlyPatternKey = new AutoFollowErrorKey(result.autoFollowPatternName, null);
            if (result.clusterStateFetchException != null) {
                this.recentAutoFollowErrors.put(onlyPatternKey, (Tuple<Long, ElasticsearchException>)Tuple.tuple((Object)newStatsReceivedTimeStamp, (Object)new ElasticsearchException((Throwable)result.clusterStateFetchException)));
                ++this.numberOfFailedRemoteClusterStateRequests;
                LOGGER.warn(() -> Strings.format((String)"failure occurred while fetching cluster state for auto follow pattern [%s]", (Object[])new Object[]{result.autoFollowPatternName}), (Throwable)result.clusterStateFetchException);
                continue;
            }
            this.recentAutoFollowErrors.remove(onlyPatternKey);
            for (Map.Entry<Index, Exception> entry : result.autoFollowExecutionResults.entrySet()) {
                AutoFollowErrorKey patternAndIndexKey = new AutoFollowErrorKey(result.autoFollowPatternName, entry.getKey().getName());
                if (entry.getValue() != null) {
                    ++this.numberOfFailedIndicesAutoFollowed;
                    this.recentAutoFollowErrors.put(patternAndIndexKey, (Tuple<Long, ElasticsearchException>)Tuple.tuple((Object)newStatsReceivedTimeStamp, (Object)ExceptionsHelper.convertToElastic((Exception)entry.getValue())));
                    LOGGER.warn(() -> Strings.format((String)"failure occurred while auto following index [%s] for auto follow pattern [%s]", (Object[])new Object[]{entry.getKey(), result.autoFollowPatternName}), (Throwable)entry.getValue());
                    continue;
                }
                ++this.numberOfSuccessfulIndicesAutoFollowed;
                this.recentAutoFollowErrors.remove(patternAndIndexKey);
            }
        }
    }

    void updateAutoFollowers(ClusterState followerClusterState) {
        AutoFollowMetadata autoFollowMetadata = (AutoFollowMetadata)followerClusterState.getMetadata().custom("ccr_auto_follow", (Metadata.Custom)AutoFollowMetadata.EMPTY);
        if (autoFollowMetadata.getPatterns().isEmpty() && this.autoFollowers.isEmpty()) {
            return;
        }
        if (!this.ccrLicenseChecker.isCcrAllowed()) {
            LOGGER.warn("skipping auto-follower coordination", (Throwable)LicenseUtils.newComplianceException((String)"ccr"));
            return;
        }
        this.patterns = Set.copyOf(autoFollowMetadata.getPatterns().keySet());
        Map<String, AutoFollower> currentAutoFollowers = Map.copyOf(this.autoFollowers);
        Set newRemoteClusters = autoFollowMetadata.getPatterns().values().stream().filter(AutoFollowMetadata.AutoFollowPattern::isActive).map(AutoFollowMetadata.AutoFollowPattern::getRemoteCluster).filter(remoteCluster -> !currentAutoFollowers.containsKey(remoteCluster)).collect(Collectors.toSet());
        Map newAutoFollowers = Maps.newMapWithExpectedSize((int)newRemoteClusters.size());
        for (Object remoteCluster2 : newRemoteClusters) {
            AutoFollower autoFollower = new AutoFollower((String)remoteCluster2, this::updateStats, () -> ((ClusterService)this.clusterService).state(), this.relativeMillisTimeProvider, this.executor){

                @Override
                void getRemoteClusterState(String remoteCluster, long metadataVersion, BiConsumer<ClusterStateResponse, Exception> handler) {
                    CcrLicenseChecker.checkRemoteClusterLicenseAndFetchClusterState(AutoFollowCoordinator.this.client, remoteCluster, new ClusterStateRequest().clear().metadata(true).routingTable(true).waitForMetadataVersion(metadataVersion).waitForTimeout(AutoFollowCoordinator.this.waitForMetadataTimeOut), e -> handler.accept((ClusterStateResponse)null, (Exception)e), remoteClusterStateResponse -> handler.accept((ClusterStateResponse)remoteClusterStateResponse, (Exception)null));
                }

                @Override
                void createAndFollow(Map<String, String> headers, PutFollowAction.Request request, Runnable successHandler, Consumer<Exception> failureHandler) {
                    Client followerClient = CcrLicenseChecker.wrapClient(AutoFollowCoordinator.this.client, headers, AutoFollowCoordinator.this.clusterService.state());
                    followerClient.execute((ActionType)PutFollowAction.INSTANCE, (ActionRequest)request, ActionListener.wrap(r -> successHandler.run(), failureHandler));
                }

                @Override
                void updateAutoFollowMetadata(final Function<ClusterState, ClusterState> updateFunction, final Consumer<Exception> handler) {
                    AutoFollowCoordinator.this.submitUnbatchedTask("update_auto_follow_metadata", new ClusterStateUpdateTask(){

                        public ClusterState execute(ClusterState currentState) throws Exception {
                            return (ClusterState)updateFunction.apply(currentState);
                        }

                        public void onFailure(Exception e) {
                            handler.accept(e);
                        }

                        public void clusterStateProcessed(ClusterState oldState, ClusterState newState) {
                            handler.accept(null);
                        }
                    });
                }
            };
            newAutoFollowers.put(remoteCluster2, autoFollower);
            LOGGER.info("starting auto-follower for remote cluster [{}]", remoteCluster2);
            if (this.lifecycleState() != Lifecycle.State.STARTED) continue;
            autoFollower.start();
        }
        ArrayList<String> removedRemoteClusters = new ArrayList<String>();
        for (Map.Entry entry : currentAutoFollowers.entrySet()) {
            String remoteCluster3 = (String)entry.getKey();
            AutoFollower autoFollower = (AutoFollower)entry.getValue();
            boolean exist = autoFollowMetadata.getPatterns().values().stream().filter(AutoFollowMetadata.AutoFollowPattern::isActive).anyMatch(pattern -> pattern.getRemoteCluster().equals(remoteCluster3));
            if (!exist) {
                LOGGER.info("removing auto-follower for remote cluster [{}]", (Object)remoteCluster3);
                autoFollower.removed = true;
                removedRemoteClusters.add(remoteCluster3);
                continue;
            }
            if (!autoFollower.remoteClusterConnectionMissing) continue;
            LOGGER.info("retrying auto-follower for remote cluster [{}] after remote cluster connection was missing", (Object)remoteCluster3);
            autoFollower.remoteClusterConnectionMissing = false;
            if (this.lifecycleState() != Lifecycle.State.STARTED) continue;
            autoFollower.start();
        }
        assert (this.assertNoOtherActiveAutoFollower(newAutoFollowers));
        HashMap<String, AutoFollower> updatedFollowers = new HashMap<String, AutoFollower>(currentAutoFollowers);
        updatedFollowers.putAll(newAutoFollowers);
        removedRemoteClusters.forEach(updatedFollowers.keySet()::remove);
        this.autoFollowers = Collections.unmodifiableMap(updatedFollowers);
    }

    @SuppressForbidden(reason="legacy usage of unbatched task")
    private void submitUnbatchedTask(String source, ClusterStateUpdateTask task) {
        this.clusterService.submitUnbatchedStateUpdateTask(source, task);
    }

    private boolean assertNoOtherActiveAutoFollower(Map<String, AutoFollower> newAutoFollowers) {
        for (AutoFollower newAutoFollower : newAutoFollowers.values()) {
            AutoFollower previousInstance = this.autoFollowers.get(newAutoFollower.remoteCluster);
            assert (previousInstance == null || previousInstance.removed);
        }
        return true;
    }

    Map<String, AutoFollower> getAutoFollowers() {
        return this.autoFollowers;
    }

    public void clusterChanged(ClusterChangedEvent event) {
        if (event.localNodeMaster()) {
            this.updateAutoFollowers(event.state());
        }
    }

    static abstract class AutoFollower {
        private final String remoteCluster;
        private final Consumer<List<AutoFollowResult>> statsUpdater;
        private final Supplier<ClusterState> followerClusterStateSupplier;
        private final LongSupplier relativeTimeProvider;
        private final Executor executor;
        private volatile long lastAutoFollowTimeInMillis = -1L;
        private volatile long metadataVersion = 0L;
        private volatile boolean remoteClusterConnectionMissing = false;
        volatile boolean removed = false;
        private volatile CountDown autoFollowPatternsCountDown;
        private volatile AtomicArray<AutoFollowResult> autoFollowResults;
        private volatile boolean stop;
        private volatile List<String> lastActivePatterns = List.of();

        AutoFollower(String remoteCluster, Consumer<List<AutoFollowResult>> statsUpdater, Supplier<ClusterState> followerClusterStateSupplier, LongSupplier relativeTimeProvider, Executor executor) {
            this.remoteCluster = remoteCluster;
            this.statsUpdater = statsUpdater;
            this.followerClusterStateSupplier = followerClusterStateSupplier;
            this.relativeTimeProvider = relativeTimeProvider;
            this.executor = Objects.requireNonNull(executor);
        }

        void start() {
            if (this.stop) {
                LOGGER.trace("auto-follower is stopped for remote cluster [{}]", (Object)this.remoteCluster);
                return;
            }
            if (this.removed) {
                LOGGER.trace("auto-follower instance for cluster [{}] has been removed", (Object)this.remoteCluster);
                return;
            }
            this.lastAutoFollowTimeInMillis = this.relativeTimeProvider.getAsLong();
            ClusterState clusterState = this.followerClusterStateSupplier.get();
            AutoFollowMetadata autoFollowMetadata = (AutoFollowMetadata)clusterState.metadata().custom("ccr_auto_follow");
            if (autoFollowMetadata == null) {
                LOGGER.info("auto-follower for cluster [{}] has stopped, because there is no autofollow metadata", (Object)this.remoteCluster);
                return;
            }
            List patterns = autoFollowMetadata.getPatterns().entrySet().stream().filter(entry -> ((AutoFollowMetadata.AutoFollowPattern)entry.getValue()).getRemoteCluster().equals(this.remoteCluster)).filter(entry -> ((AutoFollowMetadata.AutoFollowPattern)entry.getValue()).isActive()).map(Map.Entry::getKey).sorted().collect(Collectors.toList());
            if (patterns.isEmpty()) {
                LOGGER.info("auto-follower for cluster [{}] has stopped, because there are no more patterns", (Object)this.remoteCluster);
                return;
            }
            this.autoFollowPatternsCountDown = new CountDown(patterns.size());
            this.autoFollowResults = new AtomicArray(patterns.size());
            long nextMetadataVersion = Objects.equals(patterns, this.lastActivePatterns) ? this.metadataVersion + 1L : this.metadataVersion;
            this.lastActivePatterns = List.copyOf(patterns);
            Thread thread = Thread.currentThread();
            this.getRemoteClusterState(this.remoteCluster, Math.max(1L, nextMetadataVersion), (remoteClusterStateResponse, remoteError) -> {
                if (this.removed) {
                    LOGGER.trace("auto-follower instance for cluster [{}] has been removed", (Object)this.remoteCluster);
                    return;
                }
                if (remoteClusterStateResponse != null) {
                    assert (remoteError == null);
                    if (remoteClusterStateResponse.isWaitForTimedOut()) {
                        LOGGER.trace("auto-follow coordinator timed out getting remote cluster state from [{}]", (Object)this.remoteCluster);
                        this.start();
                        return;
                    }
                    ClusterState remoteClusterState = remoteClusterStateResponse.getState();
                    this.metadataVersion = remoteClusterState.metadata().version();
                    this.autoFollowIndices(autoFollowMetadata, clusterState, remoteClusterState, patterns, thread);
                } else {
                    assert (remoteError != null);
                    if (remoteError instanceof NoSuchRemoteClusterException) {
                        LOGGER.info("auto-follower for cluster [{}] has stopped, because remote connection is gone", (Object)this.remoteCluster);
                        this.remoteClusterConnectionMissing = true;
                        return;
                    }
                    for (int i = 0; i < patterns.size(); ++i) {
                        String autoFollowPatternName = (String)patterns.get(i);
                        this.finalise(i, new AutoFollowResult(autoFollowPatternName, (Exception)remoteError), thread);
                    }
                }
            });
        }

        void stop() {
            LOGGER.trace("stopping auto-follower for remote cluster [{}]", (Object)this.remoteCluster);
            this.stop = true;
        }

        private void autoFollowIndices(AutoFollowMetadata autoFollowMetadata, ClusterState clusterState, ClusterState remoteClusterState, List<String> patterns, Thread thread) {
            int i = 0;
            for (String autoFollowPatternName : patterns) {
                int slot = i;
                AutoFollowMetadata.AutoFollowPattern autoFollowPattern = (AutoFollowMetadata.AutoFollowPattern)autoFollowMetadata.getPatterns().get(autoFollowPatternName);
                Map headers = (Map)autoFollowMetadata.getHeaders().get(autoFollowPatternName);
                List followedIndices = (List)autoFollowMetadata.getFollowedLeaderIndexUUIDs().get(autoFollowPatternName);
                List<Index> leaderIndicesToFollow = AutoFollower.getLeaderIndicesToFollow(autoFollowPattern, remoteClusterState, followedIndices);
                if (leaderIndicesToFollow.isEmpty()) {
                    this.finalise(slot, new AutoFollowResult(autoFollowPatternName), thread);
                } else {
                    List<Tuple<String, AutoFollowMetadata.AutoFollowPattern>> patternsForTheSameRemoteCluster = autoFollowMetadata.getPatterns().entrySet().stream().filter(item -> !autoFollowPatternName.equals(item.getKey())).filter(item -> this.remoteCluster.equals(((AutoFollowMetadata.AutoFollowPattern)item.getValue()).getRemoteCluster())).map(item -> new Tuple((Object)((String)item.getKey()), (Object)((AutoFollowMetadata.AutoFollowPattern)item.getValue()))).collect(Collectors.toList());
                    Consumer<AutoFollowResult> resultHandler = result -> this.finalise(slot, (AutoFollowResult)result, thread);
                    this.checkAutoFollowPattern(autoFollowPatternName, this.remoteCluster, autoFollowPattern, leaderIndicesToFollow, headers, patternsForTheSameRemoteCluster, remoteClusterState.metadata(), clusterState.metadata(), resultHandler);
                }
                ++i;
            }
            this.cleanFollowedRemoteIndices(remoteClusterState, patterns);
        }

        private void checkAutoFollowPattern(String autoFollowPattenName, String remoteClusterString, AutoFollowMetadata.AutoFollowPattern autoFollowPattern, List<Index> leaderIndicesToFollow, Map<String, String> headers, List<Tuple<String, AutoFollowMetadata.AutoFollowPattern>> patternsForTheSameRemoteCluster, Metadata remoteMetadata, Metadata localMetadata, Consumer<AutoFollowResult> resultHandler) {
            GroupedActionListener groupedListener = new GroupedActionListener(leaderIndicesToFollow.size(), ActionListener.wrap(rs -> resultHandler.accept(new AutoFollowResult(autoFollowPattenName, new ArrayList<Tuple<Index, Exception>>((Collection<Tuple<Index, Exception>>)rs))), e -> {
                throw new AssertionError("must never happen", (Throwable)e);
            }));
            for (Index indexToFollow : leaderIndicesToFollow) {
                String message;
                IndexAbstraction indexAbstraction = (IndexAbstraction)remoteMetadata.getIndicesLookup().get(indexToFollow.getName());
                List<String> otherMatchingPatterns = patternsForTheSameRemoteCluster.stream().filter(otherPattern -> ((AutoFollowMetadata.AutoFollowPattern)otherPattern.v2()).match(indexAbstraction)).map(Tuple::v1).toList();
                if (otherMatchingPatterns.size() != 0) {
                    groupedListener.onResponse((Object)new Tuple((Object)indexToFollow, (Object)new ElasticsearchException("index to follow [" + indexToFollow.getName() + "] for pattern [" + autoFollowPattenName + "] matches with other patterns " + otherMatchingPatterns, new Object[0])));
                    continue;
                }
                IndexMetadata leaderIndexMetadata = remoteMetadata.getIndexSafe(indexToFollow);
                if (!((Boolean)IndexSettings.INDEX_SOFT_DELETES_SETTING.get(leaderIndexMetadata.getSettings())).booleanValue()) {
                    message = String.format(Locale.ROOT, "index [%s] cannot be followed, because soft deletes are not enabled", indexToFollow.getName());
                    LOGGER.warn(message);
                    this.updateAutoFollowMetadata(AutoFollower.recordLeaderIndexAsFollowFunction(autoFollowPattenName, indexToFollow), error -> {
                        ElasticsearchException failure = new ElasticsearchException(message, new Object[0]);
                        if (error != null) {
                            failure.addSuppressed((Throwable)error);
                        }
                        groupedListener.onResponse((Object)new Tuple((Object)indexToFollow, (Object)failure));
                    });
                    continue;
                }
                if (leaderIndexMetadata.isSearchableSnapshot()) {
                    message = String.format(Locale.ROOT, "index to follow [%s] is a searchable snapshot index and cannot be used for cross-cluster replication purpose", indexToFollow.getName());
                    LOGGER.debug(message);
                    this.updateAutoFollowMetadata(AutoFollower.recordLeaderIndexAsFollowFunction(autoFollowPattenName, indexToFollow), error -> {
                        ElasticsearchException failure = new ElasticsearchException(message, new Object[0]);
                        if (error != null) {
                            failure.addSuppressed((Throwable)error);
                        }
                        groupedListener.onResponse((Object)new Tuple((Object)indexToFollow, (Object)failure));
                    });
                    continue;
                }
                if (AutoFollower.leaderIndexAlreadyFollowed(autoFollowPattern, indexToFollow, localMetadata)) {
                    this.updateAutoFollowMetadata(AutoFollower.recordLeaderIndexAsFollowFunction(autoFollowPattenName, indexToFollow), error -> groupedListener.onResponse((Object)new Tuple((Object)indexToFollow, error)));
                    continue;
                }
                this.followLeaderIndex(autoFollowPattenName, remoteClusterString, indexToFollow, indexAbstraction, autoFollowPattern, headers, error -> groupedListener.onResponse((Object)new Tuple((Object)indexToFollow, error)));
            }
        }

        private static boolean leaderIndexAlreadyFollowed(AutoFollowMetadata.AutoFollowPattern autoFollowPattern, Index leaderIndex, Metadata localMetadata) {
            Map customData;
            String followIndexName = AutoFollower.getFollowerIndexName(autoFollowPattern, leaderIndex.getName());
            IndexMetadata indexMetadata = localMetadata.index(followIndexName);
            if (indexMetadata != null && (customData = indexMetadata.getCustomData("ccr")) != null) {
                String recordedLeaderIndexUUID = (String)customData.get("leader_index_uuid");
                return leaderIndex.getUUID().equals(recordedLeaderIndexUUID);
            }
            return false;
        }

        static PutFollowAction.Request generateRequest(String remoteCluster, Index indexToFollow, IndexAbstraction indexAbstraction, AutoFollowMetadata.AutoFollowPattern pattern) {
            String leaderIndexName = indexToFollow.getName();
            String followIndexName = AutoFollower.getFollowerIndexName(pattern, leaderIndexName);
            PutFollowAction.Request request = new PutFollowAction.Request();
            request.setRemoteCluster(remoteCluster);
            request.setLeaderIndex(indexToFollow.getName());
            request.setFollowerIndex(followIndexName);
            request.setSettings(pattern.getSettings());
            if (pattern.getFollowIndexPattern() != null && indexAbstraction.getParentDataStream() != null) {
                String dataStreamName = indexAbstraction.getParentDataStream().getName();
                request.setDataStreamName(pattern.getFollowIndexPattern().replace(AutoFollowCoordinator.AUTO_FOLLOW_PATTERN_REPLACEMENT, dataStreamName));
            }
            request.getParameters().setMaxReadRequestOperationCount(pattern.getMaxReadRequestOperationCount());
            request.getParameters().setMaxReadRequestSize(pattern.getMaxReadRequestSize());
            request.getParameters().setMaxOutstandingReadRequests(pattern.getMaxOutstandingReadRequests());
            request.getParameters().setMaxWriteRequestOperationCount(pattern.getMaxWriteRequestOperationCount());
            request.getParameters().setMaxWriteRequestSize(pattern.getMaxWriteRequestSize());
            request.getParameters().setMaxOutstandingWriteRequests(pattern.getMaxOutstandingWriteRequests());
            request.getParameters().setMaxWriteBufferCount(pattern.getMaxWriteBufferCount());
            request.getParameters().setMaxWriteBufferSize(pattern.getMaxWriteBufferSize());
            request.getParameters().setMaxRetryDelay(pattern.getMaxRetryDelay());
            request.getParameters().setReadPollTimeout(pattern.getReadPollTimeout());
            request.masterNodeTimeout(TimeValue.MAX_VALUE);
            return request;
        }

        private void followLeaderIndex(String autoFollowPattenName, String remoteClusterString, Index indexToFollow, IndexAbstraction indexAbstraction, AutoFollowMetadata.AutoFollowPattern pattern, Map<String, String> headers, Consumer<Exception> onResult) {
            PutFollowAction.Request request = AutoFollower.generateRequest(remoteClusterString, indexToFollow, indexAbstraction, pattern);
            Runnable successHandler = () -> {
                LOGGER.info("auto followed leader index [{}] as follow index [{}]", (Object)indexToFollow, (Object)request.getFollowerIndex());
                Function<ClusterState, ClusterState> function = AutoFollower.recordLeaderIndexAsFollowFunction(autoFollowPattenName, indexToFollow);
                this.updateAutoFollowMetadata(function, onResult);
            };
            this.createAndFollow(headers, request, successHandler, onResult);
        }

        private void finalise(int slot, AutoFollowResult result, Thread thread) {
            assert (this.autoFollowResults.get(slot) == null);
            this.autoFollowResults.set(slot, (Object)result);
            if (this.autoFollowPatternsCountDown.countDown()) {
                this.statsUpdater.accept(this.autoFollowResults.asList());
                if (thread == Thread.currentThread()) {
                    this.executor.execute(this::start);
                    return;
                }
                this.start();
            }
        }

        static List<Index> getLeaderIndicesToFollow(AutoFollowMetadata.AutoFollowPattern autoFollowPattern, ClusterState remoteClusterState, List<String> followedIndexUUIDs) {
            ArrayList<Index> leaderIndicesToFollow = new ArrayList<Index>();
            for (IndexMetadata leaderIndexMetadata : remoteClusterState.getMetadata()) {
                IndexRoutingTable indexRoutingTable;
                if (leaderIndexMetadata.getState() != IndexMetadata.State.OPEN) continue;
                IndexAbstraction indexAbstraction = (IndexAbstraction)remoteClusterState.getMetadata().getIndicesLookup().get(leaderIndexMetadata.getIndex().getName());
                if (!autoFollowPattern.isActive() || !autoFollowPattern.match(indexAbstraction) || (indexRoutingTable = remoteClusterState.routingTable().index(leaderIndexMetadata.getIndex())) == null || !indexRoutingTable.allPrimaryShardsActive() || followedIndexUUIDs.contains(leaderIndexMetadata.getIndex().getUUID())) continue;
                leaderIndicesToFollow.add(leaderIndexMetadata.getIndex());
            }
            return leaderIndicesToFollow;
        }

        static String getFollowerIndexName(AutoFollowMetadata.AutoFollowPattern autoFollowPattern, String leaderIndexName) {
            String followPattern = autoFollowPattern.getFollowIndexPattern();
            if (followPattern != null) {
                if (leaderIndexName.contains(".ds-")) {
                    Matcher m = DS_BACKING_PATTERN.matcher(leaderIndexName);
                    if (m.find()) {
                        return m.group(1) + followPattern.replace(AutoFollowCoordinator.AUTO_FOLLOW_PATTERN_REPLACEMENT, m.group(2)) + "-" + m.group(3) + m.group(4);
                    }
                    throw new IllegalArgumentException("unable to determine follower index name from leader index name [" + leaderIndexName + "] and follow index pattern: [" + followPattern + "], index appears to follow a regular data stream backing pattern, but could not be parsed");
                }
                return followPattern.replace(AutoFollowCoordinator.AUTO_FOLLOW_PATTERN_REPLACEMENT, leaderIndexName);
            }
            return leaderIndexName;
        }

        static Function<ClusterState, ClusterState> recordLeaderIndexAsFollowFunction(String name, Index indexToFollow) {
            return currentState -> {
                AutoFollowMetadata currentAutoFollowMetadata = (AutoFollowMetadata)currentState.metadata().custom("ccr_auto_follow");
                HashMap<String, List> newFollowedIndexUUIDS = new HashMap<String, List>(currentAutoFollowMetadata.getFollowedLeaderIndexUUIDs());
                if (!newFollowedIndexUUIDS.containsKey(name)) {
                    return currentState;
                }
                newFollowedIndexUUIDS.compute(name, (key, existingUUIDs) -> {
                    assert (existingUUIDs != null);
                    ArrayList<String> newUUIDs = new ArrayList<String>((Collection<String>)existingUUIDs);
                    newUUIDs.add(indexToFollow.getUUID());
                    return Collections.unmodifiableList(newUUIDs);
                });
                AutoFollowMetadata newAutoFollowMetadata = new AutoFollowMetadata(currentAutoFollowMetadata.getPatterns(), newFollowedIndexUUIDS, currentAutoFollowMetadata.getHeaders());
                return ClusterState.builder((ClusterState)currentState).metadata(Metadata.builder((Metadata)currentState.getMetadata()).putCustom("ccr_auto_follow", (Metadata.Custom)newAutoFollowMetadata).build()).build();
            };
        }

        void cleanFollowedRemoteIndices(ClusterState remoteClusterState, List<String> patterns) {
            this.updateAutoFollowMetadata(AutoFollower.cleanFollowedRemoteIndices(remoteClusterState.metadata(), patterns), e -> {
                if (e != null) {
                    LOGGER.warn("Error occured while cleaning followed leader indices", (Throwable)e);
                }
            });
        }

        static Function<ClusterState, ClusterState> cleanFollowedRemoteIndices(Metadata remoteMetadata, List<String> autoFollowPatternNames) {
            return currentState -> {
                AutoFollowMetadata currentAutoFollowMetadata = (AutoFollowMetadata)currentState.metadata().custom("ccr_auto_follow");
                HashMap autoFollowPatternNameToFollowedIndexUUIDs = new HashMap(currentAutoFollowMetadata.getFollowedLeaderIndexUUIDs());
                Set remoteIndexUUIDS = remoteMetadata.getIndices().values().stream().map(IndexMetadata::getIndexUUID).collect(Collectors.toSet());
                boolean requiresCSUpdate = false;
                for (String autoFollowPatternName : autoFollowPatternNames) {
                    if (!autoFollowPatternNameToFollowedIndexUUIDs.containsKey(autoFollowPatternName)) continue;
                    ArrayList<String> followedIndexUUIDs = new ArrayList<String>((Collection)autoFollowPatternNameToFollowedIndexUUIDs.get(autoFollowPatternName));
                    boolean entriesRemoved = followedIndexUUIDs.removeIf(followedLeaderIndexUUID -> !remoteIndexUUIDS.contains(followedLeaderIndexUUID));
                    if (entriesRemoved) {
                        requiresCSUpdate = true;
                    }
                    autoFollowPatternNameToFollowedIndexUUIDs.put(autoFollowPatternName, followedIndexUUIDs);
                }
                if (requiresCSUpdate) {
                    AutoFollowMetadata newAutoFollowMetadata = new AutoFollowMetadata(currentAutoFollowMetadata.getPatterns(), autoFollowPatternNameToFollowedIndexUUIDs, currentAutoFollowMetadata.getHeaders());
                    return ClusterState.builder((ClusterState)currentState).metadata(Metadata.builder((Metadata)currentState.getMetadata()).putCustom("ccr_auto_follow", (Metadata.Custom)newAutoFollowMetadata).build()).build();
                }
                return currentState;
            };
        }

        abstract void getRemoteClusterState(String var1, long var2, BiConsumer<ClusterStateResponse, Exception> var4);

        abstract void createAndFollow(Map<String, String> var1, PutFollowAction.Request var2, Runnable var3, Consumer<Exception> var4);

        abstract void updateAutoFollowMetadata(Function<ClusterState, ClusterState> var1, Consumer<Exception> var2);
    }

    private record AutoFollowErrorKey(String pattern, String index) {
        private AutoFollowErrorKey(String pattern, String index) {
            this.pattern = Objects.requireNonNull(pattern);
            this.index = index;
        }

        @Override
        public String toString() {
            return this.index != null ? this.pattern + ":" + this.index : this.pattern;
        }
    }

    static class AutoFollowResult {
        final String autoFollowPatternName;
        final Exception clusterStateFetchException;
        final Map<Index, Exception> autoFollowExecutionResults;

        AutoFollowResult(String autoFollowPatternName, List<Tuple<Index, Exception>> results) {
            this.autoFollowPatternName = autoFollowPatternName;
            HashMap<Index, Exception> mutableAutoFollowExecutionResults = new HashMap<Index, Exception>();
            for (Tuple<Index, Exception> result : results) {
                mutableAutoFollowExecutionResults.put((Index)result.v1(), (Exception)result.v2());
            }
            this.clusterStateFetchException = null;
            this.autoFollowExecutionResults = Collections.unmodifiableMap(mutableAutoFollowExecutionResults);
        }

        AutoFollowResult(String autoFollowPatternName, Exception e) {
            this.autoFollowPatternName = autoFollowPatternName;
            this.clusterStateFetchException = e;
            this.autoFollowExecutionResults = Collections.emptyMap();
        }

        AutoFollowResult(String autoFollowPatternName) {
            this(autoFollowPatternName, (Exception)null);
        }
    }
}

