/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.autoscaling.storage;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.autoscaling.storage.NodeDecision;

class NodeDecisions
implements ToXContentObject,
Writeable {
    private final List<NodeDecision> canAllocateDecisions;
    @Nullable
    private final NodeDecision canRemainDecision;

    NodeDecisions(List<NodeDecision> canAllocateDecisions, @Nullable NodeDecision canRemainDecision) {
        this.canAllocateDecisions = canAllocateDecisions;
        this.canRemainDecision = canRemainDecision;
    }

    NodeDecisions(StreamInput in) throws IOException {
        this.canAllocateDecisions = in.readList(NodeDecision::new);
        this.canRemainDecision = (NodeDecision)in.readOptionalWriteable(NodeDecision::new);
    }

    List<NodeDecision> canAllocateDecisions() {
        return this.canAllocateDecisions;
    }

    @Nullable
    NodeDecision canRemainDecision() {
        return this.canRemainDecision;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeList(this.canAllocateDecisions);
        out.writeOptionalWriteable((Writeable)this.canRemainDecision);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.xContentList("can_allocate_decisions", this.canAllocateDecisions);
        if (this.canRemainDecision != null) {
            builder.field("can_remain_decision", (ToXContent)this.canRemainDecision);
        }
        builder.endObject();
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodeDecisions that = (NodeDecisions)o;
        return Objects.equals(this.canAllocateDecisions, that.canAllocateDecisions) && Objects.equals(this.canRemainDecision, that.canRemainDecision);
    }

    public int hashCode() {
        return Objects.hash(this.canAllocateDecisions, this.canRemainDecision);
    }
}

