/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.autoscaling;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.NamedDiff;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsFilter;
import org.elasticsearch.env.Environment;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.license.License;
import org.elasticsearch.license.LicensedFeature;
import org.elasticsearch.plugins.ActionPlugin;
import org.elasticsearch.plugins.ExtensiblePlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.repositories.RepositoriesService;
import org.elasticsearch.reservedstate.ReservedClusterStateHandler;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.tracing.Tracer;
import org.elasticsearch.watcher.ResourceWatcherService;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xpack.autoscaling.AutoscalingExtension;
import org.elasticsearch.xpack.autoscaling.AutoscalingLicenseChecker;
import org.elasticsearch.xpack.autoscaling.AutoscalingMetadata;
import org.elasticsearch.xpack.autoscaling.action.DeleteAutoscalingPolicyAction;
import org.elasticsearch.xpack.autoscaling.action.GetAutoscalingCapacityAction;
import org.elasticsearch.xpack.autoscaling.action.GetAutoscalingPolicyAction;
import org.elasticsearch.xpack.autoscaling.action.PutAutoscalingPolicyAction;
import org.elasticsearch.xpack.autoscaling.action.ReservedAutoscalingPolicyAction;
import org.elasticsearch.xpack.autoscaling.action.TransportDeleteAutoscalingPolicyAction;
import org.elasticsearch.xpack.autoscaling.action.TransportGetAutoscalingCapacityAction;
import org.elasticsearch.xpack.autoscaling.action.TransportGetAutoscalingPolicyAction;
import org.elasticsearch.xpack.autoscaling.action.TransportPutAutoscalingPolicyAction;
import org.elasticsearch.xpack.autoscaling.capacity.AutoscalingCalculateCapacityService;
import org.elasticsearch.xpack.autoscaling.capacity.AutoscalingDeciderResult;
import org.elasticsearch.xpack.autoscaling.capacity.AutoscalingDeciderService;
import org.elasticsearch.xpack.autoscaling.capacity.FixedAutoscalingDeciderService;
import org.elasticsearch.xpack.autoscaling.capacity.nodeinfo.AutoscalingNodeInfoService;
import org.elasticsearch.xpack.autoscaling.existence.FrozenExistenceDeciderService;
import org.elasticsearch.xpack.autoscaling.rest.RestDeleteAutoscalingPolicyHandler;
import org.elasticsearch.xpack.autoscaling.rest.RestGetAutoscalingCapacityHandler;
import org.elasticsearch.xpack.autoscaling.rest.RestGetAutoscalingPolicyHandler;
import org.elasticsearch.xpack.autoscaling.rest.RestPutAutoscalingPolicyHandler;
import org.elasticsearch.xpack.autoscaling.shards.FrozenShardsDeciderService;
import org.elasticsearch.xpack.autoscaling.storage.FrozenStorageDeciderService;
import org.elasticsearch.xpack.autoscaling.storage.ProactiveStorageDeciderService;
import org.elasticsearch.xpack.autoscaling.storage.ReactiveStorageDeciderService;

public class Autoscaling
extends Plugin
implements ActionPlugin,
ExtensiblePlugin,
AutoscalingExtension {
    static final LicensedFeature.Momentary AUTOSCALING_FEATURE;
    private final List<AutoscalingExtension> autoscalingExtensions;
    private final SetOnce<ClusterService> clusterServiceHolder = new SetOnce();
    private final SetOnce<AllocationService> allocationServiceHolder = new SetOnce();
    private final AutoscalingLicenseChecker autoscalingLicenseChecker;
    private final SetOnce<ReservedAutoscalingPolicyAction> reservedAutoscalingPolicyAction = new SetOnce();

    public Autoscaling() {
        this(new AutoscalingLicenseChecker());
    }

    Autoscaling(AutoscalingLicenseChecker autoscalingLicenseChecker) {
        this.autoscalingExtensions = new ArrayList<Autoscaling>(List.of(this));
        this.autoscalingLicenseChecker = Objects.requireNonNull(autoscalingLicenseChecker);
    }

    public Collection<Object> createComponents(Client client, ClusterService clusterService, ThreadPool threadPool, ResourceWatcherService resourceWatcherService, ScriptService scriptService, NamedXContentRegistry xContentRegistry, Environment environment, NodeEnvironment nodeEnvironment, NamedWriteableRegistry namedWriteableRegistry, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<RepositoriesService> repositoriesServiceSupplier, Tracer tracer, AllocationService allocationService, IndicesService indicesService) {
        this.clusterServiceHolder.set((Object)clusterService);
        this.allocationServiceHolder.set((Object)allocationService);
        AutoscalingCalculateCapacityService.Holder capacityServiceHolder = new AutoscalingCalculateCapacityService.Holder(this);
        this.reservedAutoscalingPolicyAction.set((Object)new ReservedAutoscalingPolicyAction(capacityServiceHolder));
        return List.of(capacityServiceHolder, this.autoscalingLicenseChecker, new AutoscalingNodeInfoService(clusterService, client));
    }

    public List<Setting<?>> getSettings() {
        return List.of(AutoscalingNodeInfoService.FETCH_TIMEOUT);
    }

    public List<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>> getActions() {
        return List.of(new ActionPlugin.ActionHandler((ActionType)GetAutoscalingCapacityAction.INSTANCE, TransportGetAutoscalingCapacityAction.class), new ActionPlugin.ActionHandler((ActionType)DeleteAutoscalingPolicyAction.INSTANCE, TransportDeleteAutoscalingPolicyAction.class), new ActionPlugin.ActionHandler((ActionType)GetAutoscalingPolicyAction.INSTANCE, TransportGetAutoscalingPolicyAction.class), new ActionPlugin.ActionHandler((ActionType)PutAutoscalingPolicyAction.INSTANCE, TransportPutAutoscalingPolicyAction.class));
    }

    public List<RestHandler> getRestHandlers(Settings settings, RestController controller, ClusterSettings clusterSettings, IndexScopedSettings indexScopedSettings, SettingsFilter settingsFilter, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<DiscoveryNodes> nodesInCluster) {
        return List.of(new RestGetAutoscalingCapacityHandler(), new RestDeleteAutoscalingPolicyHandler(), new RestGetAutoscalingPolicyHandler(), new RestPutAutoscalingPolicyHandler());
    }

    public List<NamedWriteableRegistry.Entry> getNamedWriteables() {
        return List.of(new NamedWriteableRegistry.Entry(Metadata.Custom.class, "autoscaling", AutoscalingMetadata::new), new NamedWriteableRegistry.Entry(NamedDiff.class, "autoscaling", AutoscalingMetadata.AutoscalingMetadataDiff::new), new NamedWriteableRegistry.Entry(AutoscalingDeciderResult.Reason.class, "fixed", FixedAutoscalingDeciderService.FixedReason::new), new NamedWriteableRegistry.Entry(AutoscalingDeciderResult.Reason.class, "reactive_storage", ReactiveStorageDeciderService.ReactiveReason::new), new NamedWriteableRegistry.Entry(AutoscalingDeciderResult.Reason.class, "proactive_storage", ProactiveStorageDeciderService.ProactiveReason::new), new NamedWriteableRegistry.Entry(AutoscalingDeciderResult.Reason.class, "frozen_shards", FrozenShardsDeciderService.FrozenShardsReason::new), new NamedWriteableRegistry.Entry(AutoscalingDeciderResult.Reason.class, "frozen_storage", FrozenStorageDeciderService.FrozenReason::new), new NamedWriteableRegistry.Entry(AutoscalingDeciderResult.Reason.class, "frozen_existence", FrozenExistenceDeciderService.FrozenExistenceReason::new));
    }

    public List<NamedXContentRegistry.Entry> getNamedXContent() {
        return List.of(new NamedXContentRegistry.Entry(Metadata.Custom.class, new ParseField("autoscaling", new String[0]), AutoscalingMetadata::parse));
    }

    public void loadExtensions(ExtensiblePlugin.ExtensionLoader loader) {
        loader.loadExtensions(AutoscalingExtension.class).forEach(this.autoscalingExtensions::add);
    }

    @Override
    public Collection<AutoscalingDeciderService> deciders() {
        AllocationService allocationService = (AllocationService)this.allocationServiceHolder.get();
        assert (allocationService != null);
        ClusterService clusterService = (ClusterService)this.clusterServiceHolder.get();
        return List.of(new FixedAutoscalingDeciderService(), new ReactiveStorageDeciderService(clusterService.getSettings(), clusterService.getClusterSettings(), allocationService.getAllocationDeciders(), allocationService.getShardRoutingRoleStrategy()), new ProactiveStorageDeciderService(clusterService.getSettings(), clusterService.getClusterSettings(), allocationService.getAllocationDeciders(), allocationService.getShardRoutingRoleStrategy()), new FrozenShardsDeciderService(), new FrozenStorageDeciderService(), new FrozenExistenceDeciderService());
    }

    public Set<AutoscalingDeciderService> createDeciderServices() {
        return this.autoscalingExtensions.stream().flatMap(p -> p.deciders().stream()).collect(Collectors.toSet());
    }

    public Collection<ReservedClusterStateHandler<?>> reservedClusterStateHandlers() {
        return Set.of((ReservedClusterStateHandler)this.reservedAutoscalingPolicyAction.get());
    }

    static {
        String property = System.getProperty("es.autoscaling_feature_flag_registered");
        if (property != null) {
            throw new IllegalArgumentException("es.autoscaling_feature_flag_registered is no longer supported");
        }
        AUTOSCALING_FEATURE = LicensedFeature.momentary(null, (String)"autoscaling", (License.OperationMode)License.OperationMode.ENTERPRISE);
    }
}

