/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.analytics.topmetrics;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.DoubleArray;
import org.elasticsearch.common.util.LongArray;
import org.elasticsearch.common.util.ObjectArray;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.index.fielddata.NumericDoubleValues;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.MultiValueMode;
import org.elasticsearch.search.aggregations.AggregationExecutionContext;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.aggregations.metrics.NumericMetricsAggregator;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.search.aggregations.support.ValuesSourceRegistry;
import org.elasticsearch.search.sort.BucketedSort;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortValue;
import org.elasticsearch.xpack.analytics.topmetrics.InternalTopMetrics;
import org.elasticsearch.xpack.analytics.topmetrics.TopMetricsAggregationBuilder;
import org.elasticsearch.xpack.core.common.search.aggregations.MissingHelper;

class TopMetricsAggregator
extends NumericMetricsAggregator.MultiValue {
    private final int size;
    private final BucketedSort sort;
    private final Metrics metrics;

    TopMetricsAggregator(String name, AggregationContext context, Aggregator parent, Map<String, Object> metadata, int size, SortBuilder<?> sort, MetricValues[] metricValues) throws IOException {
        super(name, context, parent, metadata);
        this.size = size;
        Metrics metrics = new Metrics(metricValues);
        Metrics values = metrics.values.length == 1 ? metrics.values[0] : metrics;
        this.sort = context.buildBucketedSort(sort, size, (BucketedSort.ExtraData)values);
        this.metrics = metrics;
    }

    public boolean hasMetric(String name) {
        for (MetricValues values : this.metrics.values) {
            if (!values.name.equals(name)) continue;
            return true;
        }
        return false;
    }

    public double metric(String name, long owningBucketOrd) {
        return this.metrics.metric(name, owningBucketOrd * (long)this.size);
    }

    public ScoreMode scoreMode() {
        boolean needs = this.sort.needsScores() || this.metrics.needsScores();
        return needs ? ScoreMode.COMPLETE : ScoreMode.COMPLETE_NO_SCORES;
    }

    public LeafBucketCollector getLeafCollector(AggregationExecutionContext aggCtx, LeafBucketCollector sub) throws IOException {
        assert (sub.isNoop()) : "Expected noop but was " + sub.toString();
        final BucketedSort.Leaf leafSort = this.sort.forLeaf(aggCtx.getLeafReaderContext());
        return new LeafBucketCollector(){

            public void collect(int doc, long bucket) throws IOException {
                leafSort.collect(doc, bucket);
            }

            public void setScorer(Scorable s) throws IOException {
                leafSort.setScorer(s);
            }
        };
    }

    public InternalAggregation buildAggregation(long bucket) throws IOException {
        List topMetrics = this.sort.getValues(bucket, this.metrics.resultBuilder(this.sort.getFormat()));
        assert (topMetrics.size() <= this.size);
        return new InternalTopMetrics(this.name, this.sort.getOrder(), this.metrics.names(), this.size, topMetrics, this.metadata());
    }

    public InternalTopMetrics buildEmptyAggregation() {
        return InternalTopMetrics.buildEmptyAggregation(this.name, this.metrics.names(), this.metadata());
    }

    public void doClose() {
        Releasables.close((Releasable[])new Releasable[]{this.sort, this.metrics});
    }

    static MetricValues buildMetricValues(ValuesSourceRegistry registry, BigArrays bigArrays, int size, String name, ValuesSourceConfig config) {
        if (!config.hasValues()) {
            return new AlwaysNullMetricValues(name);
        }
        MetricValuesSupplier supplier = (MetricValuesSupplier)registry.getAggregator(TopMetricsAggregationBuilder.REGISTRY_KEY, config);
        return supplier.build(size, bigArrays, name, config);
    }

    static MetricValues buildNumericMetricValues(int size, BigArrays bigArrays, String name, ValuesSourceConfig config) {
        ValuesSource.Numeric numeric = (ValuesSource.Numeric)config.getValuesSource();
        if (numeric.isFloatingPoint()) {
            return new DoubleMetricValues(size, bigArrays, name, config);
        }
        return new LongMetricValues(size, bigArrays, name, config);
    }

    static class Metrics
    implements BucketedSort.ExtraData,
    Releasable {
        private final MetricValues[] values;

        Metrics(MetricValues[] values) {
            this.values = values;
        }

        boolean needsScores() {
            for (int i = 0; i < this.values.length; ++i) {
                if (!this.values[i].needsScores()) continue;
                return true;
            }
            return false;
        }

        double metric(String name, long index) {
            for (MetricValues value : this.values) {
                if (!value.name.equals(name)) continue;
                return value.doubleValue(index);
            }
            throw new IllegalArgumentException("[" + name + "] not found");
        }

        BucketedSort.ResultBuilder<InternalTopMetrics.TopMetric> resultBuilder(DocValueFormat sortFormat) {
            return (index, sortValue) -> {
                ArrayList<InternalTopMetrics.MetricValue> result = new ArrayList<InternalTopMetrics.MetricValue>(this.values.length);
                for (int i = 0; i < this.values.length; ++i) {
                    result.add(this.values[i].metricValue(index));
                }
                return new InternalTopMetrics.TopMetric(sortFormat, sortValue, result);
            };
        }

        List<String> names() {
            return Arrays.stream(this.values).map(v -> v.name).collect(Collectors.toList());
        }

        public void swap(long lhs, long rhs) {
            for (int i = 0; i < this.values.length; ++i) {
                this.values[i].swap(lhs, rhs);
            }
        }

        public BucketedSort.ExtraData.Loader loader(LeafReaderContext ctx) throws IOException {
            BucketedSort.ExtraData.Loader[] loaders = new BucketedSort.ExtraData.Loader[this.values.length];
            for (int i = 0; i < this.values.length; ++i) {
                loaders[i] = this.values[i].loader(ctx);
            }
            return (index, doc) -> {
                for (int i = 0; i < loaders.length; ++i) {
                    loaders[i].loadFromDoc(index, doc);
                }
            };
        }

        public void close() {
            Releasables.close((Releasable[])this.values);
        }
    }

    static abstract class MetricValues
    implements BucketedSort.ExtraData,
    Releasable {
        protected final String name;

        MetricValues(String name) {
            this.name = name;
        }

        abstract boolean needsScores();

        abstract double doubleValue(long var1);

        abstract InternalTopMetrics.MetricValue metricValue(long var1) throws IOException;
    }

    static class AlwaysNullMetricValues
    extends MetricValues {
        AlwaysNullMetricValues(String name) {
            super(name);
        }

        @Override
        public double doubleValue(long index) {
            return Double.NaN;
        }

        @Override
        public InternalTopMetrics.MetricValue metricValue(long index) {
            return null;
        }

        @Override
        public boolean needsScores() {
            return false;
        }

        public void swap(long lhs, long rhs) {
        }

        public BucketedSort.ExtraData.Loader loader(LeafReaderContext ctx) throws IOException {
            return (index, doc) -> {};
        }

        public void close() {
        }
    }

    @FunctionalInterface
    static interface MetricValuesSupplier {
        public MetricValues build(int var1, BigArrays var2, String var3, ValuesSourceConfig var4);
    }

    static class DoubleMetricValues
    extends CollectingMetricValues {
        private final ValuesSource.Numeric valuesSource;
        private DoubleArray values;

        DoubleMetricValues(int size, BigArrays bigArrays, String name, ValuesSourceConfig config) {
            super(bigArrays, name, config);
            this.valuesSource = (ValuesSource.Numeric)config.getValuesSource();
            this.values = bigArrays.newDoubleArray((long)size, false);
        }

        @Override
        public double doubleValue(long index) {
            if (index < 0L || index >= this.values.size()) {
                return Double.NaN;
            }
            return this.values.get(index);
        }

        @Override
        public InternalTopMetrics.MetricValue metricValue(long index) {
            double value = this.values.get(index);
            if (Double.isNaN(value)) {
                return null;
            }
            return new InternalTopMetrics.MetricValue(this.config.format(), SortValue.from((double)value));
        }

        public void swap(long lhs, long rhs) {
            double tmp = this.values.get(lhs);
            this.values.set(lhs, this.values.get(rhs));
            this.values.set(rhs, tmp);
        }

        public BucketedSort.ExtraData.Loader loader(LeafReaderContext ctx) throws IOException {
            NumericDoubleValues metricValues = MultiValueMode.AVG.select(this.valuesSource.doubleValues(ctx));
            return (index, doc) -> {
                if (index >= this.values.size()) {
                    this.values = this.bigArrays.grow(this.values, index + 1L);
                }
                double metricValue = metricValues.advanceExact(doc) ? metricValues.doubleValue() : Double.NaN;
                this.values.set(index, metricValue);
            };
        }

        public void close() {
            this.values.close();
        }
    }

    static class LongMetricValues
    extends CollectingMetricValues {
        private final ValuesSource.Numeric valuesSource;
        private final MissingHelper empty;
        private LongArray values;

        LongMetricValues(int size, BigArrays bigArrays, String name, ValuesSourceConfig config) {
            super(bigArrays, name, config);
            this.valuesSource = (ValuesSource.Numeric)config.getValuesSource();
            this.empty = new MissingHelper(bigArrays);
            this.values = bigArrays.newLongArray((long)size, false);
        }

        @Override
        public double doubleValue(long index) {
            if (this.empty.isEmpty(index) || index < 0L || index >= this.values.size()) {
                return Double.NaN;
            }
            return this.values.get(index);
        }

        @Override
        public InternalTopMetrics.MetricValue metricValue(long index) {
            if (this.empty.isEmpty(index)) {
                return null;
            }
            return new InternalTopMetrics.MetricValue(this.config.format(), SortValue.from((long)this.values.get(index)));
        }

        public void swap(long lhs, long rhs) {
            long tmp = this.values.get(lhs);
            this.values.set(lhs, this.values.get(rhs));
            this.values.set(rhs, tmp);
            this.empty.swap(lhs, rhs);
        }

        public BucketedSort.ExtraData.Loader loader(LeafReaderContext ctx) throws IOException {
            NumericDocValues metricValues = MultiValueMode.AVG.select(this.valuesSource.longValues(ctx));
            return (index, doc) -> {
                if (!metricValues.advanceExact(doc)) {
                    this.empty.markMissing(index);
                    return;
                }
                if (index >= this.values.size()) {
                    this.values = this.bigArrays.grow(this.values, index + 1L);
                }
                this.values.set(index, metricValues.longValue());
                this.empty.markNotMissing(index);
            };
        }

        public void close() {
            Releasables.close((Releasable[])new Releasable[]{this.values, this.empty});
        }
    }

    static class SegmentOrdsValues
    extends CollectingMetricValues {
        private final ValuesSource.Bytes.WithOrdinals valuesSource;
        private ObjectArray<SortedSetDocValues> segmentResolve;
        private LongArray segmentOrds;

        SegmentOrdsValues(int size, BigArrays bigArrays, String name, ValuesSourceConfig config) {
            super(bigArrays, name, config);
            if (!config.hasOrdinals()) {
                throw new IllegalArgumentException("top_metrics can only collect bytes that have segment ordinals but " + config.getDescription() + " does not");
            }
            this.valuesSource = (ValuesSource.Bytes.WithOrdinals)config.getValuesSource();
            this.segmentResolve = bigArrays.newObjectArray((long)size);
            this.segmentOrds = bigArrays.newLongArray((long)size, false);
        }

        @Override
        public double doubleValue(long index) {
            throw new IllegalArgumentException("pipeline aggregations may not refer to non-numeric metrics collected by top_metrics");
        }

        @Override
        public InternalTopMetrics.MetricValue metricValue(long index) throws IOException {
            long ord = this.segmentOrds.get(index);
            if (ord == -1L) {
                return null;
            }
            SortedSetDocValues resolve = (SortedSetDocValues)this.segmentResolve.get(index);
            return new InternalTopMetrics.MetricValue(this.config.format(), SortValue.from((BytesRef)BytesRef.deepCopyOf((BytesRef)resolve.lookupOrd(ord))));
        }

        public void swap(long lhs, long rhs) {
            SortedSetDocValues tempSegmentResolve = (SortedSetDocValues)this.segmentResolve.get(lhs);
            this.segmentResolve.set(lhs, (Object)((SortedSetDocValues)this.segmentResolve.get(rhs)));
            this.segmentResolve.set(rhs, (Object)tempSegmentResolve);
            long tmpSegmentOrd = this.segmentOrds.get(lhs);
            this.segmentOrds.set(lhs, this.segmentOrds.get(rhs));
            this.segmentOrds.set(rhs, tmpSegmentOrd);
        }

        public BucketedSort.ExtraData.Loader loader(LeafReaderContext ctx) throws IOException {
            SortedSetDocValues segmentOrdValues = this.valuesSource.ordinalsValues(ctx);
            return (index, doc) -> {
                if (index >= this.segmentResolve.size()) {
                    this.segmentResolve = this.bigArrays.grow(this.segmentResolve, index + 1L);
                }
                if (index >= this.segmentOrds.size()) {
                    this.segmentOrds = this.bigArrays.grow(this.segmentOrds, index + 1L);
                }
                if (!segmentOrdValues.advanceExact(doc)) {
                    this.segmentResolve.set(index, null);
                    this.segmentOrds.set(index, -1L);
                    return;
                }
                this.segmentResolve.set(index, (Object)segmentOrdValues);
                this.segmentOrds.set(index, segmentOrdValues.nextOrd());
            };
        }

        public void close() {
            Releasables.close((Releasable[])new Releasable[]{this.segmentResolve, this.segmentOrds});
        }
    }

    private static abstract class CollectingMetricValues
    extends MetricValues {
        protected final BigArrays bigArrays;
        protected final ValuesSourceConfig config;

        CollectingMetricValues(BigArrays bigArrays, String name, ValuesSourceConfig config) {
            super(name);
            this.bigArrays = bigArrays;
            this.config = config;
        }

        @Override
        public final boolean needsScores() {
            return this.config.getValuesSource().needsScores();
        }
    }
}

