/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.analytics.mapper;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.lucene.document.BinaryDocValuesField;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SortField;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.Explicit;
import org.elasticsearch.common.io.stream.ByteArrayStreamInput;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.index.fielddata.FieldDataContext;
import org.elasticsearch.index.fielddata.FormattedDocValues;
import org.elasticsearch.index.fielddata.HistogramValue;
import org.elasticsearch.index.fielddata.HistogramValues;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexHistogramFieldData;
import org.elasticsearch.index.fielddata.LeafHistogramFieldData;
import org.elasticsearch.index.fielddata.SortedBinaryDocValues;
import org.elasticsearch.index.mapper.DocumentParserContext;
import org.elasticsearch.index.mapper.DocumentParsingException;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperBuilderContext;
import org.elasticsearch.index.mapper.SourceLoader;
import org.elasticsearch.index.mapper.SourceValueFetcher;
import org.elasticsearch.index.mapper.TextSearchInfo;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.script.field.DocValuesScriptFieldFactory;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.MultiValueMode;
import org.elasticsearch.search.sort.BucketedSort;
import org.elasticsearch.search.sort.SortOrder;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentSubParser;
import org.elasticsearch.xpack.analytics.aggregations.support.AnalyticsValuesSourceType;

public class HistogramFieldMapper
extends FieldMapper {
    public static final String CONTENT_TYPE = "histogram";
    public static final ParseField COUNTS_FIELD = new ParseField("counts", new String[0]);
    public static final ParseField VALUES_FIELD = new ParseField("values", new String[0]);
    public static final FieldMapper.TypeParser PARSER = new FieldMapper.TypeParser((n, c) -> new Builder((String)n, (Boolean)IGNORE_MALFORMED_SETTING.get(c.getSettings())), HistogramFieldMapper.notInMultiFields((String)"histogram"));
    private final Explicit<Boolean> ignoreMalformed;
    private final boolean ignoreMalformedByDefault;

    private static HistogramFieldMapper toType(FieldMapper in) {
        return (HistogramFieldMapper)in;
    }

    public HistogramFieldMapper(String simpleName, MappedFieldType mappedFieldType, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo, Builder builder) {
        super(simpleName, mappedFieldType, multiFields, copyTo);
        this.ignoreMalformed = (Explicit)builder.ignoreMalformed.getValue();
        this.ignoreMalformedByDefault = (Boolean)((Explicit)builder.ignoreMalformed.getDefaultValue()).value();
    }

    public boolean ignoreMalformed() {
        return (Boolean)this.ignoreMalformed.value();
    }

    protected String contentType() {
        return CONTENT_TYPE;
    }

    public FieldMapper.Builder getMergeBuilder() {
        return new Builder(this.simpleName(), this.ignoreMalformedByDefault).init(this);
    }

    protected void parseCreateField(DocumentParserContext context) {
        throw new UnsupportedOperationException("Parsing is implemented in parse(), this method should NEVER be called");
    }

    public void parse(DocumentParserContext context) throws IOException {
        context.path().add(this.simpleName());
        XContentSubParser subParser = null;
        try {
            XContentParser.Token token = context.parser().currentToken();
            if (token == XContentParser.Token.VALUE_NULL) {
                context.path().remove();
                return;
            }
            ArrayList<Double> values = null;
            ArrayList<Integer> counts = null;
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)token, (XContentParser)context.parser());
            subParser = new XContentSubParser(context.parser());
            token = subParser.nextToken();
            while (token != XContentParser.Token.END_OBJECT) {
                XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.FIELD_NAME, (XContentParser.Token)token, (XContentParser)subParser);
                String fieldName = subParser.currentName();
                if (fieldName.equals(VALUES_FIELD.getPreferredName())) {
                    token = subParser.nextToken();
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)token, (XContentParser)subParser);
                    values = new ArrayList<Double>();
                    token = subParser.nextToken();
                    double previousVal = -1.7976931348623157E308;
                    while (token != XContentParser.Token.END_ARRAY) {
                        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.VALUE_NUMBER, (XContentParser.Token)token, (XContentParser)subParser);
                        double val = subParser.doubleValue();
                        if (val < previousVal) {
                            throw new DocumentParsingException(subParser.getTokenLocation(), "error parsing field [" + this.name() + "], [" + VALUES_FIELD + "] values must be in increasing order, got [" + val + "] but previous value was [" + previousVal + "]");
                        }
                        values.add(val);
                        previousVal = val;
                        token = subParser.nextToken();
                    }
                } else if (fieldName.equals(COUNTS_FIELD.getPreferredName())) {
                    token = subParser.nextToken();
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)token, (XContentParser)subParser);
                    counts = new ArrayList<Integer>();
                    token = subParser.nextToken();
                    while (token != XContentParser.Token.END_ARRAY) {
                        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.VALUE_NUMBER, (XContentParser.Token)token, (XContentParser)subParser);
                        counts.add(subParser.intValue());
                        token = subParser.nextToken();
                    }
                } else {
                    throw new DocumentParsingException(subParser.getTokenLocation(), "error parsing field [" + this.name() + "], with unknown parameter [" + fieldName + "]");
                }
                token = subParser.nextToken();
            }
            if (values == null) {
                throw new DocumentParsingException(subParser.getTokenLocation(), "error parsing field [" + this.name() + "], expected field called [" + VALUES_FIELD.getPreferredName() + "]");
            }
            if (counts == null) {
                throw new DocumentParsingException(subParser.getTokenLocation(), "error parsing field [" + this.name() + "], expected field called [" + COUNTS_FIELD.getPreferredName() + "]");
            }
            if (values.size() != counts.size()) {
                throw new DocumentParsingException(subParser.getTokenLocation(), "error parsing field [" + this.name() + "], expected same length from [" + VALUES_FIELD.getPreferredName() + "] and [" + COUNTS_FIELD.getPreferredName() + "] but got [" + values.size() + " != " + counts.size() + "]");
            }
            BytesStreamOutput streamOutput = new BytesStreamOutput();
            for (int i = 0; i < values.size(); ++i) {
                int count = (Integer)counts.get(i);
                if (count < 0) {
                    throw new DocumentParsingException(subParser.getTokenLocation(), "error parsing field [" + this.name() + "], [" + COUNTS_FIELD + "] elements must be >= 0 but got " + counts.get(i));
                }
                if (count <= 0) continue;
                streamOutput.writeVInt(count);
                streamOutput.writeLong(Double.doubleToRawLongBits((Double)values.get(i)));
            }
            BytesRef docValue = streamOutput.bytes().toBytesRef();
            BinaryDocValuesField field = new BinaryDocValuesField(this.name(), docValue);
            if (context.doc().getByKey((Object)this.fieldType().name()) != null) {
                throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] doesn't not support indexing multiple values for the same field in the same document");
            }
            context.doc().addWithKey((Object)this.fieldType().name(), (IndexableField)field);
        }
        catch (Exception ex) {
            if (!((Boolean)this.ignoreMalformed.value()).booleanValue()) {
                throw new DocumentParsingException(context.parser().getTokenLocation(), "failed to parse field [" + this.fieldType().name() + "] of type [" + this.fieldType().typeName() + "]", ex);
            }
            if (subParser != null) {
                subParser.close();
            }
            context.addIgnoredField(this.fieldType().name());
        }
        context.path().remove();
    }

    public SourceLoader.SyntheticFieldLoader syntheticFieldLoader() {
        if (((Boolean)this.ignoreMalformed.value()).booleanValue()) {
            throw new IllegalArgumentException("field [" + this.name() + "] of type [histogram] doesn't support synthetic source because it ignores malformed histograms");
        }
        if (!this.copyTo.copyToFields().isEmpty()) {
            throw new IllegalArgumentException("field [" + this.name() + "] of type [histogram] doesn't support synthetic source because it declares copy_to");
        }
        return new SourceLoader.SyntheticFieldLoader(){
            private final InternalHistogramValue value = new InternalHistogramValue();
            private BytesRef binaryValue;

            public Stream<Map.Entry<String, SourceLoader.SyntheticFieldLoader.StoredFieldLoader>> storedFieldLoaders() {
                return Stream.of(new Map.Entry[0]);
            }

            public SourceLoader.SyntheticFieldLoader.DocValuesLoader docValuesLoader(LeafReader leafReader, int[] docIdsInLeaf) throws IOException {
                BinaryDocValues docValues = leafReader.getBinaryDocValues(HistogramFieldMapper.this.fieldType().name());
                if (docValues == null) {
                    this.binaryValue = null;
                    return null;
                }
                return docId -> {
                    if (docValues.advanceExact(docId)) {
                        this.binaryValue = docValues.binaryValue();
                        return true;
                    }
                    this.binaryValue = null;
                    return false;
                };
            }

            public boolean hasValue() {
                return this.binaryValue != null;
            }

            public void write(XContentBuilder b) throws IOException {
                if (this.binaryValue == null) {
                    return;
                }
                b.startObject(HistogramFieldMapper.this.simpleName());
                this.value.reset(this.binaryValue);
                b.startArray("values");
                while (this.value.next()) {
                    b.value(this.value.value());
                }
                b.endArray();
                this.value.reset(this.binaryValue);
                b.startArray("counts");
                while (this.value.next()) {
                    b.value(this.value.count());
                }
                b.endArray();
                b.endObject();
            }
        };
    }

    public static class Builder
    extends FieldMapper.Builder {
        private final FieldMapper.Parameter<Map<String, String>> meta = FieldMapper.Parameter.metaParam();
        private final FieldMapper.Parameter<Explicit<Boolean>> ignoreMalformed;

        public Builder(String name, boolean ignoreMalformedByDefault) {
            super(name);
            this.ignoreMalformed = FieldMapper.Parameter.explicitBoolParam((String)"ignore_malformed", (boolean)true, m -> HistogramFieldMapper.toType((FieldMapper)m).ignoreMalformed, (boolean)ignoreMalformedByDefault);
        }

        protected FieldMapper.Parameter<?>[] getParameters() {
            return new FieldMapper.Parameter[]{this.ignoreMalformed, this.meta};
        }

        public HistogramFieldMapper build(MapperBuilderContext context) {
            return new HistogramFieldMapper(this.name, new HistogramFieldType(context.buildFullName(this.name), (Map)this.meta.getValue()), this.multiFieldsBuilder.build((Mapper.Builder)this, context), this.copyTo.build(), this);
        }
    }

    private static class InternalHistogramValue
    extends HistogramValue {
        double value;
        int count;
        boolean isExhausted;
        final ByteArrayStreamInput streamInput = new ByteArrayStreamInput();

        InternalHistogramValue() {
        }

        void reset(BytesRef bytesRef) {
            this.streamInput.reset(bytesRef.bytes, bytesRef.offset, bytesRef.length);
            this.isExhausted = false;
            this.value = 0.0;
            this.count = 0;
        }

        public boolean next() throws IOException {
            if (this.streamInput.available() > 0) {
                this.count = this.streamInput.readVInt();
                this.value = Double.longBitsToDouble(this.streamInput.readLong());
                return true;
            }
            this.isExhausted = true;
            return false;
        }

        public double value() {
            if (this.isExhausted) {
                throw new IllegalArgumentException("histogram already exhausted");
            }
            return this.value;
        }

        public int count() {
            if (this.isExhausted) {
                throw new IllegalArgumentException("histogram already exhausted");
            }
            return this.count;
        }
    }

    public static class HistogramFieldType
    extends MappedFieldType {
        public HistogramFieldType(String name, Map<String, String> meta) {
            super(name, false, false, true, TextSearchInfo.NONE, meta);
        }

        public String typeName() {
            return HistogramFieldMapper.CONTENT_TYPE;
        }

        public ValueFetcher valueFetcher(SearchExecutionContext context, String format) {
            return SourceValueFetcher.identity((String)this.name(), (SearchExecutionContext)context, (String)format);
        }

        public IndexFieldData.Builder fielddataBuilder(FieldDataContext fieldDataContext) {
            this.failIfNoDocValues();
            return (cache, breakerService) -> new IndexHistogramFieldData(this.name(), AnalyticsValuesSourceType.HISTOGRAM){

                public LeafHistogramFieldData load(final LeafReaderContext context) {
                    return new LeafHistogramFieldData(){

                        public HistogramValues getHistogramValues() throws IOException {
                            try {
                                final BinaryDocValues values = DocValues.getBinary((LeafReader)context.reader(), (String)fieldName);
                                final InternalHistogramValue value = new InternalHistogramValue();
                                return new HistogramValues(){

                                    public boolean advanceExact(int doc) throws IOException {
                                        return values.advanceExact(doc);
                                    }

                                    public HistogramValue histogram() throws IOException {
                                        try {
                                            value.reset(values.binaryValue());
                                            return value;
                                        }
                                        catch (IOException e) {
                                            throw new IOException("Cannot load doc value", e);
                                        }
                                    }
                                };
                            }
                            catch (IOException e) {
                                throw new IOException("Cannot load doc values", e);
                            }
                        }

                        public DocValuesScriptFieldFactory getScriptFieldFactory(String name) {
                            throw new UnsupportedOperationException("The [histogram] field does not support scripts");
                        }

                        public FormattedDocValues getFormattedValues(DocValueFormat format) {
                            try {
                                final BinaryDocValues values = DocValues.getBinary((LeafReader)context.reader(), (String)fieldName);
                                final InternalHistogramValue value = new InternalHistogramValue();
                                return new FormattedDocValues(){

                                    public boolean advanceExact(int docId) throws IOException {
                                        return values.advanceExact(docId);
                                    }

                                    public int docValueCount() {
                                        return 1;
                                    }

                                    public Object nextValue() throws IOException {
                                        value.reset(values.binaryValue());
                                        return value;
                                    }
                                };
                            }
                            catch (IOException e) {
                                throw new UncheckedIOException("Unable to loead histogram doc values", e);
                            }
                        }

                        public SortedBinaryDocValues getBytesValues() {
                            throw new UnsupportedOperationException("String representation of doc values for [histogram] fields is not supported");
                        }

                        public long ramBytesUsed() {
                            return 0L;
                        }

                        public void close() {
                        }
                    };
                }

                public LeafHistogramFieldData loadDirect(LeafReaderContext context) {
                    return this.load(context);
                }

                public SortField sortField(Object missingValue, MultiValueMode sortMode, IndexFieldData.XFieldComparatorSource.Nested nested, boolean reverse) {
                    throw new UnsupportedOperationException("can't sort on the [histogram] field");
                }

                public BucketedSort newBucketedSort(BigArrays bigArrays, Object missingValue, MultiValueMode sortMode, IndexFieldData.XFieldComparatorSource.Nested nested, SortOrder sortOrder, DocValueFormat format, int bucketSize, BucketedSort.ExtraData extra) {
                    throw new IllegalArgumentException("can't sort on the [histogram] field");
                }
            };
        }

        public Query termQuery(Object value, SearchExecutionContext context) {
            throw new IllegalArgumentException("[histogram] field do not support searching, use dedicated aggregations instead: [" + this.name() + "]");
        }
    }
}

