/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.analytics.boxplot;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.search.ScoreMode;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.ObjectArray;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.index.fielddata.HistogramValue;
import org.elasticsearch.index.fielddata.HistogramValues;
import org.elasticsearch.index.fielddata.SortedNumericDoubleValues;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.AggregationExecutionContext;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.aggregations.LeafBucketCollectorBase;
import org.elasticsearch.search.aggregations.metrics.NumericMetricsAggregator;
import org.elasticsearch.search.aggregations.metrics.TDigestExecutionHint;
import org.elasticsearch.search.aggregations.metrics.TDigestState;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.xpack.analytics.aggregations.support.HistogramValuesSource;
import org.elasticsearch.xpack.analytics.boxplot.InternalBoxplot;

public class BoxplotAggregator
extends NumericMetricsAggregator.MultiValue {
    private final ValuesSource valuesSource;
    private final DocValueFormat format;
    protected ObjectArray<TDigestState> states;
    protected final double compression;
    protected final TDigestExecutionHint executionHint;

    BoxplotAggregator(String name, ValuesSourceConfig config, DocValueFormat formatter, double compression, TDigestExecutionHint executionHint, AggregationContext context, Aggregator parent, Map<String, Object> metadata) throws IOException {
        super(name, context, parent, metadata);
        assert (config.hasValues());
        this.valuesSource = config.getValuesSource();
        this.format = formatter;
        this.compression = compression;
        this.executionHint = executionHint;
        this.states = context.bigArrays().newObjectArray(1L);
    }

    public ScoreMode scoreMode() {
        return this.valuesSource.needsScores() ? ScoreMode.COMPLETE : ScoreMode.COMPLETE_NO_SCORES;
    }

    public LeafBucketCollector getLeafCollector(AggregationExecutionContext aggCtx, LeafBucketCollector sub) throws IOException {
        if (this.valuesSource instanceof HistogramValuesSource.Histogram) {
            final HistogramValues values = ((HistogramValuesSource.Histogram)this.valuesSource).getHistogramValues(aggCtx.getLeafReaderContext());
            return new LeafBucketCollectorBase(sub, values){

                public void collect(int doc, long bucket) throws IOException {
                    TDigestState state = BoxplotAggregator.this.getExistingOrNewHistogram(BoxplotAggregator.this.bigArrays(), bucket);
                    if (values.advanceExact(doc)) {
                        HistogramValue sketch = values.histogram();
                        while (sketch.next()) {
                            state.add(sketch.value(), (long)sketch.count());
                        }
                    }
                }
            };
        }
        final SortedNumericDoubleValues values = ((ValuesSource.Numeric)this.valuesSource).doubleValues(aggCtx.getLeafReaderContext());
        return new LeafBucketCollectorBase(sub, values){

            public void collect(int doc, long bucket) throws IOException {
                BoxplotAggregator.this.states = BoxplotAggregator.this.bigArrays().grow(BoxplotAggregator.this.states, bucket + 1L);
                if (values.advanceExact(doc)) {
                    TDigestState state = BoxplotAggregator.this.getExistingOrNewHistogram(BoxplotAggregator.this.bigArrays(), bucket);
                    if (values.advanceExact(doc)) {
                        int valueCount = values.docValueCount();
                        for (int i = 0; i < valueCount; ++i) {
                            state.add(values.nextValue());
                        }
                    }
                }
            }
        };
    }

    private TDigestState getExistingOrNewHistogram(BigArrays bigArrays, long bucket) {
        this.states = bigArrays.grow(this.states, bucket + 1L);
        TDigestState state = (TDigestState)this.states.get(bucket);
        if (state == null) {
            state = TDigestState.create((double)this.compression, (TDigestExecutionHint)this.executionHint);
            this.states.set(bucket, (Object)state);
        }
        return state;
    }

    public boolean hasMetric(String name) {
        return InternalBoxplot.Metrics.hasMetric(name);
    }

    public double metric(String name, long owningBucketOrd) {
        TDigestState state = null;
        if (owningBucketOrd < this.states.size()) {
            state = (TDigestState)this.states.get(owningBucketOrd);
        }
        return InternalBoxplot.Metrics.resolve(name).value(state);
    }

    public InternalAggregation buildAggregation(long owningBucketOrdinal) {
        TDigestState state = this.getState(owningBucketOrdinal);
        if (state == null) {
            return this.buildEmptyAggregation();
        }
        return new InternalBoxplot(this.name, state, this.format, this.metadata());
    }

    TDigestState getState(long bucketOrd) {
        if (bucketOrd >= this.states.size()) {
            return null;
        }
        return (TDigestState)this.states.get(bucketOrd);
    }

    public InternalAggregation buildEmptyAggregation() {
        return InternalBoxplot.empty(this.name, this.compression, this.executionHint, this.format, this.metadata());
    }

    public void doClose() {
        Releasables.close(this.states);
    }
}

