/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.analytics.aggregations.metrics;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.search.ScoreMode;
import org.elasticsearch.common.util.DoubleArray;
import org.elasticsearch.common.util.LongArray;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.index.fielddata.HistogramValue;
import org.elasticsearch.index.fielddata.HistogramValues;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.AggregationExecutionContext;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.aggregations.LeafBucketCollectorBase;
import org.elasticsearch.search.aggregations.metrics.CompensatedSum;
import org.elasticsearch.search.aggregations.metrics.InternalAvg;
import org.elasticsearch.search.aggregations.metrics.NumericMetricsAggregator;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.xpack.analytics.aggregations.support.HistogramValuesSource;

public class HistoBackedAvgAggregator
extends NumericMetricsAggregator.SingleValue {
    private final HistogramValuesSource.Histogram valuesSource;
    LongArray counts;
    DoubleArray sums;
    DoubleArray compensations;
    DocValueFormat format;

    public HistoBackedAvgAggregator(String name, ValuesSourceConfig valuesSourceConfig, AggregationContext context, Aggregator parent, Map<String, Object> metadata) throws IOException {
        super(name, context, parent, metadata);
        this.valuesSource = valuesSourceConfig.hasValues() ? (HistogramValuesSource.Histogram)valuesSourceConfig.getValuesSource() : null;
        this.format = valuesSourceConfig.format();
        if (this.valuesSource != null) {
            this.counts = this.bigArrays().newLongArray(1L, true);
            this.sums = this.bigArrays().newDoubleArray(1L, true);
            this.compensations = this.bigArrays().newDoubleArray(1L, true);
        }
    }

    public ScoreMode scoreMode() {
        return this.valuesSource != null && this.valuesSource.needsScores() ? ScoreMode.COMPLETE : ScoreMode.COMPLETE_NO_SCORES;
    }

    public LeafBucketCollector getLeafCollector(AggregationExecutionContext aggCtx, LeafBucketCollector sub) throws IOException {
        if (this.valuesSource == null) {
            return LeafBucketCollector.NO_OP_COLLECTOR;
        }
        final HistogramValues values = this.valuesSource.getHistogramValues(aggCtx.getLeafReaderContext());
        final CompensatedSum kahanSummation = new CompensatedSum(0.0, 0.0);
        return new LeafBucketCollectorBase(sub, values){

            public void collect(int doc, long bucket) throws IOException {
                HistoBackedAvgAggregator.this.counts = HistoBackedAvgAggregator.this.bigArrays().grow(HistoBackedAvgAggregator.this.counts, bucket + 1L);
                HistoBackedAvgAggregator.this.sums = HistoBackedAvgAggregator.this.bigArrays().grow(HistoBackedAvgAggregator.this.sums, bucket + 1L);
                HistoBackedAvgAggregator.this.compensations = HistoBackedAvgAggregator.this.bigArrays().grow(HistoBackedAvgAggregator.this.compensations, bucket + 1L);
                if (values.advanceExact(doc)) {
                    HistogramValue sketch = values.histogram();
                    double sum = HistoBackedAvgAggregator.this.sums.get(bucket);
                    double compensation = HistoBackedAvgAggregator.this.compensations.get(bucket);
                    kahanSummation.reset(sum, compensation);
                    while (sketch.next()) {
                        double d = sketch.value() * (double)sketch.count();
                        kahanSummation.add(d);
                        HistoBackedAvgAggregator.this.counts.increment(bucket, (long)sketch.count());
                    }
                    HistoBackedAvgAggregator.this.sums.set(bucket, kahanSummation.value());
                    HistoBackedAvgAggregator.this.compensations.set(bucket, kahanSummation.delta());
                }
            }
        };
    }

    public double metric(long owningBucketOrd) {
        if (this.valuesSource == null || owningBucketOrd >= this.sums.size()) {
            return Double.NaN;
        }
        return this.sums.get(owningBucketOrd) / (double)this.counts.get(owningBucketOrd);
    }

    public InternalAggregation buildAggregation(long bucket) {
        if (this.valuesSource == null || bucket >= this.sums.size()) {
            return this.buildEmptyAggregation();
        }
        return new InternalAvg(this.name, this.sums.get(bucket), this.counts.get(bucket), this.format, this.metadata());
    }

    public InternalAggregation buildEmptyAggregation() {
        return new InternalAvg(this.name, 0.0, 0L, this.format, this.metadata());
    }

    public void doClose() {
        Releasables.close((Releasable[])new Releasable[]{this.counts, this.sums, this.compensations});
    }
}

