/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.analytics.aggregations.metrics;

import java.io.IOException;
import java.util.Map;
import org.HdrHistogram.DoubleHistogram;
import org.apache.lucene.search.ScoreMode;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.ObjectArray;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.index.fielddata.HistogramValue;
import org.elasticsearch.index.fielddata.HistogramValues;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.AggregationExecutionContext;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.aggregations.LeafBucketCollectorBase;
import org.elasticsearch.search.aggregations.metrics.NumericMetricsAggregator;
import org.elasticsearch.search.aggregations.metrics.PercentilesConfig;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.xpack.analytics.aggregations.support.HistogramValuesSource;

abstract class AbstractHistoBackedHDRPercentilesAggregator
extends NumericMetricsAggregator.MultiValue {
    protected final double[] keys;
    protected final ValuesSource valuesSource;
    protected final DocValueFormat format;
    protected ObjectArray<DoubleHistogram> states;
    protected final int numberOfSignificantValueDigits;
    protected final boolean keyed;

    AbstractHistoBackedHDRPercentilesAggregator(String name, ValuesSourceConfig config, AggregationContext context, Aggregator parent, double[] keys, int numberOfSignificantValueDigits, boolean keyed, DocValueFormat formatter, Map<String, Object> metadata) throws IOException {
        super(name, context, parent, metadata);
        assert (config.hasValues());
        this.valuesSource = config.getValuesSource();
        this.keyed = keyed;
        this.format = formatter;
        this.states = context.bigArrays().newObjectArray(1L);
        this.keys = keys;
        this.numberOfSignificantValueDigits = numberOfSignificantValueDigits;
    }

    public ScoreMode scoreMode() {
        return this.valuesSource.needsScores() ? ScoreMode.COMPLETE : ScoreMode.COMPLETE_NO_SCORES;
    }

    public LeafBucketCollector getLeafCollector(AggregationExecutionContext aggCtx, LeafBucketCollector sub) throws IOException {
        final HistogramValues values = ((HistogramValuesSource.Histogram)this.valuesSource).getHistogramValues(aggCtx.getLeafReaderContext());
        return new LeafBucketCollectorBase(sub, values){

            public void collect(int doc, long bucket) throws IOException {
                DoubleHistogram state = AbstractHistoBackedHDRPercentilesAggregator.this.getExistingOrNewHistogram(AbstractHistoBackedHDRPercentilesAggregator.this.bigArrays(), bucket);
                if (values.advanceExact(doc)) {
                    HistogramValue sketch = values.histogram();
                    while (sketch.next()) {
                        state.recordValueWithCount(sketch.value(), (long)sketch.count());
                    }
                }
            }
        };
    }

    private DoubleHistogram getExistingOrNewHistogram(BigArrays bigArrays, long bucket) {
        this.states = bigArrays.grow(this.states, bucket + 1L);
        DoubleHistogram state = (DoubleHistogram)this.states.get(bucket);
        if (state == null) {
            state = new DoubleHistogram(this.numberOfSignificantValueDigits);
            state.setAutoResize(true);
            this.states.set(bucket, (Object)state);
        }
        return state;
    }

    public boolean hasMetric(String name) {
        return PercentilesConfig.indexOfKey((double[])this.keys, (double)Double.parseDouble(name)) >= 0;
    }

    protected DoubleHistogram getState(long bucketOrd) {
        if (bucketOrd >= this.states.size()) {
            return null;
        }
        DoubleHistogram state = (DoubleHistogram)this.states.get(bucketOrd);
        return state;
    }

    protected void doClose() {
        Releasables.close(this.states);
    }
}

