/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.unsignedlong;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedNumericDocValues;
import org.elasticsearch.index.fielddata.IndexFieldDataCache;
import org.elasticsearch.index.fielddata.SourceValueFetcherIndexFieldData;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.script.field.DocValuesScriptFieldFactory;
import org.elasticsearch.script.field.ToScriptFieldFactory;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;
import org.elasticsearch.search.lookup.Source;
import org.elasticsearch.search.lookup.SourceProvider;

public class SourceValueFetcherSortedUnsignedLongIndexFieldData
extends SourceValueFetcherIndexFieldData<SortedNumericDocValues> {
    protected SourceValueFetcherSortedUnsignedLongIndexFieldData(String fieldName, ValuesSourceType valuesSourceType, ValueFetcher valueFetcher, SourceProvider sourceProvider, ToScriptFieldFactory<SortedNumericDocValues> toScriptFieldFactory) {
        super(fieldName, valuesSourceType, valueFetcher, sourceProvider, toScriptFieldFactory);
    }

    public SourceValueFetcherIndexFieldData.SourceValueFetcherLeafFieldData<SortedNumericDocValues> loadDirect(LeafReaderContext context) {
        return new SourceValueFetcherSortedUnsignedLongLeafFieldData((ToScriptFieldFactory<SortedNumericDocValues>)this.toScriptFieldFactory, context, this.valueFetcher, this.sourceProvider);
    }

    private static class SourceValueFetcherSortedUnsignedLongLeafFieldData
    extends SourceValueFetcherIndexFieldData.SourceValueFetcherLeafFieldData<SortedNumericDocValues> {
        private SourceValueFetcherSortedUnsignedLongLeafFieldData(ToScriptFieldFactory<SortedNumericDocValues> toScriptFieldFactory, LeafReaderContext leafReaderContext, ValueFetcher valueFetcher, SourceProvider sourceProvider) {
            super(toScriptFieldFactory, leafReaderContext, valueFetcher, sourceProvider);
        }

        public DocValuesScriptFieldFactory getScriptFieldFactory(String name) {
            return this.toScriptFieldFactory.getScriptFieldFactory((Object)new SourceValueFetcherSortedUnsignedLongDocValues(this.leafReaderContext, this.valueFetcher, this.sourceProvider), name);
        }
    }

    private static class SourceValueFetcherSortedUnsignedLongDocValues
    extends SortedNumericDocValues
    implements SourceValueFetcherIndexFieldData.ValueFetcherDocValues {
        private final LeafReaderContext leafReaderContext;
        private final ValueFetcher valueFetcher;
        private final SourceProvider sourceProvider;
        private List<Long> values;
        private Iterator<Long> iterator;

        private SourceValueFetcherSortedUnsignedLongDocValues(LeafReaderContext leafReaderContext, ValueFetcher valueFetcher, SourceProvider sourceProvider) {
            this.leafReaderContext = leafReaderContext;
            this.valueFetcher = valueFetcher;
            this.sourceProvider = sourceProvider;
            this.values = new ArrayList<Long>();
        }

        public boolean advanceExact(int doc) throws IOException {
            this.values.clear();
            Source source = this.sourceProvider.getSource(this.leafReaderContext, doc);
            for (Object value : this.valueFetcher.fetchValues(source, doc, Collections.emptyList())) {
                assert (value instanceof Number);
                this.values.add(((Number)value).longValue() ^ Long.MIN_VALUE);
            }
            this.values.sort(Long::compare);
            this.iterator = this.values.iterator();
            return true;
        }

        public int docValueCount() {
            return this.values.size();
        }

        public long nextValue() throws IOException {
            assert (this.iterator.hasNext());
            return this.iterator.next();
        }

        public int docID() {
            throw new UnsupportedOperationException("not supported for source fallback");
        }

        public int nextDoc() throws IOException {
            throw new UnsupportedOperationException("not supported for source fallback");
        }

        public int advance(int target) throws IOException {
            throw new UnsupportedOperationException("not supported for source fallback");
        }

        public long cost() {
            throw new UnsupportedOperationException("not supported for source fallback");
        }
    }

    public static class Builder
    extends SourceValueFetcherIndexFieldData.Builder<SortedNumericDocValues> {
        public Builder(String fieldName, ValuesSourceType valuesSourceType, ValueFetcher valueFetcher, SourceProvider sourceProvider, ToScriptFieldFactory<SortedNumericDocValues> toScriptFieldFactory) {
            super(fieldName, valuesSourceType, valueFetcher, sourceProvider, toScriptFieldFactory);
        }

        public SourceValueFetcherSortedUnsignedLongIndexFieldData build(IndexFieldDataCache cache, CircuitBreakerService breakerService) {
            return new SourceValueFetcherSortedUnsignedLongIndexFieldData(this.fieldName, this.valuesSourceType, this.valueFetcher, this.sourceProvider, (ToScriptFieldFactory<SortedNumericDocValues>)this.toScriptFieldFactory);
        }
    }
}

