/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.transform.transforms;

import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.common.breaker.CircuitBreakingException;
import org.elasticsearch.core.Strings;
import org.elasticsearch.script.ScriptException;
import org.elasticsearch.xpack.core.common.notifications.Level;
import org.elasticsearch.xpack.core.transform.TransformMessages;
import org.elasticsearch.xpack.core.transform.transforms.SettingsConfig;
import org.elasticsearch.xpack.core.transform.utils.ExceptionsHelper;
import org.elasticsearch.xpack.transform.notifications.TransformAuditor;
import org.elasticsearch.xpack.transform.transforms.BulkIndexingException;
import org.elasticsearch.xpack.transform.transforms.TransformContext;
import org.elasticsearch.xpack.transform.utils.ExceptionRootCauseFinder;

class TransformFailureHandler {
    private static final Logger logger = LogManager.getLogger(TransformFailureHandler.class);
    public static final int LOG_FAILURE_EVERY = 10;
    private final TransformAuditor auditor;
    private final String transformId;
    private final TransformContext context;

    TransformFailureHandler(TransformAuditor auditor, TransformContext context, String transformId) {
        this.auditor = auditor;
        this.transformId = transformId;
        this.context = context;
    }

    void handleIndexerFailure(Exception e, SettingsConfig settingsConfig) {
        logger.debug(() -> "[" + this.transformId + "] transform encountered an exception: ", (Throwable)e);
        Throwable unwrappedException = ExceptionsHelper.findSearchExceptionRootCause((Throwable)e);
        boolean unattended = Boolean.TRUE.equals(settingsConfig.getUnattended());
        if (unwrappedException instanceof CircuitBreakingException) {
            CircuitBreakingException circuitBreakingException = (CircuitBreakingException)unwrappedException;
            this.handleCircuitBreakingException(circuitBreakingException, unattended);
        } else if (unwrappedException instanceof ScriptException) {
            ScriptException scriptException = (ScriptException)unwrappedException;
            this.handleScriptException(scriptException, unattended);
        } else if (unwrappedException instanceof BulkIndexingException) {
            BulkIndexingException bulkIndexingException = (BulkIndexingException)((Object)unwrappedException);
            this.handleBulkIndexingException(bulkIndexingException, unattended, this.getNumFailureRetries(settingsConfig));
        } else if (unwrappedException instanceof ClusterBlockException) {
            ClusterBlockException clusterBlockException = (ClusterBlockException)unwrappedException;
            this.retry((Throwable)clusterBlockException, clusterBlockException.getDetailedMessage(), unattended, this.getNumFailureRetries(settingsConfig));
        } else if (unwrappedException instanceof ElasticsearchException) {
            ElasticsearchException elasticsearchException = (ElasticsearchException)unwrappedException;
            this.handleElasticsearchException(elasticsearchException, unattended, this.getNumFailureRetries(settingsConfig));
        } else if (unwrappedException instanceof IllegalArgumentException) {
            IllegalArgumentException illegalArgumentException = (IllegalArgumentException)unwrappedException;
            this.handleIllegalArgumentException(illegalArgumentException, unattended);
        } else {
            this.retry(unwrappedException, ExceptionRootCauseFinder.getDetailedMessage(unwrappedException), unattended, this.getNumFailureRetries(settingsConfig));
        }
    }

    boolean handleStatePersistenceFailure(Exception e, SettingsConfig settingsConfig) {
        int numFailureRetries = this.getNumFailureRetries(settingsConfig);
        int failureCount = this.context.incrementAndGetStatePersistenceFailureCount(e);
        if (numFailureRetries != -1 && failureCount > numFailureRetries) {
            this.fail("task encountered more than " + numFailureRetries + " failures updating internal state; latest failure: " + e.getMessage());
            return true;
        }
        return false;
    }

    private void handleCircuitBreakingException(CircuitBreakingException circuitBreakingException, boolean unattended) {
        int pageSize = this.context.getPageSize();
        double reducingFactor = Math.min((double)circuitBreakingException.getByteLimit() / (double)circuitBreakingException.getBytesWanted(), 1.0 - Math.log10(pageSize) * 0.1);
        int newPageSize = (int)Math.round(reducingFactor * (double)pageSize);
        if (newPageSize < 10) {
            String message = TransformMessages.getMessage((String)"Insufficient memory for search after repeated page size reductions to [{0}], unable to continue pivot, please simplify job or increase heap size on data nodes.", (Object[])new Object[]{pageSize});
            if (unattended) {
                this.retry((Throwable)circuitBreakingException, message, true, -1);
            } else {
                this.fail(message);
            }
        } else {
            String message = TransformMessages.getMessage((String)"Insufficient memory for search, reducing number of buckets per search from [{0}] to [{1}]", (Object[])new Object[]{pageSize, newPageSize});
            this.auditor.info(this.transformId, message);
            logger.info("[{}] {}", (Object)this.transformId, (Object)message);
            this.context.setPageSize(newPageSize);
        }
    }

    private void handleScriptException(ScriptException scriptException, boolean unattended) {
        String message = TransformMessages.getMessage((String)"Failed to execute script with error: [{0}], stack trace: {1}", (Object[])new Object[]{scriptException.getDetailedMessage(), scriptException.getScriptStack()});
        if (unattended) {
            this.retry((Throwable)scriptException, message, true, -1);
        } else {
            this.fail(message);
        }
    }

    private void handleBulkIndexingException(BulkIndexingException bulkIndexingException, boolean unattended, int numFailureRetries) {
        if (!unattended && bulkIndexingException.isIrrecoverable()) {
            String message = TransformMessages.getMessage((String)"Failed to index documents into destination index due to permanent error: [{0}]", (Object[])new Object[]{bulkIndexingException.getDetailedMessage()});
            this.fail(message);
        } else {
            this.retry((Throwable)((Object)bulkIndexingException), bulkIndexingException.getDetailedMessage(), unattended, numFailureRetries);
        }
    }

    private void handleElasticsearchException(ElasticsearchException elasticsearchException, boolean unattended, int numFailureRetries) {
        if (!unattended && ExceptionRootCauseFinder.IRRECOVERABLE_REST_STATUSES.contains(elasticsearchException.status())) {
            String message = "task encountered irrecoverable failure: " + elasticsearchException.getDetailedMessage();
            this.fail(message);
        } else {
            this.retry(elasticsearchException, elasticsearchException.getDetailedMessage(), unattended, numFailureRetries);
        }
    }

    private void handleIllegalArgumentException(IllegalArgumentException illegalArgumentException, boolean unattended) {
        if (unattended) {
            this.retry(illegalArgumentException, illegalArgumentException.getMessage(), true, -1);
        } else {
            String message = "task encountered irrecoverable failure: " + illegalArgumentException.getMessage();
            this.fail(message);
        }
    }

    private void retry(Throwable unwrappedException, String message, boolean unattended, int numFailureRetries) {
        boolean repeatedFailure = this.context.getLastFailure() == null ? false : unwrappedException.getClass().equals(this.context.getLastFailure().getClass());
        int failureCount = this.context.incrementAndGetFailureCount(unwrappedException);
        if (!unattended && numFailureRetries != -1 && failureCount > numFailureRetries) {
            this.fail("task encountered more than " + numFailureRetries + " failures; latest failure: " + message);
            return;
        }
        if (!repeatedFailure || failureCount % 10 == 0 || failureCount == numFailureRetries) {
            String retryMessage = Strings.format((String)"Transform encountered an exception: [%s]; Will automatically retry [%d/%d]", (Object[])new Object[]{message, failureCount, numFailureRetries});
            logger.log(unattended ? org.apache.logging.log4j.Level.INFO : org.apache.logging.log4j.Level.WARN, () -> "[" + this.transformId + "] " + retryMessage);
            this.auditor.audit(unattended ? Level.INFO : Level.WARNING, this.transformId, retryMessage);
        }
    }

    private void fail(String failureMessage) {
        this.context.markAsFailed(failureMessage);
    }

    private int getNumFailureRetries(SettingsConfig settingsConfig) {
        return Boolean.TRUE.equals(settingsConfig.getUnattended()) ? -1 : Optional.ofNullable(settingsConfig.getNumFailureRetries()).orElse(this.context.getNumFailureRetries());
    }
}

