/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.transform.action;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.ml.utils.TransportVersionUtils;
import org.elasticsearch.xpack.core.security.SecurityContext;
import org.elasticsearch.xpack.core.transform.action.UpgradeTransformsAction;
import org.elasticsearch.xpack.core.transform.transforms.TransformConfig;
import org.elasticsearch.xpack.core.transform.transforms.TransformConfigUpdate;
import org.elasticsearch.xpack.transform.TransformServices;
import org.elasticsearch.xpack.transform.action.TransformUpdater;
import org.elasticsearch.xpack.transform.notifications.TransformAuditor;
import org.elasticsearch.xpack.transform.persistence.SeqNoPrimaryTermAndIndex;
import org.elasticsearch.xpack.transform.persistence.TransformConfigManager;
import org.elasticsearch.xpack.transform.transforms.TransformNodes;

public class TransportUpgradeTransformsAction
extends TransportMasterNodeAction<UpgradeTransformsAction.Request, UpgradeTransformsAction.Response> {
    private static final Logger logger = LogManager.getLogger(TransportUpgradeTransformsAction.class);
    private final TransformConfigManager transformConfigManager;
    private final SecurityContext securityContext;
    private final IndexNameExpressionResolver indexNameExpressionResolver;
    private final Settings settings;
    private final Client client;
    private final TransformAuditor auditor;

    @Inject
    public TransportUpgradeTransformsAction(TransportService transportService, ActionFilters actionFilters, ClusterService clusterService, ThreadPool threadPool, IndexNameExpressionResolver indexNameExpressionResolver, TransformServices transformServices, Client client, Settings settings) {
        super("cluster:admin/transform/upgrade", transportService, clusterService, threadPool, actionFilters, UpgradeTransformsAction.Request::new, indexNameExpressionResolver, UpgradeTransformsAction.Response::new, "same");
        this.transformConfigManager = transformServices.getConfigManager();
        this.settings = settings;
        this.client = client;
        this.auditor = transformServices.getAuditor();
        this.indexNameExpressionResolver = indexNameExpressionResolver;
        this.securityContext = (Boolean)XPackSettings.SECURITY_ENABLED.get(settings) != false ? new SecurityContext(settings, threadPool.getThreadContext()) : null;
    }

    protected void masterOperation(Task ignoredTask, UpgradeTransformsAction.Request request, ClusterState state, ActionListener<UpgradeTransformsAction.Response> listener) throws Exception {
        TransformNodes.warnIfNoTransformNodes(state);
        if (!TransportVersionUtils.isMinTransportVersionSameAsCurrent((ClusterState)state)) {
            listener.onFailure((Exception)new ElasticsearchStatusException("Cannot upgrade transforms while cluster upgrade is in progress.", RestStatus.CONFLICT, new Object[0]));
            return;
        }
        this.recursiveExpandTransformIdsAndUpgrade(request.isDryRun(), request.timeout(), (ActionListener<Map<TransformUpdater.UpdateResult.Status, Long>>)ActionListener.wrap(updatesByStatus -> {
            long updated = updatesByStatus.getOrDefault((Object)TransformUpdater.UpdateResult.Status.UPDATED, 0L);
            long noAction = updatesByStatus.getOrDefault((Object)TransformUpdater.UpdateResult.Status.NONE, 0L);
            long needsUpdate = updatesByStatus.getOrDefault((Object)TransformUpdater.UpdateResult.Status.NEEDS_UPDATE, 0L);
            if (!request.isDryRun()) {
                this.transformConfigManager.deleteOldIndices((ActionListener<Boolean>)ActionListener.wrap(aBool -> {
                    logger.info("Successfully upgraded all transforms, (updated: [{}], no action [{}])", (Object)updated, (Object)noAction);
                    listener.onResponse((Object)new UpgradeTransformsAction.Response(updated, noAction, needsUpdate));
                }, arg_0 -> ((ActionListener)listener).onFailure(arg_0)));
            } else {
                listener.onResponse((Object)new UpgradeTransformsAction.Response(updated, noAction, needsUpdate));
            }
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    protected ClusterBlockException checkBlock(UpgradeTransformsAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }

    private void updateOneTransform(String id, boolean dryRun, TimeValue timeout, ActionListener<TransformUpdater.UpdateResult> listener) {
        ClusterState clusterState = this.clusterService.state();
        this.transformConfigManager.getTransformConfigurationForUpdate(id, (ActionListener<Tuple<TransformConfig, SeqNoPrimaryTermAndIndex>>)ActionListener.wrap(configAndVersion -> {
            TransformConfigUpdate update = TransformConfigUpdate.EMPTY;
            TransformConfig config = (TransformConfig)configAndVersion.v1();
            update.setHeaders(config.getHeaders());
            TransformUpdater.updateTransform(this.securityContext, this.indexNameExpressionResolver, clusterState, this.settings, this.client, this.transformConfigManager, this.auditor, config, update, (SeqNoPrimaryTermAndIndex)configAndVersion.v2(), false, dryRun, false, timeout, listener);
        }, failure -> {
            if (failure instanceof ResourceNotFoundException) {
                listener.onResponse((Object)new TransformUpdater.UpdateResult(null, null, TransformUpdater.UpdateResult.Status.DELETED));
            } else {
                listener.onFailure(failure);
            }
        }));
    }

    private void recursiveUpdate(Deque<String> transformsToUpgrade, Map<TransformUpdater.UpdateResult.Status, Long> updatesByStatus, boolean dryRun, TimeValue timeout, ActionListener<Void> listener) {
        String next = transformsToUpgrade.pollFirst();
        if (next == null) {
            listener.onResponse(null);
            return;
        }
        this.updateOneTransform(next, dryRun, timeout, (ActionListener<TransformUpdater.UpdateResult>)ActionListener.wrap(updateResponse -> {
            if (!TransformUpdater.UpdateResult.Status.DELETED.equals((Object)updateResponse.getStatus())) {
                this.auditor.info(next, "Updated transform.");
                logger.debug("[{}] Updated transform [{}]", (Object)next, (Object)updateResponse.getStatus());
                updatesByStatus.compute(updateResponse.getStatus(), (k, v) -> v == null ? 1L : v + 1L);
            }
            if (!transformsToUpgrade.isEmpty()) {
                this.recursiveUpdate(transformsToUpgrade, updatesByStatus, dryRun, timeout, listener);
            } else {
                listener.onResponse(null);
            }
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    private void recursiveExpandTransformIdsAndUpgrade(boolean dryRun, TimeValue timeout, ActionListener<Map<TransformUpdater.UpdateResult.Status, Long>> listener) {
        this.transformConfigManager.getAllOutdatedTransformIds(timeout, (ActionListener<Tuple<Long, Set<String>>>)ActionListener.wrap(totalAndIds -> {
            if (((Set)totalAndIds.v2()).isEmpty()) {
                listener.onResponse(Collections.singletonMap(TransformUpdater.UpdateResult.Status.NONE, (Long)totalAndIds.v1()));
                return;
            }
            HashMap<TransformUpdater.UpdateResult.Status, Long> updatesByStatus = new HashMap<TransformUpdater.UpdateResult.Status, Long>();
            updatesByStatus.put(TransformUpdater.UpdateResult.Status.NONE, (Long)totalAndIds.v1() - (long)((Set)totalAndIds.v2()).size());
            ArrayDeque<String> ids = new ArrayDeque<String>((Collection)totalAndIds.v2());
            this.recursiveUpdate(ids, updatesByStatus, dryRun, timeout, (ActionListener<Void>)ActionListener.wrap(r -> listener.onResponse((Object)updatesByStatus), arg_0 -> ((ActionListener)listener).onFailure(arg_0)));
        }, arg_0 -> listener.onFailure(arg_0)));
    }
}

