/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.transform.action;

import java.util.function.Consumer;
import java.util.function.Predicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.health.HealthStatus;
import org.elasticsearch.persistent.PersistentTaskParams;
import org.elasticsearch.persistent.PersistentTasksCustomMetadata;
import org.elasticsearch.persistent.PersistentTasksService;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.transform.TransformMessages;
import org.elasticsearch.xpack.core.transform.action.StartTransformAction;
import org.elasticsearch.xpack.core.transform.action.ValidateTransformAction;
import org.elasticsearch.xpack.core.transform.transforms.AuthorizationState;
import org.elasticsearch.xpack.core.transform.transforms.TransformConfig;
import org.elasticsearch.xpack.core.transform.transforms.TransformState;
import org.elasticsearch.xpack.core.transform.transforms.TransformTaskParams;
import org.elasticsearch.xpack.core.transform.transforms.TransformTaskState;
import org.elasticsearch.xpack.transform.TransformServices;
import org.elasticsearch.xpack.transform.notifications.TransformAuditor;
import org.elasticsearch.xpack.transform.persistence.AuthorizationStatePersistenceUtils;
import org.elasticsearch.xpack.transform.persistence.TransformConfigManager;
import org.elasticsearch.xpack.transform.persistence.TransformIndex;
import org.elasticsearch.xpack.transform.transforms.TransformNodes;
import org.elasticsearch.xpack.transform.transforms.TransformTask;

public class TransportStartTransformAction
extends TransportMasterNodeAction<StartTransformAction.Request, StartTransformAction.Response> {
    private static final Logger logger = LogManager.getLogger(TransportStartTransformAction.class);
    private final TransformConfigManager transformConfigManager;
    private final PersistentTasksService persistentTasksService;
    private final Client client;
    private final TransformAuditor auditor;

    @Inject
    public TransportStartTransformAction(TransportService transportService, ActionFilters actionFilters, ClusterService clusterService, ThreadPool threadPool, IndexNameExpressionResolver indexNameExpressionResolver, TransformServices transformServices, PersistentTasksService persistentTasksService, Client client) {
        this("cluster:admin/transform/start", transportService, actionFilters, clusterService, threadPool, indexNameExpressionResolver, transformServices, persistentTasksService, client);
    }

    protected TransportStartTransformAction(String name, TransportService transportService, ActionFilters actionFilters, ClusterService clusterService, ThreadPool threadPool, IndexNameExpressionResolver indexNameExpressionResolver, TransformServices transformServices, PersistentTasksService persistentTasksService, Client client) {
        super(name, transportService, clusterService, threadPool, actionFilters, StartTransformAction.Request::new, indexNameExpressionResolver, StartTransformAction.Response::new, "same");
        this.transformConfigManager = transformServices.getConfigManager();
        this.persistentTasksService = persistentTasksService;
        this.client = client;
        this.auditor = transformServices.getAuditor();
    }

    protected void masterOperation(Task ignoredTask, StartTransformAction.Request request, ClusterState state, ActionListener<StartTransformAction.Response> listener) {
        TransformNodes.warnIfNoTransformNodes(state);
        SetOnce transformTaskParamsHolder = new SetOnce();
        SetOnce transformConfigHolder = new SetOnce();
        ActionListener newPersistentTaskActionListener = ActionListener.wrap(task -> {
            TransformTaskParams transformTask = (TransformTaskParams)transformTaskParamsHolder.get();
            assert (transformTask != null);
            this.waitForTransformTaskStarted(task.getId(), transformTask, request.timeout(), (ActionListener<Boolean>)ActionListener.wrap(taskStarted -> listener.onResponse((Object)new StartTransformAction.Response(true)), arg_0 -> ((ActionListener)listener).onFailure(arg_0)));
        }, arg_0 -> listener.onFailure(arg_0));
        ActionListener createOrGetIndexListener = ActionListener.wrap(unused -> {
            TransformTaskParams transformTask = (TransformTaskParams)transformTaskParamsHolder.get();
            assert (transformTask != null);
            PersistentTasksCustomMetadata.PersistentTask<?> existingTask = TransformTask.getTransformTask(transformTask.getId(), state);
            if (existingTask == null) {
                this.persistentTasksService.sendStartRequest(transformTask.getId(), "data_frame/transforms", (PersistentTaskParams)transformTask, newPersistentTaskActionListener);
            } else {
                TransformState transformState = (TransformState)existingTask.getState();
                if (transformState.getTaskState() == TransformTaskState.FAILED) {
                    listener.onFailure((Exception)new ElasticsearchStatusException(TransformMessages.getMessage((String)"Unable to start transform [{0}] as it is in a failed state with failure: [{1}]. Use force stop and then restart the transform once error is resolved.", (Object[])new Object[]{request.getId(), transformState.getReason()}), RestStatus.CONFLICT, new Object[0]));
                } else {
                    listener.onFailure((Exception)new ElasticsearchStatusException("Cannot start transform [{}] as it is already started.", RestStatus.CONFLICT, new Object[]{request.getId()}));
                }
            }
        }, arg_0 -> listener.onFailure(arg_0));
        ActionListener validationListener = ActionListener.wrap(validationResponse -> {
            if (Boolean.TRUE.equals(((TransformConfig)transformConfigHolder.get()).getSettings().getUnattended())) {
                logger.debug(() -> Strings.format((String)"[%s] Skip dest index creation as this is an unattended transform", (Object[])new Object[]{((TransformConfig)transformConfigHolder.get()).getId()}));
                createOrGetIndexListener.onResponse((Object)true);
                return;
            }
            TransformIndex.createDestinationIndex(this.client, this.auditor, this.indexNameExpressionResolver, state, (TransformConfig)transformConfigHolder.get(), validationResponse.getDestIndexMappings(), (ActionListener<Boolean>)createOrGetIndexListener);
        }, e -> {
            if (Boolean.TRUE.equals(((TransformConfig)transformConfigHolder.get()).getSettings().getUnattended())) {
                logger.debug(() -> Strings.format((String)"[%s] Skip dest index creation as this is an unattended transform", (Object[])new Object[]{((TransformConfig)transformConfigHolder.get()).getId()}));
                createOrGetIndexListener.onResponse((Object)true);
                return;
            }
            listener.onFailure(e);
        });
        ActionListener fetchAuthStateListener = ActionListener.wrap(authState -> {
            if (authState != null && HealthStatus.RED.equals((Object)authState.getStatus())) {
                listener.onFailure((Exception)new ElasticsearchSecurityException(authState.getLastAuthError(), RestStatus.FORBIDDEN, new Object[0]));
                return;
            }
            TransformConfig config = (TransformConfig)transformConfigHolder.get();
            ActionRequestValidationException validationException = config.validate(null);
            if (request.from() != null && config.getSyncConfig() == null) {
                validationException = ValidateActions.addValidationError((String)"[from] parameter is currently not supported for batch (non-continuous) transforms", (ActionRequestValidationException)validationException);
            }
            if (validationException != null) {
                listener.onFailure((Exception)new ElasticsearchStatusException(TransformMessages.getMessage((String)"Transform configuration [{0}] has invalid elements: [{1}]", (Object[])new Object[]{request.getId(), validationException.getMessage()}), RestStatus.BAD_REQUEST, new Object[0]));
                return;
            }
            transformTaskParamsHolder.set((Object)new TransformTaskParams(config.getId(), config.getVersion(), request.from(), config.getFrequency(), config.getSource().requiresRemoteCluster()));
            ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"transform", (ActionType)ValidateTransformAction.INSTANCE, (ActionRequest)new ValidateTransformAction.Request(config, false, request.timeout()), (ActionListener)validationListener);
        }, arg_0 -> listener.onFailure(arg_0));
        ActionListener getTransformListener = ActionListener.wrap(config -> {
            transformConfigHolder.set(config);
            if (Boolean.TRUE.equals(config.getSettings().getUnattended())) {
                fetchAuthStateListener.onResponse(null);
            } else {
                AuthorizationStatePersistenceUtils.fetchAuthState(this.transformConfigManager, request.getId(), (ActionListener<AuthorizationState>)fetchAuthStateListener);
            }
        }, arg_0 -> listener.onFailure(arg_0));
        this.transformConfigManager.getTransformConfiguration(request.getId(), (ActionListener<TransformConfig>)getTransformListener);
    }

    protected ClusterBlockException checkBlock(StartTransformAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }

    private void cancelTransformTask(String taskId, final String transformId, final Exception exception, final Consumer<Exception> onFailure) {
        this.persistentTasksService.sendRemoveRequest(taskId, new ActionListener<PersistentTasksCustomMetadata.PersistentTask<?>>(){

            public void onResponse(PersistentTasksCustomMetadata.PersistentTask<?> task) {
                onFailure.accept(exception);
            }

            public void onFailure(Exception e) {
                logger.error("[" + transformId + "] Failed to cancel persistent task that could not be assigned due to [" + exception.getMessage() + "]", (Throwable)e);
                onFailure.accept(exception);
            }
        });
    }

    private void waitForTransformTaskStarted(final String taskId, final TransformTaskParams params, TimeValue timeout, final ActionListener<Boolean> listener) {
        final TransformPredicate predicate = new TransformPredicate();
        this.persistentTasksService.waitForPersistentTaskCondition(taskId, (Predicate)predicate, timeout, (PersistentTasksService.WaitForPersistentTaskListener)new PersistentTasksService.WaitForPersistentTaskListener<TransformTaskParams>(){

            public void onResponse(PersistentTasksCustomMetadata.PersistentTask<TransformTaskParams> persistentTask) {
                if (predicate.exception != null) {
                    TransportStartTransformAction.this.cancelTransformTask(taskId, params.getId(), predicate.exception, arg_0 -> ((ActionListener)listener).onFailure(arg_0));
                } else {
                    listener.onResponse((Object)true);
                }
            }

            public void onFailure(Exception e) {
                listener.onFailure(e);
            }

            public void onTimeout(TimeValue timeout) {
                listener.onFailure((Exception)new ElasticsearchStatusException("Starting transform [{}] timed out after [{}]", RestStatus.REQUEST_TIMEOUT, new Object[]{params.getId(), timeout}));
            }
        });
    }

    private static class TransformPredicate
    implements Predicate<PersistentTasksCustomMetadata.PersistentTask<?>> {
        private volatile Exception exception;

        private TransformPredicate() {
        }

        @Override
        public boolean test(PersistentTasksCustomMetadata.PersistentTask<?> persistentTask) {
            if (persistentTask == null) {
                return false;
            }
            PersistentTasksCustomMetadata.Assignment assignment = persistentTask.getAssignment();
            if (assignment != null && !assignment.equals((Object)PersistentTasksCustomMetadata.INITIAL_ASSIGNMENT) && !assignment.isAssigned()) {
                this.exception = new ElasticsearchStatusException("Could not start transform, allocation explanation [" + assignment.getExplanation() + "]", RestStatus.TOO_MANY_REQUESTS, new Object[0]);
                return true;
            }
            return assignment != null && assignment.isAssigned() && this.isNotStopped(persistentTask);
        }

        private boolean isNotStopped(PersistentTasksCustomMetadata.PersistentTask<?> task) {
            TransformState state = (TransformState)task.getState();
            return state != null && !state.getTaskState().equals((Object)TransformTaskState.STOPPED);
        }
    }
}

