/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.transform.action;

import java.time.Instant;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ResourceAlreadyExistsException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.AcknowledgedTransportMasterNodeAction;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.Strings;
import org.elasticsearch.persistent.PersistentTasksCustomMetadata;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.XPackPlugin;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.security.SecurityContext;
import org.elasticsearch.xpack.core.transform.TransformConfigVersion;
import org.elasticsearch.xpack.core.transform.TransformMessages;
import org.elasticsearch.xpack.core.transform.action.PutTransformAction;
import org.elasticsearch.xpack.core.transform.action.ValidateTransformAction;
import org.elasticsearch.xpack.core.transform.transforms.AuthorizationState;
import org.elasticsearch.xpack.core.transform.transforms.TransformConfig;
import org.elasticsearch.xpack.transform.TransformServices;
import org.elasticsearch.xpack.transform.action.TransformConfigLinter;
import org.elasticsearch.xpack.transform.action.TransformPrivilegeChecker;
import org.elasticsearch.xpack.transform.notifications.TransformAuditor;
import org.elasticsearch.xpack.transform.persistence.AuthorizationStatePersistenceUtils;
import org.elasticsearch.xpack.transform.persistence.TransformConfigManager;
import org.elasticsearch.xpack.transform.transforms.Function;
import org.elasticsearch.xpack.transform.transforms.FunctionFactory;
import org.elasticsearch.xpack.transform.utils.SecondaryAuthorizationUtils;

public class TransportPutTransformAction
extends AcknowledgedTransportMasterNodeAction<PutTransformAction.Request> {
    private static final Logger logger = LogManager.getLogger(TransportPutTransformAction.class);
    private final Settings settings;
    private final Client client;
    private final TransformConfigManager transformConfigManager;
    private final SecurityContext securityContext;
    private final TransformAuditor auditor;

    @Inject
    public TransportPutTransformAction(Settings settings, TransportService transportService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, ClusterService clusterService, TransformServices transformServices, Client client) {
        super("cluster:admin/transform/put", transportService, clusterService, threadPool, actionFilters, PutTransformAction.Request::new, indexNameExpressionResolver, "same");
        this.settings = settings;
        this.client = client;
        this.transformConfigManager = transformServices.getConfigManager();
        this.securityContext = (Boolean)XPackSettings.SECURITY_ENABLED.get(settings) != false ? new SecurityContext(settings, threadPool.getThreadContext()) : null;
        this.auditor = transformServices.getAuditor();
    }

    protected void masterOperation(Task task, PutTransformAction.Request request, ClusterState clusterState, ActionListener<AcknowledgedResponse> listener) {
        XPackPlugin.checkReadyForXPackCustomMetadata((ClusterState)clusterState);
        TransformConfig config = request.getConfig().setCreateTime(Instant.now()).setVersion(TransformConfigVersion.CURRENT);
        config.setHeaders(SecondaryAuthorizationUtils.getSecurityHeadersPreferringSecondary(this.threadPool, this.securityContext, clusterState));
        String transformId = config.getId();
        if (PersistentTasksCustomMetadata.getTaskWithId((ClusterState)clusterState, (String)transformId) != null) {
            listener.onFailure((Exception)new ResourceAlreadyExistsException(TransformMessages.getMessage((String)"Transform with id [{0}] already exists", (Object[])new Object[]{transformId}), new Object[0]));
            return;
        }
        ActionListener validateTransformListener = ActionListener.wrap(validationResponse -> this.putTransform(request, listener), arg_0 -> listener.onFailure(arg_0));
        ActionListener checkPrivilegesListener = ActionListener.wrap(aVoid -> ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"transform", (ActionType)ValidateTransformAction.INSTANCE, (ActionRequest)new ValidateTransformAction.Request(config, request.isDeferValidation(), request.timeout()), (ActionListener)validateTransformListener), arg_0 -> listener.onFailure(arg_0));
        if (((Boolean)XPackSettings.SECURITY_ENABLED.get(this.settings)).booleanValue()) {
            TransformPrivilegeChecker.checkPrivileges("create", this.settings, this.securityContext, this.indexNameExpressionResolver, clusterState, this.client, config, true, (ActionListener<Void>)ActionListener.wrap(aVoid -> AuthorizationStatePersistenceUtils.persistAuthState(this.settings, this.transformConfigManager, transformId, AuthorizationState.green(), (ActionListener<Void>)checkPrivilegesListener), e -> {
                if (request.isDeferValidation()) {
                    AuthorizationStatePersistenceUtils.persistAuthState(this.settings, this.transformConfigManager, transformId, AuthorizationState.red((Exception)e), (ActionListener<Void>)checkPrivilegesListener);
                } else {
                    checkPrivilegesListener.onFailure(e);
                }
            }));
        } else {
            checkPrivilegesListener.onResponse(null);
        }
    }

    protected ClusterBlockException checkBlock(PutTransformAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }

    private void putTransform(PutTransformAction.Request request, ActionListener<AcknowledgedResponse> listener) {
        TransformConfig config = request.getConfig();
        Function function = FunctionFactory.create(config);
        ActionListener putTransformConfigurationListener = ActionListener.wrap(putTransformConfigurationResult -> {
            logger.debug("[{}] created transform", (Object)config.getId());
            this.auditor.info(config.getId(), "Created transform.");
            List<String> warnings = TransformConfigLinter.getWarnings(function, config.getSource(), config.getSyncConfig());
            for (String warning : warnings) {
                logger.warn(() -> Strings.format((String)"[%s] %s", (Object[])new Object[]{config.getId(), warning}));
                this.auditor.warning(config.getId(), warning);
            }
            listener.onResponse((Object)AcknowledgedResponse.TRUE);
        }, arg_0 -> listener.onFailure(arg_0));
        this.transformConfigManager.putTransformConfiguration(config, (ActionListener<Boolean>)putTransformConfigurationListener);
    }
}

