/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.transform.action;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionListenerResponseHandler;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.NoShardAvailableActionException;
import org.elasticsearch.action.OriginalIndices;
import org.elasticsearch.action.UnavailableShardsException;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.GroupedActionListener;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.ShardsIterator;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.ActionNotFoundTransportException;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportResponseHandler;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.transform.action.GetCheckpointAction;
import org.elasticsearch.xpack.core.transform.action.GetCheckpointNodeAction;
import org.elasticsearch.xpack.transform.action.TransportGetCheckpointNodeAction;

public class TransportGetCheckpointAction
extends HandledTransportAction<GetCheckpointAction.Request, GetCheckpointAction.Response> {
    private static final Logger logger = LogManager.getLogger(TransportGetCheckpointAction.class);
    private final ClusterService clusterService;
    private final IndicesService indicesService;
    private final TransportService transportService;
    private final IndexNameExpressionResolver indexNameExpressionResolver;

    @Inject
    public TransportGetCheckpointAction(TransportService transportService, ActionFilters actionFilters, IndicesService indicesService, ClusterService clusterService, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("indices:monitor/transform/checkpoint", transportService, actionFilters, GetCheckpointAction.Request::new);
        this.transportService = transportService;
        this.indicesService = indicesService;
        this.clusterService = clusterService;
        this.indexNameExpressionResolver = indexNameExpressionResolver;
    }

    protected void doExecute(Task task, GetCheckpointAction.Request request, ActionListener<GetCheckpointAction.Response> listener) {
        ClusterState state = this.clusterService.state();
        this.resolveIndicesAndGetCheckpoint(task, request, listener, state);
    }

    protected void resolveIndicesAndGetCheckpoint(Task task, GetCheckpointAction.Request request, ActionListener<GetCheckpointAction.Response> listener, ClusterState state) {
        String[] concreteIndices = this.indexNameExpressionResolver.concreteIndexNames(state, (IndicesRequest)request);
        Map<String, Set<ShardId>> nodesAndShards = this.resolveIndicesToPrimaryShards(state, concreteIndices);
        if (nodesAndShards.size() == 0) {
            listener.onResponse((Object)new GetCheckpointAction.Response(Collections.emptyMap()));
            return;
        }
        new AsyncGetCheckpointsFromNodesAction(state, task, nodesAndShards, new OriginalIndices((IndicesRequest)request), listener).start();
    }

    private Map<String, Set<ShardId>> resolveIndicesToPrimaryShards(ClusterState state, String[] concreteIndices) {
        if (concreteIndices.length == 0) {
            return Collections.emptyMap();
        }
        DiscoveryNodes nodes = state.nodes();
        HashMap<String, Set<ShardId>> nodesAndShards = new HashMap<String, Set<ShardId>>();
        ShardsIterator shardsIt = state.routingTable().allShards(concreteIndices);
        for (ShardRouting shard : shardsIt) {
            if (!shard.primary()) continue;
            if (shard.assignedToNode() && nodes.get(shard.currentNodeId()) != null) {
                if (state.getMinTransportVersion().before((VersionId)TransportVersion.V_8_2_0)) {
                    throw new ActionNotFoundTransportException("indices:monitor/transform/checkpoint[n]");
                }
                String nodeId = shard.currentNodeId();
                nodesAndShards.computeIfAbsent(nodeId, k -> new HashSet()).add(shard.shardId());
                continue;
            }
            throw new NoShardAvailableActionException(shard.shardId(), " no primary shards available for shard [" + shard + "]");
        }
        return nodesAndShards;
    }

    protected class AsyncGetCheckpointsFromNodesAction {
        private final Task task;
        private final ActionListener<GetCheckpointAction.Response> listener;
        private final Map<String, Set<ShardId>> nodesAndShards;
        private final OriginalIndices originalIndices;
        private final DiscoveryNodes nodes;
        private final String localNodeId;

        protected AsyncGetCheckpointsFromNodesAction(ClusterState clusterState, Task task, Map<String, Set<ShardId>> nodesAndShards, OriginalIndices originalIndices, ActionListener<GetCheckpointAction.Response> listener) {
            this.task = task;
            this.listener = listener;
            this.nodesAndShards = nodesAndShards;
            this.originalIndices = originalIndices;
            this.nodes = clusterState.nodes();
            this.localNodeId = TransportGetCheckpointAction.this.clusterService.localNode().getId();
        }

        public void start() {
            GroupedActionListener groupedListener = new GroupedActionListener(this.nodesAndShards.size(), ActionListener.wrap(responses -> {
                TreeMap checkpointsByIndexReduced = new TreeMap();
                for (GetCheckpointNodeAction.Response response : responses) {
                    response.getCheckpoints().forEach((index, checkpoint) -> {
                        if (checkpointsByIndexReduced.containsKey(index)) {
                            long[] shardCheckpoints = (long[])checkpointsByIndexReduced.get(index);
                            for (int i = 0; i < ((long[])checkpoint).length; ++i) {
                                shardCheckpoints[i] = Math.max(shardCheckpoints[i], checkpoint[i]);
                            }
                        } else {
                            checkpointsByIndexReduced.put(index, checkpoint);
                        }
                    });
                }
                this.listener.onResponse((Object)new GetCheckpointAction.Response(checkpointsByIndexReduced));
            }, arg_0 -> this.listener.onFailure(arg_0)));
            for (Map.Entry<String, Set<ShardId>> oneNodeAndItsShards : this.nodesAndShards.entrySet()) {
                if (this.localNodeId.equals(oneNodeAndItsShards.getKey())) {
                    TransportGetCheckpointNodeAction.getGlobalCheckpoints(TransportGetCheckpointAction.this.indicesService, oneNodeAndItsShards.getValue(), (ActionListener<GetCheckpointNodeAction.Response>)groupedListener);
                    continue;
                }
                GetCheckpointNodeAction.Request nodeCheckpointsRequest = new GetCheckpointNodeAction.Request(oneNodeAndItsShards.getValue(), this.originalIndices);
                DiscoveryNode node = this.nodes.get(oneNodeAndItsShards.getKey());
                if (node == null) {
                    this.listener.onFailure((Exception)new UnavailableShardsException(oneNodeAndItsShards.getValue().iterator().next(), "Node not found for [{}] shards", new Object[]{oneNodeAndItsShards.getValue().size()}));
                    return;
                }
                logger.trace("get checkpoints from node {}", (Object)node);
                TransportGetCheckpointAction.this.transportService.sendChildRequest(node, "indices:monitor/transform/checkpoint[n]", (TransportRequest)nodeCheckpointsRequest, this.task, TransportRequestOptions.EMPTY, (TransportResponseHandler)new ActionListenerResponseHandler((ActionListener)groupedListener, GetCheckpointNodeAction.Response::new, TransportResponseHandler.TRANSPORT_WORKER));
            }
        }
    }
}

