/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.transform.action;

import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexAction;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.AcknowledgedTransportMasterNodeAction;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.transform.action.DeleteTransformAction;
import org.elasticsearch.xpack.core.transform.action.StopTransformAction;
import org.elasticsearch.xpack.core.transform.transforms.TransformConfig;
import org.elasticsearch.xpack.transform.TransformServices;
import org.elasticsearch.xpack.transform.notifications.TransformAuditor;
import org.elasticsearch.xpack.transform.persistence.SeqNoPrimaryTermAndIndex;
import org.elasticsearch.xpack.transform.persistence.TransformConfigManager;
import org.elasticsearch.xpack.transform.transforms.TransformTask;

public class TransportDeleteTransformAction
extends AcknowledgedTransportMasterNodeAction<DeleteTransformAction.Request> {
    private static final Logger logger = LogManager.getLogger(TransportDeleteTransformAction.class);
    private final TransformConfigManager transformConfigManager;
    private final TransformAuditor auditor;
    private final Client client;

    @Inject
    public TransportDeleteTransformAction(TransportService transportService, ActionFilters actionFilters, ThreadPool threadPool, ClusterService clusterService, IndexNameExpressionResolver indexNameExpressionResolver, TransformServices transformServices, Client client) {
        super("cluster:admin/transform/delete", transportService, clusterService, threadPool, actionFilters, DeleteTransformAction.Request::new, indexNameExpressionResolver, "same");
        this.transformConfigManager = transformServices.getConfigManager();
        this.auditor = transformServices.getAuditor();
        this.client = client;
    }

    protected void masterOperation(Task task, DeleteTransformAction.Request request, ClusterState state, ActionListener<AcknowledgedResponse> listener) {
        boolean transformIsRunning;
        TaskId parentTaskId = new TaskId(this.clusterService.localNode().getId(), task.getId());
        boolean bl = transformIsRunning = TransformTask.getTransformTask(request.getId(), state) != null;
        if (transformIsRunning && !request.isForce()) {
            listener.onFailure((Exception)new ElasticsearchStatusException("Cannot delete transform [" + request.getId() + "] as the task is running. Stop the task first", RestStatus.CONFLICT, new Object[0]));
            return;
        }
        ActionListener deleteDestIndexListener = ActionListener.wrap(unusedAcknowledgedResponse -> this.transformConfigManager.deleteTransform(request.getId(), (ActionListener<Boolean>)ActionListener.wrap(r -> {
            logger.debug("[{}] deleted transform", (Object)request.getId());
            this.auditor.info(request.getId(), "Deleted transform.");
            listener.onResponse((Object)AcknowledgedResponse.of((boolean)r));
        }, arg_0 -> ((ActionListener)listener).onFailure(arg_0))), arg_0 -> listener.onFailure(arg_0));
        ActionListener stopTransformActionListener = ActionListener.wrap(unusedStopResponse -> {
            if (request.isDeleteDestIndex()) {
                this.deleteDestinationIndex(parentTaskId, request.getId(), request.timeout(), (ActionListener<AcknowledgedResponse>)deleteDestIndexListener);
            } else {
                deleteDestIndexListener.onResponse(null);
            }
        }, arg_0 -> listener.onFailure(arg_0));
        this.stopTransform(transformIsRunning, parentTaskId, request.getId(), request.timeout(), (ActionListener<StopTransformAction.Response>)stopTransformActionListener);
    }

    private void stopTransform(boolean transformIsRunning, TaskId parentTaskId, String transformId, TimeValue timeout, ActionListener<StopTransformAction.Response> listener) {
        if (!transformIsRunning) {
            listener.onResponse(null);
            return;
        }
        StopTransformAction.Request stopTransformRequest = new StopTransformAction.Request(transformId, true, true, timeout, true, false);
        stopTransformRequest.setParentTask(parentTaskId);
        ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"transform", (ActionType)StopTransformAction.INSTANCE, (ActionRequest)stopTransformRequest, listener);
    }

    private void deleteDestinationIndex(TaskId parentTaskId, String transformId, TimeValue timeout, ActionListener<AcknowledgedResponse> listener) {
        ActionListener deleteDestIndexListener = ActionListener.wrap(arg_0 -> listener.onResponse(arg_0), e -> {
            if (e instanceof IndexNotFoundException) {
                listener.onResponse((Object)AcknowledgedResponse.TRUE);
            } else {
                listener.onFailure(e);
            }
        });
        ActionListener getTransformConfigurationListener = ActionListener.wrap(transformConfigAndVersion -> {
            TransformConfig config = (TransformConfig)transformConfigAndVersion.v1();
            String destIndex = config.getDestination().getIndex();
            DeleteIndexRequest deleteDestIndexRequest = new DeleteIndexRequest(destIndex);
            deleteDestIndexRequest.timeout(timeout);
            deleteDestIndexRequest.setParentTask(parentTaskId);
            ClientHelper.executeWithHeadersAsync((Map)config.getHeaders(), (String)"transform", (Client)this.client, (ActionType)DeleteIndexAction.INSTANCE, (ActionRequest)deleteDestIndexRequest, (ActionListener)deleteDestIndexListener);
        }, arg_0 -> listener.onFailure(arg_0));
        this.transformConfigManager.getTransformConfigurationForUpdate(transformId, (ActionListener<Tuple<TransformConfig, SeqNoPrimaryTermAndIndex>>)getTransformConfigurationListener);
    }

    protected ClusterBlockException checkBlock(DeleteTransformAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
    }
}

