/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.spatial.search.aggregations.support;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.index.fielddata.MultiGeoPointValues;
import org.elasticsearch.index.fielddata.SortedNumericDoubleValues;
import org.elasticsearch.search.aggregations.AggregationExecutionException;
import org.elasticsearch.search.aggregations.support.MultiValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;

public class GeoLineMultiValuesSource
extends MultiValuesSource<ValuesSource> {
    public GeoLineMultiValuesSource(Map<String, ValuesSourceConfig> valuesSourceConfigs) {
        this.values = Maps.newMapWithExpectedSize((int)valuesSourceConfigs.size());
        for (Map.Entry<String, ValuesSourceConfig> entry : valuesSourceConfigs.entrySet()) {
            ValuesSource valuesSource = entry.getValue().getValuesSource();
            if (!(valuesSource instanceof ValuesSource.Numeric) && !(valuesSource instanceof ValuesSource.GeoPoint)) {
                throw new AggregationExecutionException("ValuesSource type " + valuesSource.toString() + "is not supported for multi-valued aggregation");
            }
            this.values.put(entry.getKey(), valuesSource);
        }
    }

    private ValuesSource getField(String fieldName) {
        ValuesSource valuesSource = (ValuesSource)this.values.get(fieldName);
        if (valuesSource == null) {
            throw new IllegalArgumentException("Could not find field name [" + fieldName + "] in multiValuesSource");
        }
        return valuesSource;
    }

    public SortedNumericDoubleValues getNumericField(String fieldName, LeafReaderContext ctx) throws IOException {
        ValuesSource valuesSource = this.getField(fieldName);
        if (valuesSource instanceof ValuesSource.Numeric) {
            return ((ValuesSource.Numeric)valuesSource).doubleValues(ctx);
        }
        throw new IllegalArgumentException("field [" + fieldName + "] is not a numeric type");
    }

    public MultiGeoPointValues getGeoPointField(String fieldName, LeafReaderContext ctx) {
        ValuesSource valuesSource = this.getField(fieldName);
        if (valuesSource instanceof ValuesSource.GeoPoint) {
            return ((ValuesSource.GeoPoint)valuesSource).geoPointValues(ctx);
        }
        throw new IllegalArgumentException("field [" + fieldName + "] is not a geo_point type");
    }
}

