/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.spatial.index.query;

import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.document.ShapeField;
import org.apache.lucene.document.XYShape;
import org.apache.lucene.geo.XYGeometry;
import org.apache.lucene.search.IndexOrDocValuesQuery;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.geo.ShapeRelation;
import org.elasticsearch.geometry.Circle;
import org.elasticsearch.geometry.Geometry;
import org.elasticsearch.geometry.GeometryCollection;
import org.elasticsearch.geometry.GeometryVisitor;
import org.elasticsearch.geometry.Line;
import org.elasticsearch.geometry.LinearRing;
import org.elasticsearch.geometry.MultiLine;
import org.elasticsearch.geometry.MultiPoint;
import org.elasticsearch.geometry.MultiPolygon;
import org.elasticsearch.geometry.Point;
import org.elasticsearch.geometry.Polygon;
import org.elasticsearch.geometry.Rectangle;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.query.QueryRewriteContext;
import org.elasticsearch.index.query.QueryShardException;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.xpack.spatial.common.ShapeUtils;
import org.elasticsearch.xpack.spatial.index.mapper.CartesianShapeDocValuesQuery;
import org.elasticsearch.xpack.spatial.index.mapper.ShapeFieldMapper;

public class ShapeQueryProcessor {
    public Query shapeQuery(Geometry shape, String fieldName, ShapeRelation relation, SearchExecutionContext context, boolean hasDocValues) {
        this.validateIsShapeFieldType(fieldName, context);
        if (relation == ShapeRelation.CONTAINS && context.indexVersionCreated().before((VersionId)IndexVersion.V_7_5_0)) {
            throw new QueryShardException((QueryRewriteContext)context, ShapeRelation.CONTAINS + " query relation not supported for Field [" + fieldName + "].", new Object[0]);
        }
        if (shape == null) {
            return new MatchNoDocsQuery();
        }
        return this.getVectorQueryFromShape(shape, fieldName, relation, context, hasDocValues);
    }

    private void validateIsShapeFieldType(String fieldName, SearchExecutionContext context) {
        MappedFieldType fieldType = context.getFieldType(fieldName);
        if (!(fieldType instanceof ShapeFieldMapper.ShapeFieldType)) {
            throw new QueryShardException((QueryRewriteContext)context, "Expected shape field type for Field [" + fieldName + "] but found " + fieldType.typeName(), new Object[0]);
        }
    }

    private Query getVectorQueryFromShape(Geometry queryShape, String fieldName, ShapeRelation relation, SearchExecutionContext context, boolean hasDocValues) {
        LuceneGeometryCollector visitor = new LuceneGeometryCollector(fieldName, context);
        queryShape.visit((GeometryVisitor)visitor);
        List<XYGeometry> geomList = visitor.geometries();
        if (geomList.size() == 0) {
            return new MatchNoDocsQuery();
        }
        XYGeometry[] geometries = geomList.toArray(new XYGeometry[0]);
        Query query = XYShape.newGeometryQuery((String)fieldName, (ShapeField.QueryRelation)relation.getLuceneRelation(), (XYGeometry[])geometries);
        if (hasDocValues) {
            CartesianShapeDocValuesQuery queryDocValues = new CartesianShapeDocValuesQuery(fieldName, relation.getLuceneRelation(), geometries);
            query = new IndexOrDocValuesQuery(query, (Query)queryDocValues);
        }
        return query;
    }

    private static class LuceneGeometryCollector
    implements GeometryVisitor<Void, RuntimeException> {
        private final List<XYGeometry> geometries = new ArrayList<XYGeometry>();
        private final String name;
        private final SearchExecutionContext context;

        private LuceneGeometryCollector(String name, SearchExecutionContext context) {
            this.name = name;
            this.context = context;
        }

        List<XYGeometry> geometries() {
            return this.geometries;
        }

        public Void visit(Circle circle) {
            if (!circle.isEmpty()) {
                this.geometries.add((XYGeometry)ShapeUtils.toLuceneXYCircle(circle));
            }
            return null;
        }

        public Void visit(GeometryCollection<?> collection) {
            for (Geometry shape : collection) {
                shape.visit((GeometryVisitor)this);
            }
            return null;
        }

        public Void visit(Line line) {
            if (!line.isEmpty()) {
                this.geometries.add((XYGeometry)ShapeUtils.toLuceneXYLine(line));
            }
            return null;
        }

        public Void visit(LinearRing ring) {
            throw new QueryShardException((QueryRewriteContext)this.context, "Field [" + this.name + "] found and unsupported shape LinearRing", new Object[0]);
        }

        public Void visit(MultiLine multiLine) {
            for (Line line : multiLine) {
                this.visit(line);
            }
            return null;
        }

        public Void visit(MultiPoint multiPoint) {
            for (Point point : multiPoint) {
                this.visit(point);
            }
            return null;
        }

        public Void visit(MultiPolygon multiPolygon) {
            for (Polygon polygon : multiPolygon) {
                this.visit(polygon);
            }
            return null;
        }

        public Void visit(Point point) {
            if (!point.isEmpty()) {
                this.geometries.add((XYGeometry)ShapeUtils.toLuceneXYPoint(point));
            }
            return null;
        }

        public Void visit(Polygon polygon) {
            if (!polygon.isEmpty()) {
                this.geometries.add((XYGeometry)ShapeUtils.toLuceneXYPolygon(polygon));
            }
            return null;
        }

        public Void visit(Rectangle r) {
            if (!r.isEmpty()) {
                this.geometries.add((XYGeometry)ShapeUtils.toLuceneXYRectangle(r));
            }
            return null;
        }
    }
}

