/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.spatial.index.fielddata;

import org.apache.lucene.geo.XYEncodingUtils;
import org.elasticsearch.xpack.spatial.index.fielddata.CoordinateEncoder;

final class CartesianShapeCoordinateEncoder
implements CoordinateEncoder {
    CartesianShapeCoordinateEncoder() {
    }

    private int encode(double value) {
        if (value == Double.NEGATIVE_INFINITY) {
            return Integer.MIN_VALUE;
        }
        if (value == Double.POSITIVE_INFINITY) {
            return Integer.MAX_VALUE;
        }
        return XYEncodingUtils.encode((float)((float)value));
    }

    private double decode(int value) {
        if (value == Integer.MIN_VALUE) {
            return Double.NEGATIVE_INFINITY;
        }
        if (value == Integer.MAX_VALUE) {
            return Double.POSITIVE_INFINITY;
        }
        return XYEncodingUtils.decode((int)value);
    }

    @Override
    public int encodeX(double x) {
        return this.encode(x);
    }

    @Override
    public int encodeY(double y) {
        return this.encode(y);
    }

    @Override
    public double decodeX(int x) {
        return this.decode(x);
    }

    @Override
    public double decodeY(int y) {
        return this.decode(y);
    }

    @Override
    public double normalizeX(double x) {
        return x;
    }

    @Override
    public double normalizeY(double y) {
        return y;
    }
}

