/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories.blobstore.testkit;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionRunnable;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.blobstore.BlobContainer;
import org.elasticsearch.common.blobstore.BlobPath;
import org.elasticsearch.common.blobstore.OptionalBytesReference;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.util.ByteUtils;
import org.elasticsearch.repositories.RepositoriesService;
import org.elasticsearch.repositories.Repository;
import org.elasticsearch.repositories.blobstore.BlobStoreRepository;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.transport.TransportService;

public class RegisterAnalyzeAction
extends ActionType<ActionResponse.Empty> {
    private static final Logger logger = LogManager.getLogger(RegisterAnalyzeAction.class);
    public static final RegisterAnalyzeAction INSTANCE = new RegisterAnalyzeAction();
    public static final String NAME = "cluster:admin/repository/analyze/register";

    private RegisterAnalyzeAction() {
        super(NAME, in -> ActionResponse.Empty.INSTANCE);
    }

    static long longFromBytes(BytesReference bytesReference) {
        if (bytesReference.length() == 0) {
            return 0L;
        }
        if (bytesReference.length() == 8) {
            long l;
            ByteArrayOutputStream baos = new ByteArrayOutputStream(8);
            try {
                bytesReference.writeTo((OutputStream)baos);
                byte[] bytes = baos.toByteArray();
                assert (bytes.length == 8);
                l = ByteUtils.readLongBE((byte[])bytes, (int)0);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        baos.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    assert (false) : "no IO takes place";
                    throw new IllegalStateException("unexpected conversion error", e);
                }
            }
            baos.close();
            return l;
        }
        throw new IllegalArgumentException("cannot read long from BytesReference of length " + bytesReference.length());
    }

    static BytesReference bytesFromLong(long value) {
        if (value == 0L) {
            return BytesArray.EMPTY;
        }
        byte[] bytes = new byte[8];
        ByteUtils.writeLongBE((long)value, (byte[])bytes, (int)0);
        return new BytesArray(bytes);
    }

    public static class Request
    extends ActionRequest {
        private final String repositoryName;
        private final String containerPath;
        private final String registerName;
        private final int requestCount;
        private final int initialRead;

        public Request(String repositoryName, String containerPath, String registerName, int requestCount, int initialRead) {
            this.repositoryName = repositoryName;
            this.containerPath = containerPath;
            this.registerName = registerName;
            this.requestCount = requestCount;
            this.initialRead = initialRead;
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            assert (in.getTransportVersion().onOrAfter((VersionId)TransportVersion.V_8_8_0));
            this.repositoryName = in.readString();
            this.containerPath = in.readString();
            this.registerName = in.readString();
            this.requestCount = in.readVInt();
            this.initialRead = in.readVInt();
        }

        public void writeTo(StreamOutput out) throws IOException {
            assert (out.getTransportVersion().onOrAfter((VersionId)TransportVersion.V_8_8_0));
            super.writeTo(out);
            out.writeString(this.repositoryName);
            out.writeString(this.containerPath);
            out.writeString(this.registerName);
            out.writeVInt(this.requestCount);
            out.writeVInt(this.initialRead);
        }

        public ActionRequestValidationException validate() {
            return null;
        }

        public String getRepositoryName() {
            return this.repositoryName;
        }

        public String getContainerPath() {
            return this.containerPath;
        }

        public String getRegisterName() {
            return this.registerName;
        }

        public int getRequestCount() {
            return this.requestCount;
        }

        public int getInitialRead() {
            return this.initialRead;
        }

        public Task createTask(long id, String type, String action, TaskId parentTaskId, Map<String, String> headers) {
            return new CancellableTask(id, type, action, this.getDescription(), parentTaskId, headers);
        }

        public String toString() {
            return this.getDescription();
        }

        public String getDescription() {
            return Strings.format((String)"RegisterAnalyzeAction.Request{repositoryName='%s', containerPath='%s', registerName='%s', requestCount='%d', initialRead='%d'}", (Object[])new Object[]{this.repositoryName, this.containerPath, this.registerName, this.requestCount, this.initialRead});
        }
    }

    public static class TransportAction
    extends HandledTransportAction<Request, ActionResponse.Empty> {
        private static final Logger logger = logger;
        private final RepositoriesService repositoriesService;
        private final ExecutorService executor;

        @Inject
        public TransportAction(TransportService transportService, ActionFilters actionFilters, RepositoriesService repositoriesService) {
            super(RegisterAnalyzeAction.NAME, transportService, actionFilters, Request::new, "snapshot");
            this.repositoriesService = repositoriesService;
            this.executor = transportService.getThreadPool().executor("snapshot");
        }

        protected void doExecute(final Task task, final Request request, ActionListener<ActionResponse.Empty> outerListenerOld) {
            final ActionListener outerListener = ActionListener.assertOnce(outerListenerOld);
            Repository repository = this.repositoriesService.repository(request.getRepositoryName());
            if (!(repository instanceof BlobStoreRepository)) {
                throw new IllegalArgumentException("repository [" + request.getRepositoryName() + "] is not a blob-store repository");
            }
            if (repository.isReadOnly()) {
                throw new IllegalArgumentException("repository [" + request.getRepositoryName() + "] is read-only");
            }
            BlobStoreRepository blobStoreRepository = (BlobStoreRepository)repository;
            BlobPath path = blobStoreRepository.basePath().add(request.getContainerPath());
            final BlobContainer blobContainer = blobStoreRepository.blobStore().blobContainer(path);
            logger.trace("handling [{}]", (Object)request);
            assert (task instanceof CancellableTask);
            final String registerName = request.getRegisterName();
            ActionListener<OptionalBytesReference> initialValueListener = new ActionListener<OptionalBytesReference>(){

                public void onResponse(OptionalBytesReference maybeInitialBytes) {
                    long initialValue = maybeInitialBytes.isPresent() ? RegisterAnalyzeAction.longFromBytes(maybeInitialBytes.bytesReference()) : 0L;
                    ActionListener.run((ActionListener)outerListener.map(ignored -> ActionResponse.Empty.INSTANCE), l -> {
                        if (initialValue < 0L || initialValue >= (long)request.getRequestCount()) {
                            throw new IllegalStateException("register holds unexpected value [" + initialValue + "]");
                        }
                        class Execution
                        extends ActionRunnable<Void> {
                            private long currentValue;
                            private final ActionListener<OptionalBytesReference> witnessListener;
                            final /* synthetic */ ActionListener val$l;
                            final /* synthetic */ Task val$task;
                            final /* synthetic */ BlobContainer val$blobContainer;
                            final /* synthetic */ String val$registerName;
                            final /* synthetic */ Request val$request;

                            Execution(long currentValue) {
                                this.val$l = actionListener;
                                this.val$task = task;
                                this.val$blobContainer = blobContainer;
                                this.val$registerName = string;
                                this.val$request = request;
                                super(actionListener);
                                this.currentValue = currentValue;
                                this.witnessListener = this.listener.delegateFailure(this::handleWitness);
                            }

                            protected void doRun() {
                                if (!((CancellableTask)this.val$task).notifyIfCancelled(this.listener)) {
                                    this.val$blobContainer.compareAndExchangeRegister(this.val$registerName, RegisterAnalyzeAction.bytesFromLong(this.currentValue), RegisterAnalyzeAction.bytesFromLong(this.currentValue + 1L), this.witnessListener);
                                }
                            }

                            private void handleWitness(ActionListener<Void> delegate, OptionalBytesReference witnessOrEmpty) {
                                if (!witnessOrEmpty.isPresent()) {
                                    executor.execute((Runnable)((Object)this));
                                    return;
                                }
                                long witness = RegisterAnalyzeAction.longFromBytes(witnessOrEmpty.bytesReference());
                                if (witness == this.currentValue) {
                                    delegate.onResponse(null);
                                } else if (witness < this.currentValue || witness >= (long)this.val$request.getRequestCount()) {
                                    delegate.onFailure((Exception)new IllegalStateException("register holds unexpected value [" + witness + "]"));
                                } else {
                                    this.currentValue = witness;
                                    executor.execute((Runnable)((Object)this));
                                }
                            }
                        }
                        new Execution(initialValue).run();
                    });
                }

                public void onFailure(Exception e) {
                    if (e instanceof UnsupportedOperationException) {
                        outerListener.onResponse((Object)ActionResponse.Empty.INSTANCE);
                    } else {
                        outerListener.onFailure(e);
                    }
                }
            };
            if (request.getInitialRead() > request.getRequestCount()) {
                blobContainer.getRegister(registerName, (ActionListener)initialValueListener);
            } else {
                blobContainer.compareAndExchangeRegister(registerName, RegisterAnalyzeAction.bytesFromLong(request.getInitialRead()), RegisterAnalyzeAction.bytesFromLong(request.getInitialRead() == request.getRequestCount() ? (long)(request.getRequestCount() + 1) : (long)request.getInitialRead()), (ActionListener)initialValueListener);
            }
        }
    }
}

