/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.searchablesnapshots.store.input;

import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.function.LongConsumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.store.IOContext;
import org.elasticsearch.blobcache.BlobCacheUtils;
import org.elasticsearch.blobcache.common.ByteBufferReference;
import org.elasticsearch.blobcache.common.ByteRange;
import org.elasticsearch.blobcache.shared.SharedBlobCacheService;
import org.elasticsearch.blobcache.shared.SharedBytes;
import org.elasticsearch.index.snapshots.blobstore.BlobStoreIndexShardSnapshot;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.searchablesnapshots.store.IndexInputStats;
import org.elasticsearch.xpack.searchablesnapshots.store.SearchableSnapshotDirectory;
import org.elasticsearch.xpack.searchablesnapshots.store.input.MetadataCachingIndexInput;

public class FrozenIndexInput
extends MetadataCachingIndexInput {
    private static final Logger logger = LogManager.getLogger(FrozenIndexInput.class);
    private final SharedBlobCacheService.CacheFile cacheFile;

    public FrozenIndexInput(String name, SearchableSnapshotDirectory directory, BlobStoreIndexShardSnapshot.FileInfo fileInfo, IOContext context, IndexInputStats stats, int rangeSize, int recoveryRangeSize) {
        this(name, directory, fileInfo, context, stats, 0L, 0L, fileInfo.length(), new MetadataCachingIndexInput.CacheFileReference(directory, fileInfo.physicalName(), fileInfo.length()), directory.getFrozenCacheFile(name, fileInfo.length()), rangeSize, recoveryRangeSize, directory.getBlobCacheByteRange(name, fileInfo.length()), ByteRange.EMPTY);
        stats.incrementOpenCount();
    }

    private FrozenIndexInput(String name, SearchableSnapshotDirectory directory, BlobStoreIndexShardSnapshot.FileInfo fileInfo, IOContext context, IndexInputStats stats, long offset, long compoundFileOffset, long length, MetadataCachingIndexInput.CacheFileReference cacheFileReference, SharedBlobCacheService.CacheFile cacheFile, int defaultRangeSize, int recoveryRangeSize, ByteRange headerBlobCacheByteRange, ByteRange footerBlobCacheByteRange) {
        super(logger, name, directory, fileInfo, context, stats, offset, compoundFileOffset, length, cacheFileReference, defaultRangeSize, recoveryRangeSize, headerBlobCacheByteRange, footerBlobCacheByteRange);
        this.cacheFile = cacheFile.copy();
    }

    @Override
    protected void readWithoutBlobCache(ByteBuffer b) throws Exception {
        long position = this.getAbsolutePosition();
        int length = b.remaining();
        if (this.cacheFile.tryRead(b, position)) {
            this.stats.addCachedBytesRead(length);
            return;
        }
        this.readWithoutBlobCacheSlow(b, position, length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readWithoutBlobCacheSlow(ByteBuffer b, long position, int length) throws Exception {
        ByteBufferReference byteBufferReference = new ByteBufferReference(b);
        logger.trace("readInternal: read [{}-{}] from [{}]", (Object)position, (Object)(position + (long)length), (Object)this);
        try {
            ByteRange rangeToWrite = BlobCacheUtils.computeRange((long)(this.directory.isRecoveryFinalized() ? (long)this.defaultRangeSize : (long)this.recoveryRangeSize), (long)position, (long)length, (long)this.fileInfo.length());
            assert (rangeToWrite.start() <= position && position + (long)length <= rangeToWrite.end()) : "[" + position + "-" + (position + (long)length) + "] vs " + rangeToWrite;
            ByteRange rangeToRead = ByteRange.of((long)position, (long)(position + (long)length));
            int bytesRead = this.cacheFile.populateAndRead(rangeToWrite, rangeToRead, (channel, pos, relativePos, len) -> {
                logger.trace("{}: reading logical {} channel {} pos {} length {} (details: {})", (Object)this.fileInfo.physicalName(), (Object)rangeToRead.start(), (Object)pos, (Object)relativePos, (Object)length, (Object)this.cacheFile);
                int read = SharedBytes.readCacheFile((SharedBytes.IO)channel, (long)pos, (long)relativePos, (long)len, (ByteBufferReference)byteBufferReference);
                this.stats.addCachedBytesRead(read);
                return read;
            }, (channel, channelPos, relativePos, len, progressUpdater) -> {
                long startTimeNanos = this.stats.currentTimeNanos();
                try (InputStream input = this.openInputStreamFromBlobStore(rangeToWrite.start() + relativePos, len);){
                    assert (ThreadPool.assertCurrentThreadPool((String[])new String[]{"searchable_snapshots_cache_fetch_async"}));
                    logger.trace("{}: writing channel {} pos {} length {} (details: {})", (Object)this.fileInfo.physicalName(), (Object)channelPos, (Object)relativePos, (Object)len, (Object)this.cacheFile);
                    SharedBytes.copyToCacheFileAligned((SharedBytes.IO)channel, (InputStream)input, (long)channelPos, (long)relativePos, (long)len, (LongConsumer)progressUpdater, (ByteBuffer)((ByteBuffer)writeBuffer.get()).clear());
                    long endTimeNanos = this.stats.currentTimeNanos();
                    this.stats.addCachedBytesWritten(len, endTimeNanos - startTimeNanos);
                }
            });
            assert (bytesRead == length) : bytesRead + " vs " + length;
            byteBufferReference.finish(bytesRead);
        }
        finally {
            byteBufferReference.finish(0);
        }
    }

    @Override
    protected MetadataCachingIndexInput doSlice(String sliceName, long sliceOffset, long sliceLength, ByteRange sliceHeaderByteRange, ByteRange sliceFooterByteRange, long sliceCompoundFileOffset) {
        return new FrozenIndexInput(sliceName, this.directory, this.fileInfo, this.context, this.stats, sliceOffset, sliceCompoundFileOffset, sliceLength, this.cacheFileReference, this.cacheFile, this.defaultRangeSize, this.recoveryRangeSize, sliceHeaderByteRange, sliceFooterByteRange);
    }
}

