/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.root;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.Scope;
import org.elasticsearch.rest.ServerlessScope;
import org.elasticsearch.rest.action.RestBuilderListener;
import org.elasticsearch.rest.root.MainAction;
import org.elasticsearch.rest.root.MainRequest;
import org.elasticsearch.rest.root.MainResponse;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

@ServerlessScope(value=Scope.PUBLIC)
public class RestMainAction
extends BaseRestHandler {
    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.GET, "/"), new RestHandler.Route(RestRequest.Method.HEAD, "/"));
    }

    public String getName() {
        return "main_action";
    }

    public BaseRestHandler.RestChannelConsumer prepareRequest(final RestRequest request, NodeClient client) throws IOException {
        return channel -> client.execute((ActionType)MainAction.INSTANCE, (ActionRequest)new MainRequest(), (ActionListener)new RestBuilderListener<MainResponse>(channel){

            public RestResponse buildResponse(MainResponse mainResponse, XContentBuilder builder) throws Exception {
                return RestMainAction.convertMainResponse(mainResponse, request, builder);
            }
        });
    }

    static RestResponse convertMainResponse(MainResponse response, RestRequest request, XContentBuilder builder) throws IOException {
        if (!request.hasParam("pretty")) {
            builder.prettyPrint().lfAtEnd();
        }
        response.toXContent(builder, (ToXContent.Params)request);
        return new RestResponse(RestStatus.OK, builder);
    }

    public boolean canTripCircuitBreaker() {
        return false;
    }
}

