/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories.azure;

import com.azure.storage.blob.models.BlobStorageException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.NoSuchFileException;
import java.util.Iterator;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.util.Throwables;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.blobstore.BlobContainer;
import org.elasticsearch.common.blobstore.BlobPath;
import org.elasticsearch.common.blobstore.DeleteResult;
import org.elasticsearch.common.blobstore.OptionalBytesReference;
import org.elasticsearch.common.blobstore.support.AbstractBlobContainer;
import org.elasticsearch.common.blobstore.support.BlobMetadata;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.core.CheckedConsumer;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.repositories.azure.AzureBlobStore;
import org.elasticsearch.repositories.azure.LocationMode;

public class AzureBlobContainer
extends AbstractBlobContainer {
    private final Logger logger = LogManager.getLogger(AzureBlobContainer.class);
    private final AzureBlobStore blobStore;
    private final String keyPath;

    AzureBlobContainer(BlobPath path, AzureBlobStore blobStore) {
        super(path);
        this.blobStore = blobStore;
        this.keyPath = path.buildAsString();
    }

    public boolean blobExists(String blobName) throws IOException {
        this.logger.trace("blobExists({})", (Object)blobName);
        return this.blobStore.blobExists(this.buildKey(blobName));
    }

    private InputStream openInputStream(String blobName, long position, @Nullable Long length) throws IOException {
        String blobKey = this.buildKey(blobName);
        this.logger.trace("readBlob({}) from position [{}] with length [{}]", (Object)blobName, (Object)position, length != null ? length : "unlimited");
        if (this.blobStore.getLocationMode() == LocationMode.SECONDARY_ONLY && !this.blobExists(blobName)) {
            throw new NoSuchFileException("Blob [" + blobKey + "] not found");
        }
        try {
            return this.blobStore.getInputStream(blobKey, position, length);
        }
        catch (Exception e) {
            BlobStorageException blobStorageException;
            Throwable rootCause = Throwables.getRootCause((Throwable)e);
            if (rootCause instanceof BlobStorageException && (blobStorageException = (BlobStorageException)rootCause).getStatusCode() == 404) {
                throw new NoSuchFileException("Blob [" + blobKey + "] not found");
            }
            throw new IOException("Unable to get input stream for blob [" + blobKey + "]", e);
        }
    }

    public InputStream readBlob(String blobName) throws IOException {
        return this.openInputStream(blobName, 0L, null);
    }

    public InputStream readBlob(String blobName, long position, long length) throws IOException {
        return this.openInputStream(blobName, position, length);
    }

    public long readBlobPreferredLength() {
        return this.blobStore.getReadChunkSize();
    }

    public void writeBlob(String blobName, InputStream inputStream, long blobSize, boolean failIfAlreadyExists) throws IOException {
        this.logger.trace("writeBlob({}, stream, {})", (Object)this.buildKey(blobName), (Object)blobSize);
        this.blobStore.writeBlob(this.buildKey(blobName), inputStream, blobSize, failIfAlreadyExists);
    }

    public void writeBlobAtomic(String blobName, BytesReference bytes, boolean failIfAlreadyExists) throws IOException {
        this.writeBlob(blobName, bytes, failIfAlreadyExists);
    }

    public void writeBlob(String blobName, BytesReference bytes, boolean failIfAlreadyExists) throws IOException {
        this.blobStore.writeBlob(this.buildKey(blobName), bytes, failIfAlreadyExists);
    }

    public void writeMetadataBlob(String blobName, boolean failIfAlreadyExists, boolean atomic, CheckedConsumer<OutputStream, IOException> writer) throws IOException {
        this.blobStore.writeBlob(this.buildKey(blobName), failIfAlreadyExists, writer);
    }

    public DeleteResult delete() throws IOException {
        return this.blobStore.deleteBlobDirectory(this.keyPath);
    }

    public void deleteBlobsIgnoringIfNotExists(final Iterator<String> blobNames) throws IOException {
        this.blobStore.deleteBlobs(new Iterator<String>(){

            @Override
            public boolean hasNext() {
                return blobNames.hasNext();
            }

            @Override
            public String next() {
                return AzureBlobContainer.this.buildKey((String)blobNames.next());
            }
        });
    }

    public Map<String, BlobMetadata> listBlobsByPrefix(@Nullable String prefix) throws IOException {
        this.logger.trace("listBlobsByPrefix({})", (Object)prefix);
        return this.blobStore.listBlobsByPrefix(this.keyPath, prefix);
    }

    public Map<String, BlobMetadata> listBlobs() throws IOException {
        this.logger.trace("listBlobs()");
        return this.listBlobsByPrefix(null);
    }

    public Map<String, BlobContainer> children() throws IOException {
        BlobPath path = this.path();
        return this.blobStore.children(path);
    }

    protected String buildKey(String blobName) {
        return this.keyPath + (blobName == null ? "" : blobName);
    }

    private boolean skipRegisterOperation(ActionListener<?> listener) {
        return AzureBlobContainer.skipCas(listener) || this.skipIfNotPrimaryOnlyLocationMode(listener);
    }

    private boolean skipIfNotPrimaryOnlyLocationMode(ActionListener<?> listener) {
        if (this.blobStore.getLocationMode() == LocationMode.PRIMARY_ONLY) {
            return false;
        }
        listener.onFailure((Exception)new UnsupportedOperationException(Strings.format((String)"consistent register operations are not supported with location_mode [%s]", (Object[])new Object[]{this.blobStore.getLocationMode()})));
        return true;
    }

    public void getRegister(String key, ActionListener<OptionalBytesReference> listener) {
        if (this.skipRegisterOperation(listener)) {
            return;
        }
        ActionListener.completeWith(listener, () -> this.blobStore.getRegister(this.buildKey(key), this.keyPath, key));
    }

    public void compareAndExchangeRegister(String key, BytesReference expected, BytesReference updated, ActionListener<OptionalBytesReference> listener) {
        if (this.skipRegisterOperation(listener)) {
            return;
        }
        ActionListener.completeWith(listener, () -> this.blobStore.compareAndExchangeRegister(this.buildKey(key), this.keyPath, key, expected, updated));
    }
}

