/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.policy;

import com.azure.core.credential.AzureKeyCredential;
import com.azure.core.http.HttpPipelineCallContext;
import com.azure.core.http.HttpPipelineNextPolicy;
import com.azure.core.http.HttpPipelineNextSyncPolicy;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.HttpPipelineSyncPolicy;
import com.azure.core.implementation.http.HttpHeadersHelper;
import com.azure.core.util.logging.ClientLogger;
import java.util.Locale;
import java.util.Objects;
import reactor.core.publisher.Mono;

public final class AzureKeyCredentialPolicy
implements HttpPipelinePolicy {
    private static final ClientLogger LOGGER = new ClientLogger(AzureKeyCredentialPolicy.class);
    private final String name;
    private final String nameLowerCase;
    private final AzureKeyCredential credential;
    private final HttpPipelineSyncPolicy inner = new HttpPipelineSyncPolicy(){

        @Override
        protected void beforeSendingRequest(HttpPipelineCallContext context) {
            if ("http".equals(context.getHttpRequest().getUrl().getProtocol())) {
                throw LOGGER.logExceptionAsError(new IllegalStateException("Key credentials require HTTPS to prevent leaking the key."));
            }
            HttpHeadersHelper.setNoKeyFormatting(context.getHttpRequest().getHeaders(), AzureKeyCredentialPolicy.this.nameLowerCase, AzureKeyCredentialPolicy.this.name, AzureKeyCredentialPolicy.this.credential.getKey());
        }
    };

    public AzureKeyCredentialPolicy(String name, AzureKeyCredential credential) {
        Objects.requireNonNull(credential, "'credential' cannot be null.");
        Objects.requireNonNull(name, "'name' cannot be null.");
        if (name.isEmpty()) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException("'name' cannot be empty."));
        }
        this.name = name;
        this.nameLowerCase = name.toLowerCase(Locale.ROOT);
        this.credential = credential;
    }

    @Override
    public Mono<HttpResponse> process(HttpPipelineCallContext context, HttpPipelineNextPolicy next) {
        return this.inner.process(context, next);
    }

    @Override
    public HttpResponse processSync(HttpPipelineCallContext context, HttpPipelineNextSyncPolicy next) {
        return this.inner.processSync(context, next);
    }
}

