/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.percolator;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.ScorerSupplier;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.Bits;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.core.CheckedFunction;

final class PercolateQuery
extends Query
implements Accountable {
    private static final float MATCH_COST = 1000.0f;
    private final String name;
    private final QueryStore queryStore;
    private final List<BytesReference> documents;
    private final Query candidateMatchesQuery;
    private final Query verifiedMatchesQuery;
    private final IndexSearcher percolatorIndexSearcher;
    private final Query nonNestedDocsFilter;

    PercolateQuery(String name, QueryStore queryStore, List<BytesReference> documents, Query candidateMatchesQuery, IndexSearcher percolatorIndexSearcher, Query nonNestedDocsFilter, Query verifiedMatchesQuery) {
        this.name = name;
        this.documents = Objects.requireNonNull(documents);
        this.candidateMatchesQuery = Objects.requireNonNull(candidateMatchesQuery);
        this.queryStore = Objects.requireNonNull(queryStore);
        this.percolatorIndexSearcher = Objects.requireNonNull(percolatorIndexSearcher);
        this.nonNestedDocsFilter = nonNestedDocsFilter;
        this.verifiedMatchesQuery = Objects.requireNonNull(verifiedMatchesQuery);
    }

    public Query rewrite(IndexSearcher searcher) throws IOException {
        Query rewritten = this.candidateMatchesQuery.rewrite(searcher);
        if (rewritten != this.candidateMatchesQuery) {
            return new PercolateQuery(this.name, this.queryStore, this.documents, rewritten, this.percolatorIndexSearcher, this.nonNestedDocsFilter, this.verifiedMatchesQuery);
        }
        return this;
    }

    public Weight createWeight(IndexSearcher searcher, final ScoreMode scoreMode, float boost) throws IOException {
        final Weight verifiedMatchesWeight = this.verifiedMatchesQuery.createWeight(searcher, ScoreMode.COMPLETE_NO_SCORES, boost);
        final Weight candidateMatchesWeight = this.candidateMatchesQuery.createWeight(searcher, ScoreMode.COMPLETE_NO_SCORES, boost);
        return new Weight(this){

            public Explanation explain(LeafReaderContext leafReaderContext, int docId) throws IOException {
                TwoPhaseIterator twoPhaseIterator;
                int result;
                Scorer scorer = this.scorer(leafReaderContext);
                if (scorer != null && (result = (twoPhaseIterator = scorer.twoPhaseIterator()).approximation().advance(docId)) == docId && twoPhaseIterator.matches()) {
                    if (scoreMode.needsScores()) {
                        CheckedFunction<Integer, Query, IOException> percolatorQueries = PercolateQuery.this.queryStore.getQueries(leafReaderContext);
                        Query query = (Query)percolatorQueries.apply((Object)docId);
                        Explanation detail = PercolateQuery.this.percolatorIndexSearcher.explain(query, 0);
                        return Explanation.match((Number)Float.valueOf(scorer.score()), (String)"PercolateQuery", (Explanation[])new Explanation[]{detail});
                    }
                    return Explanation.match((Number)Float.valueOf(scorer.score()), (String)"PercolateQuery", (Explanation[])new Explanation[0]);
                }
                return Explanation.noMatch((String)"PercolateQuery", (Explanation[])new Explanation[0]);
            }

            public Scorer scorer(LeafReaderContext leafReaderContext) throws IOException {
                Scorer approximation = candidateMatchesWeight.scorer(leafReaderContext);
                if (approximation == null) {
                    return null;
                }
                final CheckedFunction<Integer, Query, IOException> percolatorQueries = PercolateQuery.this.queryStore.getQueries(leafReaderContext);
                if (scoreMode.needsScores()) {
                    return new BaseScorer(this, approximation){
                        float score;

                        @Override
                        boolean matchDocId(int docId) throws IOException {
                            Query query = (Query)percolatorQueries.apply((Object)docId);
                            if (query != null) {
                                if (PercolateQuery.this.nonNestedDocsFilter != null) {
                                    query = new BooleanQuery.Builder().add(query, BooleanClause.Occur.MUST).add(PercolateQuery.this.nonNestedDocsFilter, BooleanClause.Occur.FILTER).build();
                                }
                                TopDocs topDocs = PercolateQuery.this.percolatorIndexSearcher.search(query, 1);
                                if (topDocs.scoreDocs.length > 0) {
                                    this.score = topDocs.scoreDocs[0].score;
                                    return true;
                                }
                                return false;
                            }
                            return false;
                        }

                        public float score() throws IOException {
                            return this.score;
                        }
                    };
                }
                ScorerSupplier verifiedDocsScorer = verifiedMatchesWeight.scorerSupplier(leafReaderContext);
                final Bits verifiedDocsBits = Lucene.asSequentialAccessBits((int)leafReaderContext.reader().maxDoc(), (ScorerSupplier)verifiedDocsScorer);
                return new BaseScorer(this, approximation){

                    public float score() throws IOException {
                        return 0.0f;
                    }

                    @Override
                    boolean matchDocId(int docId) throws IOException {
                        if (verifiedDocsBits.get(docId)) {
                            return true;
                        }
                        Query query = (Query)percolatorQueries.apply((Object)docId);
                        if (query == null) {
                            return false;
                        }
                        if (PercolateQuery.this.nonNestedDocsFilter != null) {
                            query = new BooleanQuery.Builder().add(query, BooleanClause.Occur.MUST).add(PercolateQuery.this.nonNestedDocsFilter, BooleanClause.Occur.FILTER).build();
                        }
                        return Lucene.exists((IndexSearcher)PercolateQuery.this.percolatorIndexSearcher, (Query)query);
                    }
                };
            }

            public boolean isCacheable(LeafReaderContext ctx) {
                return false;
            }
        };
    }

    String getName() {
        return this.name;
    }

    IndexSearcher getPercolatorIndexSearcher() {
        return this.percolatorIndexSearcher;
    }

    boolean excludesNestedDocs() {
        return this.nonNestedDocsFilter != null;
    }

    List<BytesReference> getDocuments() {
        return this.documents;
    }

    QueryStore getQueryStore() {
        return this.queryStore;
    }

    Query getCandidateMatchesQuery() {
        return this.candidateMatchesQuery;
    }

    Query getVerifiedMatchesQuery() {
        return this.verifiedMatchesQuery;
    }

    public boolean equals(Object o) {
        return this == o;
    }

    public int hashCode() {
        return System.identityHashCode((Object)this);
    }

    public String toString(String s) {
        StringBuilder sources = new StringBuilder();
        for (BytesReference document : this.documents) {
            sources.append(document.utf8ToString());
            sources.append('\n');
        }
        return "PercolateQuery{document_sources={" + sources + "},inner={" + this.candidateMatchesQuery.toString(s) + "}}";
    }

    public void visit(QueryVisitor visitor) {
        visitor.visitLeaf((Query)this);
    }

    public long ramBytesUsed() {
        long ramUsed = 0L;
        for (BytesReference document : this.documents) {
            ramUsed += document.ramBytesUsed();
        }
        return ramUsed;
    }

    @FunctionalInterface
    static interface QueryStore {
        public CheckedFunction<Integer, Query, IOException> getQueries(LeafReaderContext var1) throws IOException;
    }

    static abstract class BaseScorer
    extends Scorer {
        final Scorer approximation;

        BaseScorer(Weight weight, Scorer approximation) {
            super(weight);
            this.approximation = approximation;
        }

        public final DocIdSetIterator iterator() {
            return TwoPhaseIterator.asDocIdSetIterator((TwoPhaseIterator)this.twoPhaseIterator());
        }

        public final TwoPhaseIterator twoPhaseIterator() {
            return new TwoPhaseIterator(this.approximation.iterator()){

                public boolean matches() throws IOException {
                    return this.matchDocId(this.approximation.docID());
                }

                public float matchCost() {
                    return 1000.0f;
                }
            };
        }

        public final int docID() {
            return this.approximation.docID();
        }

        abstract boolean matchDocId(int var1) throws IOException;

        public float getMaxScore(int upTo) throws IOException {
            return Float.MAX_VALUE;
        }
    }
}

