/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.lucene.bwc.codecs.lucene50;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.backward_codecs.store.EndiannessReverserUtil;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.SegmentInfoFormat;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.util.Version;

@Deprecated
public class Lucene50SegmentInfoFormat
extends SegmentInfoFormat {
    public static final String SI_EXTENSION = "si";
    static final String CODEC_NAME = "Lucene50SegmentInfo";
    static final int VERSION_SAFE_MAPS = 1;
    static final int VERSION_START = 1;
    static final int VERSION_CURRENT = 1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SegmentInfo read(Directory dir, String segment, byte[] segmentID, IOContext context) throws IOException {
        String fileName = IndexFileNames.segmentFileName((String)segment, (String)"", (String)SI_EXTENSION);
        try (ChecksumIndexInput input = EndiannessReverserUtil.openChecksumInput((Directory)dir, (String)fileName, (IOContext)context);){
            Throwable priorE = null;
            SegmentInfo si = null;
            try {
                CodecUtil.checkIndexHeader((DataInput)input, (String)CODEC_NAME, (int)1, (int)1, (byte[])segmentID, (String)"");
                Version version = Version.fromBits((int)input.readInt(), (int)input.readInt(), (int)input.readInt());
                int docCount = input.readInt();
                if (docCount < 0) {
                    throw new CorruptIndexException("invalid docCount: " + docCount, (DataInput)input);
                }
                boolean isCompoundFile = input.readByte() == 1;
                Map diagnostics = input.readMapOfStrings();
                Set files = input.readSetOfStrings();
                Map attributes = input.readMapOfStrings();
                si = new SegmentInfo(dir, version, null, segment, docCount, isCompoundFile, null, diagnostics, segmentID, attributes, null);
                si.setFiles((Collection)files);
            }
            catch (Throwable exception) {
                priorE = exception;
            }
            finally {
                CodecUtil.checkFooter((ChecksumIndexInput)input, (Throwable)priorE);
            }
            SegmentInfo segmentInfo = si;
            return segmentInfo;
        }
    }

    public void write(Directory dir, SegmentInfo si, IOContext ioContext) {
        throw new UnsupportedOperationException("this codec can only be used for reading");
    }
}

